/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPanel;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class PDFPagePanel
extends JPanel {
    private PDPage page;
    private PageDrawer drawer = new PageDrawer();
    private Dimension pageDimension = null;
    private Dimension drawDimension = null;

    public void setPage(PDPage pdfPage) {
        this.page = pdfPage;
        PDRectangle pageSize = this.page.findMediaBox();
        this.drawDimension = pageSize.createDimension();
        int rotation = this.page.findRotation();
        this.pageDimension = rotation == 90 || rotation == 270 ? new Dimension(this.drawDimension.height, this.drawDimension.width) : this.drawDimension;
        this.setSize(this.pageDimension);
        this.setBackground(Color.white);
    }

    public void paint(Graphics g) {
        try {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int rotation = this.page.findRotation();
            if (rotation == 90 || rotation == 270) {
                Graphics2D g2D = (Graphics2D)g;
                g2D.translate(this.pageDimension.getWidth(), 0.0);
                g2D.rotate(Math.toRadians(rotation));
            }
            this.drawer.drawPage(g, this.page, this.drawDimension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

