/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.error.EDAMErrorCode;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.RelatedQuery;
import com.evernote.edam.notestore.RelatedResult;
import com.evernote.edam.notestore.RelatedResultSpec;
import com.evernote.edam.type.Note;
import com.evernote.thrift.TException;
import com.trolltech.qt.core.QMutex;
import com.trolltech.qt.core.QObject;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.signals.ENRelatedNotesSignal;
import cx.fbn.nevernote.signals.LimitSignal;
import cx.fbn.nevernote.threads.SyncRunner;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class ENRelatedNotesRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    private final SyncRunner syncRunner;
    public volatile ENRelatedNotesSignal enRelatedNotesSignal;
    public QMutex mutex;
    private volatile boolean keepRunning;
    private volatile LinkedBlockingQueue<String> workQueue;
    private volatile LinkedBlockingQueue<Pair<String, List<String>>> resultQueue;
    public volatile LimitSignal limitSignal;

    public ENRelatedNotesRunner(SyncRunner syncRunner, String logname) {
        this.logger = new ApplicationLogger(logname);
        this.syncRunner = syncRunner;
        this.enRelatedNotesSignal = new ENRelatedNotesSignal();
        this.mutex = new QMutex();
        this.keepRunning = true;
        this.workQueue = new LinkedBlockingQueue();
        this.resultQueue = new LinkedBlockingQueue();
        this.limitSignal = new LimitSignal();
    }

    @Override
    public void run() {
        this.thread().setPriority(1);
        this.logger.log(this.logger.MEDIUM, "ENRelatedNotes\u30b9\u30ec\u30c3\u30c9\u958b\u59cb");
        while (this.keepRunning) {
            try {
                String work = this.workQueue.take();
                this.mutex.lock();
                if (work.startsWith("GET")) {
                    String guid = work.replace("GET ", "");
                    this.logger.log(this.logger.EXTREME, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u53d6\u5f97\u958b\u59cb guid = " + guid);
                    List<Note> relatedNotes = this.getENRelatedNotes(guid);
                    Pair resultPair = new Pair();
                    resultPair.setFirst(guid);
                    if (relatedNotes == null) {
                        this.logger.log(this.logger.EXTREME, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557");
                    } else if (relatedNotes.isEmpty()) {
                        this.logger.log(this.logger.EXTREME, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u306e\u53d6\u5f97\u306b\u6210\u529f\u3000\u95a2\u9023\u30ce\u30fc\u30c8\u306f\u5b58\u5728\u3057\u306a\u304b\u3063\u305f");
                        resultPair.setSecond(new ArrayList());
                    } else {
                        this.logger.log(this.logger.EXTREME, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u306e\u53d6\u5f97\u306b\u6210\u529f\u3000\u95a2\u9023\u30ce\u30fc\u30c8\u306f\u5b58\u5728\u3057\u305f");
                        ArrayList<String> relatedNoteGuids = new ArrayList<String>();
                        for (Note relatedNote : relatedNotes) {
                            relatedNoteGuids.add(relatedNote.getGuid());
                        }
                        resultPair.setSecond(relatedNoteGuids);
                    }
                    this.resultQueue.offer(resultPair);
                    this.enRelatedNotesSignal.getENRelatedNotesFinished.emit();
                    this.logger.log(this.logger.EXTREME, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u53d6\u5f97\u5b8c\u4e86 guid = " + guid);
                } else if (work.startsWith("STOP")) {
                    this.logger.log(this.logger.MEDIUM, "ENRelatedNotes\u30b9\u30ec\u30c3\u30c9\u505c\u6b62");
                    this.keepRunning = false;
                }
                this.mutex.unlock();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private List<Note> getENRelatedNotes(String guid) {
        RelatedResult result = this.getENRelatedResult(guid);
        ArrayList<Note> relatedNotes = new ArrayList();
        if (result != null) {
            relatedNotes = result.getNotes();
            return relatedNotes;
        }
        return null;
    }

    private RelatedResult getENRelatedResult(String guid) {
        if (!Global.isConnected) {
            return null;
        }
        RelatedQuery rquery = new RelatedQuery();
        rquery.setNoteGuid(guid);
        RelatedResultSpec resultSpec = new RelatedResultSpec();
        resultSpec.setMaxNotes(5);
        if (this.syncRunner != null && this.syncRunner.localNoteStore != null) {
            try {
                RelatedResult result = this.syncRunner.localNoteStore.findRelated(this.syncRunner.authToken, rquery, resultSpec);
                return result;
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.HIGH, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aEDAMUserException");
            }
            catch (EDAMSystemException e) {
                if (e.getErrorCode() == EDAMErrorCode.RATE_LIMIT_REACHED) {
                    this.limitSignal.rateLimitReached.emit((Object)e.getRateLimitDuration());
                }
                this.logger.log(this.logger.HIGH, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aEDAMSystemException");
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.HIGH, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aEDAMnotFoundException guid = " + guid);
            }
            catch (TException e) {
                this.logger.log(this.logger.HIGH, "Evernote\u95a2\u9023\u30ce\u30fc\u30c8\u53d6\u5f97\u4e2d\u306b\u4f8b\u5916\u767a\u751f\uff1aTException");
            }
        }
        return null;
    }

    public boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }

    public boolean addGuid(String guid) {
        return this.workQueue.offer("GET " + guid);
    }

    public boolean addStop() {
        return this.workQueue.offer("STOP");
    }

    public synchronized Pair<String, List<String>> getENRelatedNoteGuids() {
        try {
            return this.resultQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

