/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.config;

import java.io.File;

public class StartupConfig {
    private String name = "NeighborNote";
    private String homeDirPath;
    private String programDirPath;
    private boolean disableViewing = false;
    private boolean syncOnly = false;

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        if (StartupConfig.isNonEmpty(n)) {
            this.name = "NeighborNote-" + n;
        }
    }

    public String getProgramDirPath() {
        if (this.programDirPath == null) {
            this.programDirPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            if (this.programDirPath.endsWith(".jar")) {
                this.programDirPath = this.programDirPath.substring(0, this.programDirPath.lastIndexOf("/"));
            } else {
                if (this.programDirPath.endsWith("/")) {
                    this.programDirPath = this.programDirPath.substring(0, this.programDirPath.length() - 1);
                }
                this.programDirPath = this.programDirPath.substring(0, this.programDirPath.lastIndexOf("/"));
            }
        }
        return this.programDirPath;
    }

    public String getHomeDirPath() {
        if (this.homeDirPath == null) {
            this.homeDirPath = String.valueOf(System.getProperty("user.home")) + File.separator + "." + this.name.toLowerCase() + File.separator;
        }
        return this.homeDirPath;
    }

    public void setHomeDirPath(String path) {
        if (StartupConfig.isNonEmpty(path)) {
            this.homeDirPath = path;
        }
    }

    public void setProgramDirPath(String path) {
        if (StartupConfig.isNonEmpty(path)) {
            this.programDirPath = path;
        }
    }

    public boolean getDisableViewing() {
        return this.disableViewing;
    }

    public void setDisableViewing(boolean disableViewing) {
        this.disableViewing = disableViewing;
    }

    private static boolean isNonEmpty(String n) {
        return n != null && !n.trim().equals("");
    }

    public boolean isSyncOnly() {
        return this.syncOnly;
    }

    public void setSyncOnly(boolean val) {
        this.syncOnly = val;
    }
}

