/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.Reader;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKTokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CJKAnalyzer
extends StopwordAnalyzerBase {
    @Deprecated
    public static final String[] STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with", "", "www"};

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public CJKAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public CJKAnalyzer(Version matchVersion, Set<?> stopwords) {
        super(matchVersion, stopwords);
    }

    @Deprecated
    public CJKAnalyzer(Version matchVersion, String ... stopWords) {
        super(matchVersion, StopFilter.makeStopSet((Version)matchVersion, (String[])stopWords));
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_36)) {
            StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
            TokenFilter result = new CJKWidthFilter((TokenStream)source);
            result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
            result = new CJKBigramFilter((TokenStream)result);
            return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords));
        }
        CJKTokenizer source = new CJKTokenizer(reader);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)new StopFilter(this.matchVersion, (TokenStream)source, (Set)this.stopwords));
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Version.LUCENE_CURRENT, Arrays.asList(STOP_WORDS), false));

        private DefaultSetHolder() {
        }
    }
}

