/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.Utilities;
import com.trolltech.qt.internal.DeploymentSpecException;
import com.trolltech.qt.internal.OSInfo;
import com.trolltech.qt.internal.Reporter;
import com.trolltech.qt.internal.RetroTranslatorHelper;
import com.trolltech.qt.internal.WrongSystemException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLibraryManager {
    public static String DEPLOY_DESCRIPTOR_NAME = "qtjambi-deployment.xml";
    private static final String DEBUG_SUFFIX = "_debuglib";
    private static final boolean VERBOSE_LOADING = System.getProperty("com.trolltech.qt.verbose-loading") != null;
    private static final int LOAD_TRUE = 1;
    private static final int LOAD_FALSE = 2;
    private static final int LOAD_NEVER = 3;
    private static Map<String, LibraryEntry> libraryMap = new HashMap<String, LibraryEntry>();
    private static Map<String, LibraryEntry> neverLoad = new HashMap<String, LibraryEntry>();
    private static List<DeploymentSpec> deploymentSpecs = new ArrayList<DeploymentSpec>();
    private static Reporter reporter = new Reporter();
    private static boolean unpacked = false;

    public static File jambiTempDirBase(String key) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String user = System.getProperty("user.name");
        String arch = System.getProperty("os.arch");
        return new File(tmpDir, "QtJambi_" + user + "_" + arch + "_" + Utilities.VERSION_STRING + "_" + key);
    }

    public static List<String> pluginPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (DeploymentSpec spec : deploymentSpecs) {
            File root = NativeLibraryManager.jambiTempDirBase(spec.key);
            if (spec.pluginPaths == null) continue;
            for (String path : spec.pluginPaths) {
                paths.add(new File(root, path).getAbsolutePath());
            }
        }
        return paths;
    }

    public static void loadLibrary(String library) {
        if (Utilities.configuration == Utilities.Configuration.Debug) {
            library = library + DEBUG_SUFFIX;
        }
        String lib = NativeLibraryManager.jniLibraryName(library);
        NativeLibraryManager.loadNativeLibrary(lib);
    }

    public static void loadQtLibrary(String library) {
        NativeLibraryManager.loadQtLibrary(library, "4");
    }

    public static void loadQtLibrary(String library, String version) {
        String lib = NativeLibraryManager.qtLibraryName(library, version);
        NativeLibraryManager.loadNativeLibrary(lib);
    }

    private static void unpack() {
        if (unpacked) {
            return;
        }
        try {
            NativeLibraryManager.unpack_helper();
            if (VERBOSE_LOADING) {
                System.out.println(reporter.recentReports());
            }
            unpacked = true;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to unpack native libraries, progress so far:\n" + reporter, t);
        }
    }

    private static void unpack_helper() throws Exception {
        ClassLoader loader = NativeLibraryManager.classLoader();
        Enumeration<URL> specs = loader.getResources(DEPLOY_DESCRIPTOR_NAME);
        int count = 0;
        while (specs.hasMoreElements()) {
            int end;
            String eform;
            int start;
            URL url = specs.nextElement();
            if (!url.getProtocol().equals("jar") || (start = (eform = url.toExternalForm()).lastIndexOf(47, (end = eform.length() - DEPLOY_DESCRIPTOR_NAME.length() - 2) - 1) + 1) <= 0 || start >= end) continue;
            String jarName = eform.substring(start, end);
            if (VERBOSE_LOADING) {
                reporter.report("Loading ", jarName, " from ", eform);
            }
            NativeLibraryManager.unpackDeploymentSpec(url, jarName);
            ++count;
        }
        if (count == 0) {
            reporter.report("No '", DEPLOY_DESCRIPTOR_NAME, "' found in classpath, loading libraries via 'java.library.path'");
        }
    }

    private static ClassLoader classLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = NativeLibraryManager.class.getClassLoader();
            assert (loader != null);
        }
        return loader;
    }

    private static void loadNativeLibrary(String lib) {
        try {
            NativeLibraryManager.loadLibrary_helper(lib);
            if (VERBOSE_LOADING) {
                System.out.println(reporter.recentReports());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Loading library failed, progress so far:\n" + reporter, e);
        }
    }

    private static void loadLibrary_helper(String lib) {
        NativeLibraryManager.unpack();
        reporter.report("Loading library: '", lib, "'...");
        LibraryEntry e = neverLoad.get(lib);
        if (e != null) {
            throw new RuntimeException("Library '" + lib + "' cannot be loaded, deploy spec");
        }
        e = libraryMap.get(lib);
        if (e != null) {
            if (e.loaded) {
                reporter.report(" - already loaded, skipping...");
                return;
            }
            reporter.report(" - using deployment spec");
            File libFile = new File(NativeLibraryManager.jambiTempDirBase(e.spec.key), e.name);
            Runtime.getRuntime().load(libFile.getAbsolutePath());
            reporter.report(" - ok!");
            e.loaded = true;
        } else {
            boolean loaded = false;
            String libPaths = System.getProperty("com.trolltech.qt.library-path-override");
            if (libPaths != null && libPaths.length() > 0) {
                reporter.report(" - using 'com.trolltech.qt.library-path-override");
            } else {
                reporter.report(" - using 'java.library.path'");
                libPaths = System.getProperty("java.library.path");
            }
            if (libPaths != null) {
                String[] paths;
                for (String path : paths = RetroTranslatorHelper.split(libPaths, File.pathSeparator)) {
                    File f = new File(path, lib);
                    if (!f.exists()) continue;
                    Runtime.getRuntime().load(f.getAbsolutePath());
                    reporter.report(" - ok, path was: " + f.getAbsolutePath());
                    loaded = true;
                    break;
                }
            }
            if (!loaded) {
                throw new RuntimeException("Library '" + lib + "' was not found in 'java.library.path'=" + libPaths);
            }
        }
    }

    private static DeploymentSpec readDeploySpec(URL url, String jarName) throws Exception {
        reporter.report("Checking Archive '", jarName, "'");
        DeploymentSpec spec = new DeploymentSpec();
        spec.jarName = jarName;
        SAXParserFactory fact = SAXParserFactory.newInstance();
        SAXParser parser = fact.newSAXParser();
        XMLHandler handler = new XMLHandler();
        handler.spec = spec;
        try {
            parser.parse(url.openStream(), (DefaultHandler)handler);
            if (spec.key == null) {
                throw new DeploymentSpecException("Deployment Specification doesn't include required <cache key='...'/>");
            }
            deploymentSpecs.add(spec);
            return spec;
        }
        catch (WrongSystemException e) {
            reporter.report(" - skipping because of wrong system: " + e.getMessage());
            return null;
        }
    }

    private static void unpackDeploymentSpec(URL deploymentSpec, String jarName) throws Exception {
        reporter.report("Unpacking .jar file: '", jarName, "'");
        DeploymentSpec spec = NativeLibraryManager.readDeploySpec(deploymentSpec, jarName);
        if (spec == null) {
            return;
        }
        File tmpDir = NativeLibraryManager.jambiTempDirBase(spec.key);
        reporter.report(" - using cache directory: '", tmpDir.getAbsolutePath(), "'");
        boolean shouldCopy = false;
        File dummyFile = new File(tmpDir, ".dummy");
        if (dummyFile.exists()) {
            reporter.report(" - cache directory exists");
        } else {
            shouldCopy = true;
        }
        if (shouldCopy) {
            reporter.report(" - starting to copy content to cache directory...");
            for (LibraryEntry e : spec.libraries) {
                reporter.report(" - copying over: '", e.name, "'...");
                InputStream in = null;
                Enumeration<URL> resources = NativeLibraryManager.classLoader().getResources(e.name);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    String eform = url.toExternalForm();
                    if (eform.contains(jarName)) {
                        in = url.openStream();
                        reporter.report("    - matched url: ", url.toExternalForm());
                        continue;
                    }
                    if (!VERBOSE_LOADING) continue;
                    reporter.report("    - unmatched .jar file: ", eform);
                }
                if (in == null) {
                    throw new FileNotFoundException("Library '" + e.name + "' specified in qtjambi-deployment.xml in '" + jarName + "' does not exist");
                }
                File outFile = new File(tmpDir, e.name);
                File outFileDir = outFile.getParentFile();
                if (!outFileDir.exists()) {
                    reporter.report(" - creating directory: ", outFileDir.getAbsolutePath());
                    outFileDir.mkdirs();
                }
                FileOutputStream out = new FileOutputStream(new File(tmpDir, e.name));
                NativeLibraryManager.copy(in, out);
            }
            if (!dummyFile.createNewFile()) {
                throw new DeploymentSpecException("Can't create dummy file in cache directory");
            }
        }
        Runtime rt = Runtime.getRuntime();
        for (LibraryEntry e : spec.libraries) {
            if (e.load != 1) continue;
            reporter.report(" - trying to load: ", e.name);
            File f = new File(tmpDir, e.name);
            rt.load(f.getAbsolutePath());
            reporter.report(" - ok!");
        }
    }

    private static String jniLibraryName(String lib) {
        switch (Utilities.operatingSystem) {
            case Windows: {
                return lib + ".dll";
            }
            case MacOSX: {
                return "lib" + lib + ".jnilib";
            }
            case Linux: {
                return "lib" + lib + ".so";
            }
        }
        throw new RuntimeException("Unreachable statement");
    }

    private static String qtLibraryName(String lib, String version) {
        switch (Utilities.operatingSystem) {
            case Windows: {
                return Utilities.configuration == Utilities.Configuration.Debug ? lib + "d" + version + ".dll" : lib + version + ".dll";
            }
            case MacOSX: {
                return Utilities.configuration == Utilities.Configuration.Debug ? "lib" + lib + "_debug." + version + ".dylib" : "lib" + lib + "." + version + ".dylib";
            }
            case Linux: {
                return "lib" + lib + ".so." + version;
            }
        }
        throw new RuntimeException("Unreachable statement");
    }

    private static String stripLibraryName(String lib) {
        if (Utilities.operatingSystem != Utilities.OperatingSystem.Windows) {
            lib = lib.substring(3);
        }
        int dot = -1;
        switch (Utilities.operatingSystem) {
            case Windows: {
                dot = lib.indexOf(".dll");
                break;
            }
            case Linux: {
                dot = lib.indexOf(".so");
                break;
            }
            case MacOSX: {
                dot = lib.indexOf(".");
            }
        }
        return lib.substring(0, dot);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[65536];
        while (in.available() > 0) {
            int read = in.read(buffer);
            out.write(buffer, 0, read);
        }
        in.close();
        out.close();
    }

    public static boolean isUsingDeploymentSpec() {
        NativeLibraryManager.unpack();
        return deploymentSpecs != null && deploymentSpecs.size() != 0;
    }

    public static void main(String[] args) throws Exception {
        NativeLibraryManager.unpack();
        NativeLibraryManager.loadQtLibrary("QtCore");
        NativeLibraryManager.loadQtLibrary("QtGui");
        NativeLibraryManager.loadLibrary("qtjambi");
        NativeLibraryManager.loadLibrary("com_trolltech_qt_core");
        NativeLibraryManager.loadLibrary("com_trolltech_qt_gui");
        NativeLibraryManager.loadQtLibrary("QtGui");
        NativeLibraryManager.loadQtLibrary("QtNetwork");
        for (String s : NativeLibraryManager.pluginPaths()) {
            System.out.println("PluginPath: " + s);
        }
    }

    private static class ChecksumFileFilter
    implements FilenameFilter {
        private ChecksumFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".chk");
        }
    }

    private static class XMLHandler
    extends DefaultHandler {
        public DeploymentSpec spec;

        private XMLHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) {
            if (name.equals("cache")) {
                String key = attributes.getValue("key");
                if (key == null) {
                    throw new DeploymentSpecException("<cache> element missing required attribute \"key\"");
                }
                this.spec.key = key;
                reporter.report(" - cache key='", this.spec.key, "'");
            } else if (name.equals("library")) {
                LibraryEntry e = new LibraryEntry();
                e.name = attributes.getValue("name");
                if (e.name == null) {
                    throw new DeploymentSpecException("<library> element missing required attribute \"name\"");
                }
                String load = attributes.getValue("load");
                e.load = load != null && load.equals("true") ? 1 : (load != null && load.equals("never") ? 3 : 2);
                e.spec = this.spec;
                String fileName = new File(e.name).getName();
                if (e.load == 3) {
                    neverLoad.put(fileName, e);
                } else {
                    LibraryEntry old = (LibraryEntry)libraryMap.get(fileName);
                    if (old != null) {
                        throw new DeploymentSpecException("<library> '" + e.name + "' is duplicated. Present in both '" + this.spec.jarName + "' and '" + old.spec.jarName + "'.");
                    }
                    reporter.report(" - adding '", fileName, "' to library map");
                    libraryMap.put(fileName, e);
                }
                this.spec.addLibraryEntry(e);
            } else if (name.equals("plugin")) {
                String path = attributes.getValue("path");
                if (path == null) {
                    throw new DeploymentSpecException("<plugin> element missing required attribute \"path\"");
                }
                this.spec.addPluginPath(path);
            } else if (name.equals("qtjambi-deploy")) {
                String system = attributes.getValue("system");
                if (system == null || system.length() == 0) {
                    throw new DeploymentSpecException("<qtjambi-deploy> element missing required attribute 'system'");
                }
                if (!system.equals(OSInfo.osArchName())) {
                    throw new WrongSystemException("trying to load: '" + system + "', expected: '" + OSInfo.osArchName() + "'");
                }
            }
        }
    }

    private static class DeploymentSpec {
        public String key;
        public String jarName;
        public List<LibraryEntry> libraries;
        public List<String> pluginPaths;

        private DeploymentSpec() {
        }

        public void addPluginPath(String path) {
            if (this.pluginPaths == null) {
                this.pluginPaths = new ArrayList<String>();
            }
            this.pluginPaths.add(path);
            reporter.report(" - plugin path='", path, "'");
        }

        public void addLibraryEntry(LibraryEntry e) {
            if (this.libraries == null) {
                this.libraries = new ArrayList<LibraryEntry>();
            }
            this.libraries.add(e);
            reporter.report(" - library: name='", e.name, "', ", e.load == 1 ? "load" : (e.load == 3 ? "never load" : ""));
        }
    }

    private static class LibraryEntry {
        public String name;
        public int load;
        public DeploymentSpec spec;
        public boolean loaded;

        private LibraryEntry() {
        }
    }
}

