/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomDocumentFragment;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNode;
import com.trolltech.qt.xml.QDomNodeList;
import com.trolltech.qt.xml.QDomText;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLInsertHilight {
    private final QDomDocument doc;
    List<String> terms;
    List<QDomNode> oldNodes;
    List<QDomNode> newNodes;

    public XMLInsertHilight(QDomDocument d, List<String> t) {
        this.doc = d;
        this.terms = t;
        this.oldNodes = new ArrayList<QDomNode>();
        this.newNodes = new ArrayList<QDomNode>();
        this.scanTags();
    }

    public QDomDocument getDoc() {
        int i = 0;
        while (i < this.oldNodes.size()) {
            this.oldNodes.get(i).parentNode().replaceChild(this.newNodes.get(i), this.oldNodes.get(i));
            ++i;
        }
        return this.doc;
    }

    private void scanTags() {
        if (this.doc.hasChildNodes()) {
            this.parseNodes(this.doc.childNodes());
        }
    }

    private void parseNodes(QDomNodeList nodes) {
        int i = 0;
        while (i < nodes.size()) {
            QDomNode node = nodes.at(i);
            if (node.hasChildNodes()) {
                this.parseNodes(node.childNodes());
            }
            this.scanWords(node);
            ++i;
        }
    }

    public void parseChildren(QDomNode node) {
        while (!node.isNull()) {
            if (node.hasChildNodes()) {
                QDomNodeList l = node.childNodes();
                int i = 0;
                while (i < l.size()) {
                    this.parseChildren(l.at(i));
                    ++i;
                }
            }
            if (node.isText()) {
                this.scanWords(node);
            }
            node = node.nextSibling();
        }
    }

    private void scanWords(QDomNode node) {
        String value = node.nodeValue();
        QDomDocumentFragment fragment = this.doc.createDocumentFragment();
        boolean matchFound = false;
        int previousPosition = 0;
        String valueEnd = "";
        String regex = this.buildRegex();
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            matchFound = true;
            String valueStart = "";
            int start = matcher.start();
            int end = matcher.end();
            if (value.substring(start).startsWith(" ")) {
                ++start;
            }
            if (value.substring(start, end).endsWith(" ")) {
                --end;
            }
            if (matcher.start() > 0) {
                valueStart = value.substring(previousPosition, start);
            }
            String valueMiddle = value.substring(start, end);
            valueEnd = "";
            if (matcher.end() < value.length()) {
                valueEnd = value.substring(end);
            }
            previousPosition = end;
            if (!valueStart.equals("")) {
                QDomText startText = this.doc.createTextNode(valueStart);
                fragment.appendChild((QDomNode)startText);
            }
            QDomElement hilight = this.doc.createElement("en-hilight");
            hilight.appendChild((QDomNode)this.doc.createTextNode(valueMiddle));
            fragment.appendChild((QDomNode)hilight);
        }
        if (matchFound) {
            if (previousPosition != value.length()) {
                QDomText endText = this.doc.createTextNode(valueEnd);
                fragment.appendChild((QDomNode)endText);
            }
            this.newNodes.add((QDomNode)fragment);
            this.oldNodes.add(node);
        }
    }

    private String buildRegex() {
        StringBuffer regex = new StringBuffer();
        int j = this.terms.size() - 1;
        while (j >= 0) {
            if (this.terms.get(j).trim().equals("")) {
                this.terms.remove(j);
            }
            --j;
        }
        int i = 0;
        while (i < this.terms.size()) {
            String term = this.terms.get(i);
            if (term.indexOf("*") > -1) {
                term = term.replace("*", "");
            }
            regex.append(term);
            if (i < this.terms.size() - 1) {
                regex.append("|");
            }
            ++i;
        }
        return regex.toString();
    }
}

