/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.filters;

import cx.fbn.nevernote.filters.DateAttributeFilter;
import cx.fbn.nevernote.filters.checkLastMonth;
import cx.fbn.nevernote.filters.checkLastWeek;
import cx.fbn.nevernote.filters.checkLastYear;
import cx.fbn.nevernote.filters.checkMonth;
import cx.fbn.nevernote.filters.checkThisWeek;
import cx.fbn.nevernote.filters.checkToday;
import cx.fbn.nevernote.filters.checkYear;
import cx.fbn.nevernote.filters.checkYesterday;

public class DateAttributeFilterFactory {
    private DateAttributeFilterFactory() {
    }

    public static DateAttributeFilter getFilter(FilterType fType, boolean since, boolean created) {
        switch (fType) {
            case Today: {
                return new checkToday(since, created);
            }
            case Yesterday: {
                return new checkYesterday(since, created);
            }
            case ThisWeek: {
                return new checkThisWeek(since, created);
            }
            case LastWeek: {
                return new checkLastWeek(since, created);
            }
            case Month: {
                return new checkMonth(since, created);
            }
            case LastMonth: {
                return new checkLastMonth(since, created);
            }
            case Year: {
                return new checkYear(since, created);
            }
            case LastYear: {
                return new checkLastYear(since, created);
            }
        }
        throw new IllegalArgumentException("The filter type " + (Object)((Object)fType) + " is not recognized.");
    }

    public static enum FilterType {
        Today,
        Yesterday,
        ThisWeek,
        LastWeek,
        Month,
        LastMonth,
        Year,
        LastYear;

    }
}

