/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Notebook;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QSpacerItem;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class NotebookArchive
extends QDialog {
    private final QListWidget openBookList;
    private final QListWidget closedBookList;
    private final QPushButton okButton;
    private final QPushButton cancelButton;
    private boolean okClicked;
    private final QPushButton leftButton;
    private final QPushButton rightButton;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public NotebookArchive(List<Notebook> allBooks, List<Notebook> archive) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "notebook-green.png"));
        this.okClicked = false;
        this.openBookList = new QListWidget();
        this.openBookList.setSortingEnabled(true);
        this.openBookList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        this.cancelButton = new QPushButton();
        this.cancelButton.setText(this.tr("Cancel"));
        this.cancelButton.pressed.connect((Object)this, "onCancel()");
        QVBoxLayout openLayout = new QVBoxLayout();
        openLayout.addWidget((QWidget)new QLabel(this.tr("Open Notebooks")));
        openLayout.addWidget((QWidget)this.openBookList);
        this.rightButton = new QPushButton((QWidget)this);
        this.rightButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "forward.png"));
        this.leftButton = new QPushButton((QWidget)this);
        this.leftButton.setIcon(new QIcon(String.valueOf(this.iconPath) + "back.png"));
        this.leftButton.setEnabled(false);
        this.rightButton.setEnabled(false);
        QVBoxLayout middleLayout = new QVBoxLayout();
        middleLayout.addSpacerItem(new QSpacerItem(1, 1));
        middleLayout.addWidget((QWidget)this.rightButton);
        middleLayout.addWidget((QWidget)this.leftButton);
        middleLayout.addSpacerItem(new QSpacerItem(1, 1));
        QVBoxLayout closeLayout = new QVBoxLayout();
        closeLayout.addWidget((QWidget)new QLabel(this.tr("Closed Notebooks")));
        this.closedBookList = new QListWidget();
        this.closedBookList.setSortingEnabled(true);
        this.closedBookList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        closeLayout.addWidget((QWidget)this.closedBookList);
        this.openBookList.itemSelectionChanged.connect((Object)this, "openBookSelected()");
        this.closedBookList.itemSelectionChanged.connect((Object)this, "closedBookSelected()");
        this.leftButton.clicked.connect((Object)this, "toOpenList()");
        this.rightButton.clicked.connect((Object)this, "toClosedList()");
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.okButton);
        buttonLayout.addWidget((QWidget)this.cancelButton);
        this.setWindowTitle(this.tr("Open/Close Notebooks"));
        QHBoxLayout upperLayout = new QHBoxLayout();
        upperLayout.addLayout((QLayout)openLayout);
        upperLayout.addLayout((QLayout)middleLayout);
        upperLayout.addLayout((QLayout)closeLayout);
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)upperLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        int i = 0;
        while (i < allBooks.size()) {
            boolean found = false;
            int j = 0;
            while (j < archive.size()) {
                if (archive.get(j).getName().equalsIgnoreCase(allBooks.get(i).getName())) {
                    found = true;
                    j = archive.size();
                }
                ++j;
            }
            if (!found) {
                QListWidgetItem item = new QListWidgetItem(allBooks.get(i).getName());
                item.setSelected(false);
                this.openBookList.addItem(item);
            }
            ++i;
        }
        this.setWindowTitle(this.tr("Open Notebooks"));
        i = 0;
        while (i < archive.size()) {
            QListWidgetItem item = new QListWidgetItem(archive.get(i).getName());
            item.setSelected(false);
            this.closedBookList.addItem(item);
            ++i;
        }
        this.openBookList.itemSelectionChanged.connect((Object)this, "itemSelected()");
    }

    private void toClosedList() {
        List items = this.openBookList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.openBookList.row((QListWidgetItem)items.get(i));
            this.openBookList.takeItem(row);
            this.closedBookList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        if (this.openBookList.count() == 0) {
            this.okButton.setEnabled(false);
        }
        this.rightButton.setEnabled(false);
    }

    private void toOpenList() {
        List items = this.closedBookList.selectedItems();
        int i = items.size() - 1;
        while (i >= 0) {
            int row = this.closedBookList.row((QListWidgetItem)items.get(i));
            this.closedBookList.takeItem(row);
            this.openBookList.addItem(((QListWidgetItem)items.get(i)).text());
            --i;
        }
        this.okButton.setEnabled(true);
        this.leftButton.setEnabled(false);
    }

    private void closedBookSelected() {
        if (this.closedBookList.selectedItems().size() > 0) {
            this.leftButton.setEnabled(true);
        } else {
            this.leftButton.setEnabled(false);
        }
    }

    private void openBookSelected() {
        if (this.openBookList.selectedItems().size() > 0) {
            this.rightButton.setEnabled(true);
        } else {
            this.rightButton.setEnabled(false);
        }
    }

    private void onClicked() {
        this.okClicked = true;
        this.close();
    }

    private void onCancel() {
        this.okClicked = false;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public QListWidget getOpenBookList() {
        return this.openBookList;
    }

    public QListWidget getClosedBookList() {
        return this.closedBookList;
    }

    private void itemSelected() {
        if (this.openBookList.selectedItems().size() == this.openBookList.count()) {
            this.okButton.setEnabled(false);
            this.rightButton.setEnabled(false);
            return;
        }
        this.rightButton.setEnabled(true);
        this.okButton.setEnabled(true);
    }
}

