/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class LogFileDialog
extends QDialog {
    public final QComboBox fileCombo;
    public final QTextEdit textField;
    private final List<String> logs;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public LogFileDialog(List<String> l) {
        this.setWindowTitle(this.tr("Application Logs"));
        this.logs = l;
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "notebook-green.png"));
        QVBoxLayout main = new QVBoxLayout();
        this.setLayout((QLayout)main);
        this.fileCombo = new QComboBox((QWidget)this);
        QHBoxLayout comboLayout = new QHBoxLayout();
        comboLayout.addWidget((QWidget)new QLabel(this.tr("Log File:")));
        comboLayout.addWidget((QWidget)this.fileCombo);
        comboLayout.addStretch(100);
        this.fileCombo.currentIndexChanged.connect((Object)this, "indexChanged(Integer)");
        main.addLayout((QLayout)comboLayout);
        this.textField = new QTextEdit((QWidget)this);
        main.addWidget((QWidget)this.textField);
        this.fileCombo.addItem(this.tr("Message Log"), (Object)"MessageLog");
        this.fileCombo.addItem(this.tr("Application Log"), (Object)"NeverNoteLog");
        this.fileCombo.addItem(this.tr("Synchronization Log"), (Object)"SyncLog");
        this.fileCombo.addItem(this.tr("Save Log"), (Object)"SaveLog");
        this.fileCombo.addItem(this.tr("Tag Counter Log"), (Object)"TagCounterLog");
        this.fileCombo.addItem(this.tr("Notebook Counter Log"), (Object)"NotebookCounterLog");
        this.fileCombo.addItem(this.tr("Trash Counter Log"), (Object)"TrashCounterLog");
        this.fileCombo.addItem(this.tr("Note Browser Log"), (Object)"NoteBrowserLog");
        this.fileCombo.addItem(this.tr("Export Log"), (Object)"ExportLog");
        this.fileCombo.addItem(this.tr("Import Log"), (Object)"ImportLog");
        this.fileCombo.addItem(this.tr("Index Log"), (Object)"IndexLog");
        this.fileCombo.addItem(this.tr("Database Connection Log"), (Object)"DatabaseLog");
        this.fileCombo.addItem(this.tr("Thumbnail Generator Log"), (Object)"ThumbnailLog");
        this.fileCombo.addItem(this.tr("NeighborNote Database SQL Trace File"), (Object)"NeverNoteDBLog");
        this.fileCombo.addItem(this.tr("Index Database SQL Trace File"), (Object)"IndexDBLog");
        this.fileCombo.addItem(this.tr("Resource Database SQL Trace File"), (Object)"ResourceDBLog");
        this.fileCombo.addItem(this.tr("RensoNoteList Log"), (Object)"RensoNoteList Log");
    }

    private void restoreAsNewPushed() {
        this.close();
    }

    private void restorePushed() {
        this.close();
    }

    private void cancelPressed() {
        this.close();
    }

    private void indexChanged(Integer index) {
        String value = (String)this.fileCombo.itemData(index.intValue());
        if (value.equals("MessageLog")) {
            this.textField.clear();
            int i = 0;
            while (i < this.logs.size()) {
                this.textField.append(this.logs.get(i));
                ++i;
            }
            return;
        }
        if (value.equals("NeverNoteLog")) {
            this.loadFile("nevernote.log");
            return;
        }
        if (value.equals("SyncLog")) {
            this.loadFile("syncRunner.log");
            return;
        }
        if (value.equals("SaveLog")) {
            this.loadFile("saveRunner.log");
            return;
        }
        if (value.equals("SaveLog")) {
            this.loadFile("saveRunner.log");
            return;
        }
        if (value.equals("TagCounterLog")) {
            this.loadFile("tag_counter.log");
            return;
        }
        if (value.equals("NotebookCounterLog")) {
            this.loadFile("notebook_counter.log");
            return;
        }
        if (value.equals("TrashCounterLog")) {
            this.loadFile("trash_counter.log");
            return;
        }
        if (value.equals("NoteBrowserLog")) {
            this.loadFile("browser.log");
            return;
        }
        if (value.equals("ExportLog")) {
            this.loadFile("export.log");
            return;
        }
        if (value.equals("ImportLog")) {
            this.loadFile("import.log");
            return;
        }
        if (value.equals("GlobalLog")) {
            this.loadFile("global.log");
            return;
        }
        if (value.equals("IndexLog")) {
            this.loadFile("indexRunner.log");
            return;
        }
        if (value.equals("DatabaseLog")) {
            this.loadFile("nevernote-database.log");
            return;
        }
        if (value.equals("ThumbnailLog")) {
            this.loadFile("thumbnailRunner.log");
            return;
        }
        if (value.equals("NeverNoteDBLog")) {
            this.loadTraceFile("NeverNote.trace.db");
            return;
        }
        if (value.equals("IndexDBLog")) {
            this.loadTraceFile("Index.trace.db");
            return;
        }
        if (value.equals("ResourceDBLog")) {
            this.loadTraceFile("Resources.trace.db");
            return;
        }
        if (value.equals("RensoNoteList Log")) {
            this.loadFile("rensoNoteList.log");
            return;
        }
    }

    private void loadFile(String file) {
        this.textField.clear();
        File f = Global.getFileManager().getLogsDirFile(file);
        try {
            String data;
            BufferedReader in = new BufferedReader(new FileReader(f.getAbsolutePath()));
            while ((data = in.readLine()) != null) {
                this.textField.append(data);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadTraceFile(String file) {
        this.textField.clear();
        File f = Global.getFileManager().getDbDirFile(file);
        try {
            String data;
            BufferedReader in = new BufferedReader(new FileReader(f.getAbsolutePath()));
            while ((data = in.readLine()) != null) {
                this.textField.append(data);
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

