/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QListView;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QStackedWidget;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.NeverNote;
import cx.fbn.nevernote.dialog.ConfigAppearancePage;
import cx.fbn.nevernote.dialog.ConfigConnectionPage;
import cx.fbn.nevernote.dialog.ConfigDebugPage;
import cx.fbn.nevernote.dialog.ConfigFontPage;
import cx.fbn.nevernote.dialog.ConfigIndexPage;
import cx.fbn.nevernote.dialog.ConfigRensoNoteListPage;
import cx.fbn.nevernote.dialog.ConfigSpellPage;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;

public class ConfigDialog
extends QDialog {
    private final QListWidget contentsWidget;
    private final ConfigFontPage fontPage;
    private final QStackedWidget pagesWidget;
    private final ConfigConnectionPage connectionPage;
    private final ConfigDebugPage debugPage;
    private final ConfigAppearancePage appearancePage;
    private final ConfigSpellPage spellPage;
    private final ConfigIndexPage indexPage;
    private final ConfigRensoNoteListPage rensoNoteListPage;
    private final NeverNote parent;
    private final DatabaseConnection conn;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public ConfigDialog(NeverNote parent, DatabaseConnection conn) {
        this.parent = parent;
        this.conn = conn;
        this.contentsWidget = new QListWidget((QWidget)this);
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "config.png"));
        this.contentsWidget.setViewMode(QListView.ViewMode.IconMode);
        this.contentsWidget.setIconSize(new QSize(96, 84));
        this.contentsWidget.setMovement(QListView.Movement.Static);
        this.contentsWidget.setMaximumWidth(128);
        this.contentsWidget.setSpacing(12);
        this.pagesWidget = new QStackedWidget((QWidget)this);
        this.fontPage = new ConfigFontPage((QWidget)this);
        this.connectionPage = new ConfigConnectionPage((QWidget)this);
        this.appearancePage = new ConfigAppearancePage((QWidget)this);
        this.indexPage = new ConfigIndexPage((QWidget)this);
        this.debugPage = new ConfigDebugPage((QWidget)this);
        this.spellPage = new ConfigSpellPage((QWidget)this);
        this.rensoNoteListPage = new ConfigRensoNoteListPage((QWidget)this);
        this.pagesWidget.addWidget((QWidget)this.appearancePage);
        this.pagesWidget.addWidget((QWidget)this.fontPage);
        this.pagesWidget.addWidget((QWidget)this.indexPage);
        this.pagesWidget.addWidget((QWidget)this.spellPage);
        this.pagesWidget.addWidget((QWidget)this.connectionPage);
        this.pagesWidget.addWidget((QWidget)this.debugPage);
        this.pagesWidget.addWidget((QWidget)this.rensoNoteListPage);
        QPushButton cancelButton = new QPushButton(this.tr("Cancel"));
        QPushButton okButton = new QPushButton(this.tr("OK"));
        okButton.clicked.connect((Object)this, "okPushed()");
        cancelButton.clicked.connect((Object)this, "close()");
        this.createIcons();
        this.contentsWidget.setCurrentRow(0);
        QHBoxLayout horizontalLayout = new QHBoxLayout();
        horizontalLayout.addWidget((QWidget)this.contentsWidget);
        horizontalLayout.addWidget((QWidget)this.pagesWidget, 1, new Qt.AlignmentFlag[0]);
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)okButton);
        buttonLayout.addWidget((QWidget)cancelButton);
        this.setWindowTitle(this.tr("Settings"));
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)horizontalLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        this.loadSettings();
    }

    public void okPushed() {
        Global.setServer(this.debugPage.getServer());
        Global.setEnableThumbnails(this.debugPage.getEnableThumbnails());
        Global.disableUploads = this.debugPage.getDisableUploads();
        Global.setDisableUploads(Global.disableUploads);
        Global.setMimicEvernoteInterface(this.appearancePage.getMimicEvernote());
        Global.setMinimizeOnClose(this.appearancePage.getMinimizeOnClose());
        if (this.appearancePage.getShowSplashScreen()) {
            Global.saveWindowVisible("SplashScreen", true);
        } else {
            Global.saveWindowVisible("SplashScreen", false);
        }
        if (this.appearancePage.getPdfPreview()) {
            Global.setPdfPreview(true);
        } else {
            Global.setPdfPreview(false);
        }
        if (this.appearancePage.getCheckForUpdates()) {
            Global.setCheckVersionUpgrade(true);
        } else {
            Global.setCheckVersionUpgrade(false);
        }
        if (this.appearancePage.getNewAction()) {
            Global.setToolBarNewAction(true);
        } else {
            Global.setToolBarNewAction(false);
        }
        if (this.appearancePage.getNewNoteWithTags()) {
            Global.setNewNoteWithSelectedTags(true);
        } else {
            Global.setNewNoteWithSelectedTags(false);
        }
        if (this.appearancePage.getAnyTagSelection()) {
            Global.setAnyTagSelectionMatch(true);
        } else {
            Global.setAnyTagSelectionMatch(false);
        }
        Global.setAutoSaveInterval(this.appearancePage.getAutoSaveInterval());
        Global.setAutomaticLogin(this.connectionPage.getAutomaticLogin());
        Global.setProxyValue("url", this.connectionPage.getProxyUrl());
        Global.setProxyValue("port", this.connectionPage.getProxyPort());
        Global.setProxyValue("userid", this.connectionPage.getProxyUserid());
        Global.setProxyValue("password", this.connectionPage.getProxyPassword());
        Global.setShowTrayIcon(this.appearancePage.getShowTrayIcon());
        Global.setVerifyDelete(this.appearancePage.getVerifyDelete());
        Global.setStartMinimized(this.appearancePage.getStartMinimized());
        Global.setSynchronizeOnClose(this.connectionPage.getSynchronizeOnClose());
        Global.setSynchronizeDeletedContent(this.connectionPage.getSynchronizeDeletedContent());
        Global.setTagBehavior(this.appearancePage.getTagBehavior());
        Global.setIndexAttachmentsLocally(this.indexPage.getIndexAttachmentsLocally());
        Global.setIndexNoteBody(this.indexPage.getIndexNoteBody());
        Global.setIndexNoteTitle(this.indexPage.getIndexNoteTitle());
        Global.setIndexImageRecognition(this.indexPage.getIndexImageRecognition());
        Global.setIncludeTagChildren(this.appearancePage.getIncludeTagChildren());
        Global.setDisplayRightToLeft(this.appearancePage.getDisplayRightToLeft());
        Global.userStoreUrl = "https://" + this.debugPage.getServer() + "/edam/user";
        Global.setRecognitionWeight(this.indexPage.getRecognitionWeight());
        Global.setIndexThreadSleepInterval(this.indexPage.getSleepInterval());
        Global.setMessageLevel(this.debugPage.getDebugLevel());
        Global.saveCarriageReturnFix(this.debugPage.getCarriageReturnFix());
        Global.enableCarriageReturnFix = this.debugPage.getCarriageReturnFix();
        Global.saveHtmlEntitiesFix(this.debugPage.getHtmlEntitiesFix());
        Global.enableHTMLEntitiesFix = this.debugPage.getHtmlEntitiesFix();
        Global.setSpellSetting("SPELL_IGNOREDIGITWORDS", this.spellPage.getIgnoreDigitWords());
        Global.setSpellSetting("SPELL_IGNOREINTERNETADDRESS", this.spellPage.getIgnoreInternetAddresses());
        Global.setSpellSetting("SPELL_IGNOREMIXEDCASE", this.spellPage.getIgnoreMixedCase());
        Global.setSpellSetting("SPELL_IGNOREUPPERCASE", this.spellPage.getIgnoreUpperCase());
        Global.setSpellSetting("SPELL_IGNORESENTENCECAPTILIZATION", this.spellPage.getIgnoreSentenceCapitalization());
        String guiFormat = this.appearancePage.getStyle();
        QApplication.setStyle((String)guiFormat);
        QApplication.style().standardPalette();
        Global.setStyle(guiFormat);
        Global.setStandardPalette(this.appearancePage.getStandardPalette());
        if (Global.useStandardPalette()) {
            QApplication.setPalette((QPalette)QApplication.style().standardPalette());
        } else {
            QApplication.setPalette((QPalette)Global.originalPalette);
        }
        Global.setStartupNotebook(this.appearancePage.getStartupNotebook());
        String dateFmt = this.appearancePage.getDateFormat();
        String timeFmt = this.appearancePage.getTimeFormat();
        int dash = dateFmt.indexOf("-");
        dateFmt = dateFmt.substring(0, dash - 1);
        dash = timeFmt.indexOf("-");
        timeFmt = timeFmt.substring(0, dash - 1);
        Global.setDateFormat(dateFmt);
        Global.setTimeFormat(timeFmt);
        Global.setSyncInterval(this.connectionPage.getSyncInterval());
        Global.setOverrideDefaultFont(this.fontPage.overrideFont());
        Global.setDefaultFont(this.fontPage.getFont());
        Global.setDefaultFontSize(this.fontPage.getFontSize());
        Global.setDatabaseCache(this.debugPage.getDatabaseCacheSize());
        Global.setBrowseWeight(this.rensoNoteListPage.getBrowseWeight());
        Global.setCopyPasteWeight(this.rensoNoteListPage.getCopyPasteWeight());
        Global.setAddNewNoteWeight(this.rensoNoteListPage.getAddNewNoteWeight());
        Global.setRensoItemClickWeight(this.rensoNoteListPage.getRensoItemClickWeight());
        Global.setSameTagWeight(this.rensoNoteListPage.getSameTagWeight());
        Global.setSameNotebookWeight(this.rensoNoteListPage.getSameNotebookWeight());
        Global.setENRelatedNotesWeight(this.rensoNoteListPage.getENRelatedNotesWeight());
        String mode = new String(Global.rensoWeightingSelect());
        if (mode.equals("Custom")) {
            Global.saveCustomBrowseWeight(this.rensoNoteListPage.getBrowseWeight());
            Global.saveCustomCopyPasteWeight(this.rensoNoteListPage.getCopyPasteWeight());
            Global.saveCustomAddNewNoteWeight(this.rensoNoteListPage.getAddNewNoteWeight());
            Global.saveCustomRensoItemClickWeight(this.rensoNoteListPage.getRensoItemClickWeight());
            Global.saveCustomSameTagWeight(this.rensoNoteListPage.getSameTagWeight());
            Global.saveCustomSameNotebookWeight(this.rensoNoteListPage.getSameNotebookWeight());
            Global.saveCustomENRelatedNotesWeight(this.rensoNoteListPage.getENRelatedNotesWeight());
        }
        Global.setMergeRensoNote(this.rensoNoteListPage.getMergeChecked());
        Global.setDuplicateRensoNote(this.rensoNoteListPage.getDuplicateChecked());
        Global.setVerifyExclude(this.rensoNoteListPage.getVerifyExcludeChecked());
        Global.setRensoListItemMaximum(this.rensoNoteListPage.getRensoListItemMaximum());
        this.parent.getRensoNoteList().refreshRensoNoteList(this.parent.getCurrentNoteGuid());
        NSqlQuery nQuery = new NSqlQuery(this.conn.getConnection());
        NSqlQuery rQuery = new NSqlQuery(this.conn.getResourceConnection());
        nQuery.exec("CALL FTL_DROP_ALL();");
        rQuery.exec("CALL FTL_DROP_ALL();");
        Global.rebuildFullTextNoteTarget(this.conn);
        Global.rebuildFullTextResourceTarget(this.conn);
        if (Global.toolBarNewAction()) {
            this.parent.connectNewButtonSlot("noteAddNewTab()");
        } else {
            this.parent.connectNewButtonSlot("addNote()");
        }
        this.close();
    }

    public void reject() {
        QApplication.setStyle((String)Global.getStyle());
        super.reject();
    }

    public ConfigDebugPage getDebugPage() {
        return this.debugPage;
    }

    public ConfigConnectionPage getConfigPage() {
        return this.connectionPage;
    }

    public void createIcons() {
        String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        QListWidgetItem formatsButton = new QListWidgetItem(this.contentsWidget);
        formatsButton.setText(this.tr("Appearance"));
        formatsButton.setTextAlignment(Qt.AlignmentFlag.AlignHCenter.value());
        formatsButton.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsEnabled});
        formatsButton.setIcon(new QIcon(String.valueOf(iconPath) + "appearance.png"));
        QListWidgetItem fontButton = new QListWidgetItem(this.contentsWidget);
        fontButton.setText(this.tr("Fonts"));
        fontButton.setTextAlignment(Qt.AlignmentFlag.AlignHCenter.value());
        fontButton.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsEnabled});
        fontButton.setIcon(new QIcon(String.valueOf(iconPath) + "fontConfig.png"));
        QListWidgetItem indexButton = new QListWidgetItem(this.contentsWidget);
        indexButton.setText(this.tr("Indexing"));
        indexButton.setTextAlignment(Qt.AlignmentFlag.AlignHCenter.value());
        indexButton.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsEnabled});
        indexButton.setIcon(new QIcon(String.valueOf(iconPath) + "search_config.jpg"));
        QListWidgetItem spellButton = new QListWidgetItem(this.contentsWidget);
        spellButton.setText(this.tr("Spell Check"));
        spellButton.setTextAlignment(Qt.AlignmentFlag.AlignHCenter.value());
        spellButton.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsEnabled});
        spellButton.setIcon(new QIcon(String.valueOf(iconPath) + "dictionary.png"));
        QListWidgetItem configButton = new QListWidgetItem(this.contentsWidget);
        configButton.setText(this.tr("Connection"));
        configButton.setTextAlignment(Qt.AlignmentFlag.AlignHCenter.value());
        configButton.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsEnabled});
        configButton.setIcon(new QIcon(String.valueOf(iconPath) + "synchronize.png"));
        QListWidgetItem debugButton = new QListWidgetItem(this.contentsWidget);
        debugButton.setText(this.tr("Debugging"));
        debugButton.setTextAlignment(Qt.AlignmentFlag.AlignHCenter.value());
        debugButton.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsEnabled});
        debugButton.setIcon(new QIcon(String.valueOf(iconPath) + "debug.jpg"));
        QListWidgetItem rensoListButton = new QListWidgetItem(this.contentsWidget);
        rensoListButton.setText(this.tr("Renso Note List"));
        rensoListButton.setTextAlignment(Qt.AlignmentFlag.AlignCenter.value());
        rensoListButton.setFlags(new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsSelectable, Qt.ItemFlag.ItemIsEnabled});
        rensoListButton.setIcon(new QIcon(String.valueOf(iconPath) + "rensoNoteList.png"));
        this.contentsWidget.currentItemChanged.connect((Object)this, "changePage(QListWidgetItem, QListWidgetItem)");
    }

    protected void changePage(QListWidgetItem current, QListWidgetItem previous) {
        this.pagesWidget.setCurrentIndex(this.contentsWidget.row(current));
    }

    private void loadSettings() {
        Global.originalPalette = QApplication.palette();
        this.debugPage.setServer(Global.getServer());
        this.debugPage.setDisableUploads(Global.disableUploads);
        this.debugPage.setEnableThumbnails(Global.enableThumbnails());
        this.appearancePage.setAutoSaveInterval(Global.getAutoSaveInterval());
        this.connectionPage.setAutomaticLogin(Global.automaticLogin());
        this.appearancePage.setMimicEvernote(Global.getMimicEvernoteInterface());
        this.appearancePage.setShowTrayIcon(Global.showTrayIcon());
        this.connectionPage.setSynchronizeOnClose(Global.synchronizeOnClose());
        this.connectionPage.setSyncronizeDeletedContent(Global.synchronizeDeletedContent());
        this.appearancePage.setVerifyDelete(Global.verifyDelete());
        this.appearancePage.setStartMinimized(Global.startMinimized());
        this.appearancePage.setPdfPreview(Global.pdfPreview());
        this.appearancePage.setCheckForUpdates(Global.checkVersionUpgrade());
        this.appearancePage.setNewNoteWithTags(Global.newNoteWithSelectedTags());
        this.appearancePage.setAnyTagSelection(Global.anyTagSelectionMatch());
        this.appearancePage.setShowSplashScreen(Global.isWindowVisible("SplashScreen"));
        this.appearancePage.setTagBehavior(Global.tagBehavior());
        this.appearancePage.setMinimizeOnClose(Global.minimizeOnClose());
        this.appearancePage.setIncludeTagChildren(Global.includeTagChildren());
        this.appearancePage.setDisplayRightToLeft(Global.displayRightToLeft());
        this.appearancePage.setStartupNotebook(Global.getStartupNotebook());
        this.appearancePage.setNewAction(Global.toolBarNewAction());
        this.indexPage.setSleepInterval(Global.getIndexThreadSleepInterval());
        this.connectionPage.setSyncInterval(Global.getSyncInterval());
        this.appearancePage.setDateFormat(Global.getDateFormat());
        this.appearancePage.setTimeFormat(Global.getTimeFormat());
        this.appearancePage.setStyle(Global.getStyle());
        this.appearancePage.setStandardPalette(Global.useStandardPalette());
        this.debugPage.setDebugLevel(Global.getMessageLevel());
        this.debugPage.setCarriageReturnFix(Global.enableCarriageReturnFix());
        this.debugPage.setHtmlEntitiesFix(Global.enableHTMLEntitiesFix);
    }
}

