/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.QNativePointer;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtJambiGeneratedClass;
import com.trolltech.qt.QtProperty;
import com.trolltech.qt.core.QCoreApplication;
import com.trolltech.qt.core.QDataStream;
import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QRegExp;
import com.trolltech.qt.internal.MetaObjectTools;
import com.trolltech.qt.internal.NativeLibraryManager;
import com.trolltech.qt.internal.QSignalEmitterInternal;
import com.trolltech.qt.internal.RetroTranslatorHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QtJambiInternal {
    public static final char SlotPrefix = '1';
    public static final char SignalPrefix = '2';
    private static HashMap<String, String> typeMap = new HashMap();
    private static HashMap<String, String> signalMethodSignatureCash;
    private static HashMap<Class<?>, MutableInteger> expensesTable;

    public static void setupDefaultPluginPath() {
        try {
            if (NativeLibraryManager.isUsingDeploymentSpec()) {
                List<String> paths = NativeLibraryManager.pluginPaths();
                QCoreApplication.setLibraryPaths(paths);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int[] resolveConversionSchema(Class<?>[] inputParameterTypes, Class<?>[] outputParameterTypes) {
        int[] returned = new int[outputParameterTypes.length];
        for (int i = 0; i < returned.length; ++i) {
            returned[i] = 76;
            if (!outputParameterTypes[i].isPrimitive()) continue;
            returned[i] = QtJambiInternal.primitiveToByte(inputParameterTypes[i]);
        }
        return returned;
    }

    public static byte typeConversionCode(Class<?> cls) {
        if (cls.isPrimitive()) {
            return QtJambiInternal.primitiveToByte(cls);
        }
        return 76;
    }

    static Class<?> getComplexType(Class<?> primitiveType) {
        if (!primitiveType.isPrimitive()) {
            throw new RuntimeException("Primitive type required");
        }
        if (primitiveType.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (primitiveType.equals(Double.TYPE)) {
            return Double.class;
        }
        if (primitiveType.equals(Long.TYPE)) {
            return Long.class;
        }
        if (primitiveType.equals(Float.TYPE)) {
            return Float.class;
        }
        if (primitiveType.equals(Short.TYPE)) {
            return Short.class;
        }
        if (primitiveType.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (primitiveType.equals(Character.TYPE)) {
            return Character.class;
        }
        if (primitiveType.equals(Byte.TYPE)) {
            return Byte.class;
        }
        throw new RuntimeException("Unrecognized primitive type: " + primitiveType);
    }

    public static byte primitiveToByte(Class<?> primitiveType) {
        if (primitiveType.equals(Integer.class) || primitiveType.equals(Integer.TYPE)) {
            return 73;
        }
        if (primitiveType.equals(Long.class) || primitiveType.equals(Long.TYPE)) {
            return 74;
        }
        if (primitiveType.equals(Short.class) || primitiveType.equals(Short.TYPE)) {
            return 83;
        }
        if (primitiveType.equals(Boolean.class) || primitiveType.equals(Boolean.TYPE)) {
            return 90;
        }
        if (primitiveType.equals(Byte.class) || primitiveType.equals(Byte.TYPE)) {
            return 66;
        }
        if (primitiveType.equals(Float.class) || primitiveType.equals(Float.TYPE)) {
            return 70;
        }
        if (primitiveType.equals(Double.class) || primitiveType.equals(Double.TYPE)) {
            return 68;
        }
        if (primitiveType.equals(Character.class) || primitiveType.equals(Character.TYPE)) {
            return 67;
        }
        if (primitiveType.equals(Void.class) || primitiveType.equals(Void.TYPE)) {
            return 86;
        }
        throw new RuntimeException("Error in conversion to primitive for complex type " + primitiveType);
    }

    public static QSignalEmitterInternal.AbstractSignalInternal lookupSignal(QSignalEmitterInternal signalEmitter, String name) {
        if (name == null || signalEmitter == null) {
            System.err.println("lookupSignal: Name or object is null");
            return null;
        }
        QSignalEmitterInternal.AbstractSignalInternal returned = null;
        Class<?> cls = signalEmitter.getClass();
        while (QSignalEmitterInternal.class.isAssignableFrom(cls) && returned == null) {
            block9: {
                Field f;
                try {
                    f = cls.getDeclaredField(name);
                }
                catch (NoSuchFieldException e) {
                    break block9;
                }
                try {
                    f.setAccessible(true);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (QSignalEmitterInternal.AbstractSignalInternal.class.isAssignableFrom(f.getType())) {
                    try {
                        returned = (QSignalEmitterInternal.AbstractSignalInternal)f.get(signalEmitter);
                    }
                    catch (Exception e) {
                        returned = QtJambiInternal.fetchSignal(signalEmitter, f);
                    }
                }
            }
            cls = cls.getSuperclass();
        }
        return returned;
    }

    public static Method lookupSlot(Object object, String signature) {
        return QtJambiInternal.lookupSlot(object, signature, false);
    }

    public static Method lookupSlot(Object object, String signature, boolean slotMustBeGenerated) {
        Class<?> cls = slotMustBeGenerated ? QtJambiInternal.findGeneratedSuperclass(object) : object.getClass();
        int pos = signature.indexOf(40);
        if (pos < 0) {
            throw new RuntimeException("Wrong syntax in slot signature: '" + signature + "'");
        }
        int spacePos = signature.trim().lastIndexOf(32, pos);
        if (pos > spacePos && spacePos > 0) {
            throw new RuntimeException("Do not specify return type in slot signature: '" + signature + "'");
        }
        String name = signature.substring(0, pos).trim();
        int pos2 = signature.indexOf(41, pos);
        if (pos2 < 0) {
            throw new RuntimeException("Wrong syntax in slot signature: '" + signature + "'");
        }
        String strTypes = signature.substring(pos + 1, pos2).trim();
        String[] argumentTypes = strTypes.length() == 0 ? new String[]{} : strTypes.split(",");
        for (int i = 0; i < argumentTypes.length; ++i) {
            argumentTypes[i] = argumentTypes[i].replace(" ", "");
        }
        return QtJambiInternal.findFunctionRecursive(cls, name, argumentTypes);
    }

    private static Method findFunctionRecursive(Class<?> cls, String functionName, String[] argumentTypes) {
        Method[] methods;
        for (Method m : methods = cls.getDeclaredMethods()) {
            Class<?>[] a;
            if (!m.getName().equals(functionName) || (a = m.getParameterTypes()).length != argumentTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < a.length; ++i) {
                String argLenient;
                String arg = a[i].getName();
                Class<?> t = a[i];
                if (t.isArray()) {
                    String brackets = "";
                    do {
                        t = t.getComponentType();
                        brackets = brackets + "[]";
                    } while (t.isArray());
                    arg = t.getName() + brackets;
                }
                if (argumentTypes[i].indexOf(46) < 0) {
                    arg = arg.substring(arg.lastIndexOf(46) + 1);
                }
                String string = argLenient = a[i].isMemberClass() ? arg.replace('$', '.') : null;
                if (arg.equals(argumentTypes[i]) || argLenient != null && argLenient.equals(argumentTypes[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return m;
        }
        if ((cls = cls.getSuperclass()) == null) {
            return null;
        }
        return QtJambiInternal.findFunctionRecursive(cls, functionName, argumentTypes);
    }

    public static native long setQObjectSender(long var0, long var2);

    public static native void resetQObjectSender(long var0, long var2);

    private static boolean signalMatchesSlot(String signal, String slot) {
        if (slot.contains("()")) {
            return true;
        }
        int signalIndex = signal.indexOf(60);
        if (signalIndex < 0) {
            return false;
        }
        int slotIndex = slot.indexOf(40);
        if (slotIndex < 0) {
            throw new IllegalArgumentException("slot doesn't contain () as expected, '" + slot + "'");
        }
        String substr = signal.substring(signalIndex + 1, signal.length() - 1);
        String[] signalArguments = RetroTranslatorHelper.split(substr, ",");
        substr = slot.substring(slotIndex + 1, slot.length() - 1);
        String[] slotArguments = RetroTranslatorHelper.split(substr, ",");
        if (slotArguments.length > signalArguments.length) {
            return false;
        }
        for (int i = 0; i < slotArguments.length; ++i) {
            if (QtJambiInternal.matchTypes(signalArguments[i], slotArguments[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTypes(String a, String b) {
        return a.equals(b) || typeMap.get(a) != null && typeMap.get(a).equals(b);
    }

    public static void disconnect(QSignalEmitter sender, Object receiver) {
        Class<?> cls = sender.getClass();
        while (QSignalEmitterInternal.class.isAssignableFrom(cls)) {
            Field[] fields;
            for (Field f : fields = cls.getDeclaredFields()) {
                QSignalEmitter.AbstractSignal signal;
                if (!QtJambiInternal.isSignal(f.getType())) continue;
                try {
                    f.setAccessible(true);
                    signal = (QSignalEmitter.AbstractSignal)f.get(sender);
                }
                catch (Exception e) {
                    signal = (QSignalEmitter.AbstractSignal)QtJambiInternal.fetchSignal(sender, f);
                }
                signal.disconnect(receiver);
            }
            cls = cls.getSuperclass();
        }
    }

    public static native QSignalEmitter sender(QObject var0);

    public static Method findEmitMethod(QSignalEmitterInternal.AbstractSignalInternal signal) {
        Method[] methods = signal.getClass().getDeclaredMethods();
        Method slotMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals("emit")) continue;
            slotMethod = method;
            break;
        }
        return slotMethod;
    }

    public static boolean isSignal(Class<?> cl) {
        return QSignalEmitterInternal.AbstractSignalInternal.class.isAssignableFrom(cl);
    }

    public static ResolvedSignal resolveSignal(Field field, Class<?> declaringClass) {
        ResolvedSignal resolvedSignal = new ResolvedSignal();
        resolvedSignal.name = field.getName();
        Type t = field.getGenericType();
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            Type[] actualTypes = p.getActualTypeArguments();
            resolvedSignal.types = new Class[actualTypes.length];
            resolvedSignal.arrayDimensions = new int[actualTypes.length];
            for (int j = 0; j < resolvedSignal.types.length; ++j) {
                Type actualType = actualTypes[j];
                int arrayDims = 0;
                while (actualType instanceof GenericArrayType || actualType instanceof ParameterizedType) {
                    if (actualType instanceof GenericArrayType) {
                        actualType = ((GenericArrayType)actualType).getGenericComponentType();
                        ++arrayDims;
                        continue;
                    }
                    actualType = ((ParameterizedType)actualType).getRawType();
                }
                if (!(actualType instanceof Class)) {
                    throw new RuntimeException("Signals of generic types not supported: " + actualTypes[j].toString());
                }
                resolvedSignal.types[j] = (Class)actualType;
                resolvedSignal.arrayDimensions[j] = arrayDims;
            }
        }
        return resolvedSignal;
    }

    static native QSignalEmitterInternal.AbstractSignalInternal fetchSignal(QSignalEmitterInternal var0, Field var1);

    static native long resolveSlot(Method var0);

    static native void invokeSlot(Object var0, long var1, byte var3, Object[] var4, int[] var5);

    static native boolean cppDisconnect(QObject var0, String var1, QObject var2, String var3);

    static String findSignalMethodSignature(QSignalEmitter signalEmitter, String name) throws NoSuchFieldException, IllegalAccessException {
        Class<?> cls = signalEmitter.getClass();
        String fullName = cls + "." + name;
        String found = signalMethodSignatureCash.get(fullName);
        if (found != null) {
            return found;
        }
        while (cls != null) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                found = name + "(";
                Class<?>[] params = method.getParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    if (j > 0) {
                        found = found + ",";
                    }
                    found = found + params[j].getName();
                }
                found = found + ")";
                break;
            }
            cls = cls.getSuperclass();
        }
        signalMethodSignatureCash.put(fullName, found);
        return found;
    }

    public static List<QObject> findChildren(QObject qobject, Class<?> cl, String name) {
        List<QObject> children = qobject.children();
        ArrayList<QObject> matching = new ArrayList<QObject>();
        for (QObject current : children) {
            if ((name == null || name.equals(current.objectName())) && (cl == null || cl.isAssignableFrom(current.getClass()))) {
                matching.add(current);
            }
            matching.addAll(current.findChildren(cl, name));
        }
        return matching;
    }

    public static List<QObject> findChildren(QObject qobject, Class<?> cl, QRegExp name) {
        List<QObject> children = qobject.children();
        ArrayList<QObject> matching = new ArrayList<QObject>();
        for (QObject current : children) {
            if (!(name != null && name.indexIn(current.objectName()) < 0 || cl != null && !cl.isAssignableFrom(current.getClass()))) {
                matching.add(current);
            }
            matching.addAll(current.findChildren(cl, name));
        }
        return matching;
    }

    public static QObject findChild(QObject qobject, Class<?> cl, String name) {
        List<QObject> children = qobject.children();
        for (QObject current : children) {
            if ((name == null || name.equals(current.objectName())) && (cl == null || cl.isAssignableFrom(current.getClass()))) {
                return current;
            }
            QObject object = QtJambiInternal.findChild(current, cl, name);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static native Object createExtendedEnum(int var0, int var1, Class<?> var2, String var3);

    public static void countExpense(Class<?> cl, int cost, int limit) {
        MutableInteger mi;
        if (expensesTable == null) {
            expensesTable = new HashMap();
        }
        if ((mi = expensesTable.get(cl)) == null) {
            mi = new MutableInteger();
            expensesTable.put(cl, mi);
        }
        mi.value += cost;
        if (mi.value > limit) {
            mi.value = 0;
            System.gc();
        }
    }

    public static void setField(Object owner, Class<?> declaringClass, String fieldName, Object newValue) {
        block2: {
            Field f = null;
            try {
                f = declaringClass.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(owner, newValue);
            }
            catch (Exception e) {
                if (QtJambiInternal.setFieldNative(owner, f, newValue)) break block2;
                throw new RuntimeException("Cannot set field '" + fieldName);
            }
        }
    }

    public static native boolean setFieldNative(Object var0, Field var1, Object var2);

    public static Object fetchField(Object owner, Class<?> declaringClass, String fieldName) {
        Field f = null;
        try {
            f = declaringClass.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(owner);
        }
        catch (Exception e) {
            return QtJambiInternal.fetchFieldNative(owner, f);
        }
    }

    public static native Object fetchFieldNative(Object var0, Field var1);

    public static String charPointerToString(QNativePointer np) {
        byte b;
        int pos = 0;
        String returned = "";
        while ((b = np.byteAt(pos++)) != 0) {
            returned = returned + Byte.toString(b);
        }
        return returned;
    }

    public static QNativePointer intArrayToNativePointer(int[] data) {
        QNativePointer np = new QNativePointer(QNativePointer.Type.Int, data.length);
        for (int i = 0; i < data.length; ++i) {
            np.setIntAt(i, data[i]);
        }
        return np;
    }

    public static QNativePointer byteArrayToNativePointer(byte[] data) {
        QNativePointer np = new QNativePointer(QNativePointer.Type.Byte, data.length);
        for (int i = 0; i < data.length; ++i) {
            np.setByteAt(i, data[i]);
        }
        return np;
    }

    public static boolean isImplementedInJava(Method method) {
        return method.getDeclaringClass().getAnnotation(QtJambiGeneratedClass.class) == null;
    }

    private static List<Field> findSignals(QObject o) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
            Field[] declared;
            for (Field f : declared = c.getDeclaredFields()) {
                if (!QtJambiInternal.isSignal(f.getType())) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    private static Class<?> objectClass(Class<?> cl) {
        if (cl == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cl == Byte.TYPE) {
            return Byte.class;
        }
        if (cl == Character.TYPE) {
            return Character.class;
        }
        if (cl == Short.TYPE) {
            return Short.class;
        }
        if (cl == Integer.TYPE) {
            return Integer.class;
        }
        if (cl == Long.TYPE) {
            return Long.class;
        }
        if (cl == Float.TYPE) {
            return Float.class;
        }
        if (cl == Double.TYPE) {
            return Double.class;
        }
        return cl;
    }

    private static void tryConnect(QObject receiver, Method method, QObject sender, Field signal) {
        Class<?>[] params = method.getParameterTypes();
        Type type = signal.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] types = pt.getActualTypeArguments();
            if (types.length < params.length) {
                return;
            }
            for (int i = 0; i < params.length; ++i) {
                Class<?> signal_type = (Class<?>)types[i];
                Class<?> param_type = params[i];
                if (signal_type.isPrimitive()) {
                    signal_type = QtJambiInternal.objectClass(signal_type);
                }
                if (param_type.isPrimitive()) {
                    param_type = QtJambiInternal.objectClass(param_type);
                }
                if (signal_type == param_type) continue;
                return;
            }
        } else if (params.length != 0) {
            throw new RuntimeException("Don't know how to autoconnect to: " + signal.getDeclaringClass().getName() + "." + signal.getName());
        }
        Object signal_object = null;
        try {
            signal_object = signal.get(sender);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        ((QSignalEmitter.AbstractSignal)signal_object).connect(receiver, MetaObjectTools.methodSignature(method));
    }

    public static void connectSlotsByName(QObject object) {
        List<QObject> children = object.findChildren();
        for (Class<?> objectClass = object.getClass(); objectClass != null; objectClass = objectClass.getSuperclass()) {
            Method[] methods = objectClass.getDeclaredMethods();
            for (QObject child : children) {
                String prefix = "on_" + child.objectName() + "_";
                List<Field> fields = QtJambiInternal.findSignals(child);
                for (Field f : fields) {
                    String slot_name = prefix + f.getName();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals(slot_name)) continue;
                        QtJambiInternal.tryConnect(object, methods[i], child, f);
                    }
                }
            }
        }
    }

    public static Class<?> findGeneratedSuperclass(Object obj) {
        Class<?> clazz;
        for (clazz = obj.getClass(); clazz != null && !clazz.isAnnotationPresent(QtJambiGeneratedClass.class); clazz = clazz.getSuperclass()) {
        }
        return clazz;
    }

    public static void writeSerializableJavaObject(QDataStream s, Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(o);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        s.writeBytes(bos.toByteArray());
    }

    public static boolean isGeneratedClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(QtJambiGeneratedClass.class);
    }

    public static String signalParameters(QSignalEmitterInternal.AbstractSignalInternal signal) {
        return MetaObjectTools.bunchOfClassNamesInARow(signal.resolveSignal(), signal.arrayDimensions());
    }

    public static QtProperty userProperty(long nativeId) {
        List<QtProperty> properties = QtJambiInternal.properties(nativeId);
        for (QtProperty property : properties) {
            if (!property.isUser()) continue;
            return property;
        }
        return null;
    }

    public static native List<QtProperty> properties(long var0);

    public static int indexOfProperty(long nativeId, String name) {
        List<QtProperty> properties = QtJambiInternal.properties(nativeId);
        for (int i = 0; i < properties.size(); ++i) {
            if (!name.equals(properties.get(i).name())) continue;
            return i;
        }
        return -1;
    }

    public static Object readSerializableJavaObject(final QDataStream s) {
        Object res = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new InputStream(){

                public int read() throws IOException {
                    return s.readByte();
                }
            });
            res = in.readObject();
            in.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    static {
        typeMap.put("java.lang.Boolean", "boolean");
        typeMap.put("java.lang.Byte", "byte");
        typeMap.put("java.lang.Char", "char");
        typeMap.put("java.lang.Short", "short");
        typeMap.put("java.lang.Integer", "int");
        typeMap.put("java.lang.Long", "long");
        typeMap.put("java.lang.Float", "float");
        typeMap.put("java.lang.Double", "double");
        signalMethodSignatureCash = new HashMap();
    }

    public static class ResolvedSignal {
        public Class<?>[] types = new Class[0];
        public int[] arrayDimensions = new int[0];
        public String name = "";
    }

    private static class MutableInteger {
        int value;

        private MutableInteger() {
        }
    }

    static class QMetaCallEvent
    extends QEvent {
        public static final QEvent.Type MetaCallEventType = QEvent.Type.resolve(512);
        private QObject sender;
        private Object[] arguments;
        private QSignalEmitterInternal.AbstractSignalInternal.Connection connection;

        public QMetaCallEvent(QSignalEmitterInternal.AbstractSignalInternal.Connection connection, QObject sender, Object ... arguments) {
            super(MetaCallEventType);
            this.arguments = arguments;
            this.connection = connection;
            this.sender = sender;
        }

        public final Object[] getArguments() {
            return this.arguments;
        }

        public final void setArguments(Object[] arguments) {
            this.arguments = arguments;
        }

        public final QSignalEmitterInternal.AbstractSignalInternal.Connection getConnection() {
            return this.connection;
        }

        public final void setConnection(QSignalEmitterInternal.AbstractSignalInternal.Connection connection) {
            this.connection = connection;
        }

        final void execute() {
            boolean updateSender = this.sender != null;
            long oldSender = 0L;
            QSignalEmitterInternal oldEmitter = null;
            if (updateSender) {
                oldSender = QtJambiInternal.setQObjectSender(((QObject)this.connection.receiver).nativeId(), this.sender.nativeId());
                oldEmitter = QSignalEmitterInternal.currentSender.get();
                QSignalEmitterInternal.currentSender.set(this.sender);
            }
            try {
                this.connection.slot.invoke(this.connection.receiver, this.arguments);
            }
            catch (IllegalAccessException e) {
                QtJambiInternal.invokeSlot(this.connection.receiver, this.connection.slotId, this.connection.returnType, this.connection.args, this.connection.convertTypes);
            }
            catch (Exception e) {
                System.err.printf("Exception while executing queued connection: sender=%s, receiver=%s %s\n", this.sender != null ? this.sender.getClass().getName() : "N/A", this.connection.receiver, this.connection.slot.toString());
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                e.printStackTrace();
            }
            if (updateSender) {
                QtJambiInternal.resetQObjectSender(((QObject)this.connection.receiver).nativeId(), oldSender);
                QSignalEmitterInternal.currentSender.set(oldEmitter);
            }
        }
    }
}

