/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.Resource;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QTemporaryFile;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNodeList;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.signals.IndexSignal;
import cx.fbn.nevernote.signals.NoteResourceSignal;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IndexRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    private String guid;
    private QByteArray resourceBinary;
    public volatile NoteSignal noteSignal;
    public volatile NoteResourceSignal resourceSignal;
    private int indexType;
    public final int SCAN = 1;
    public final int REINDEXALL = 2;
    public final int REINDEXNOTE = 3;
    public boolean keepRunning;
    private final QDomDocument doc;
    public boolean indexImageRecognition = true;
    private final DatabaseConnection conn;
    private volatile LinkedBlockingQueue<String> workQueue;
    private static int MAX_QUEUED_WAITING = 1000;
    public boolean interrupt;
    public boolean idle;
    public boolean indexAttachmentsLocally = true;
    public volatile IndexSignal signal;
    private final TreeSet<String> foundWords = new TreeSet();
    int uncommittedCount = 0;

    public IndexRunner(String logname, String u, String i, String r, String b, String uid, String pswd, String cpswd) {
        this.logger = new ApplicationLogger(logname);
        this.conn = new DatabaseConnection(this.logger, u, i, r, b, uid, pswd, cpswd, 500);
        this.indexType = 1;
        this.guid = null;
        this.keepRunning = true;
        this.doc = new QDomDocument();
        this.workQueue = new LinkedBlockingQueue(MAX_QUEUED_WAITING);
    }

    public void setIndexType(int t) {
        this.indexType = t;
    }

    @Override
    public void run() {
        this.thread().setPriority(1);
        this.noteSignal = new NoteSignal();
        this.resourceSignal = new NoteResourceSignal();
        this.signal = new IndexSignal();
        this.logger.log(this.logger.EXTREME, "Starting index thread ");
        while (this.keepRunning) {
            this.idle = true;
            try {
                this.conn.commitTransaction();
                this.uncommittedCount = 0;
                String work = this.workQueue.take();
                this.idle = false;
                if (work.startsWith("SCAN")) {
                    this.guid = null;
                    this.interrupt = false;
                    this.indexType = 1;
                }
                if (work.startsWith("REINDEXALL")) {
                    this.guid = null;
                    this.indexType = 2;
                }
                if (work.startsWith("REINDEXNOTE")) {
                    this.guid = work = work.replace("REINDEXNOTE ", "");
                    this.indexType = 3;
                }
                if (work.startsWith("STOP")) {
                    this.keepRunning = false;
                    this.guid = null;
                }
                this.logger.log(this.logger.EXTREME, "Type:" + this.indexType);
                if (this.indexType == 1 && this.keepRunning) {
                    this.logger.log(this.logger.MEDIUM, "Scanning for unindexed notes & resources");
                    this.scanUnindexed();
                    this.setIndexType(0);
                }
                if (this.indexType == 2 && this.keepRunning) {
                    this.logger.log(this.logger.MEDIUM, "Marking all for reindex");
                    this.reindexAll();
                    this.setIndexType(0);
                }
                if (this.indexType != 3 || !this.keepRunning) continue;
                this.reindexNote();
            }
            catch (InterruptedException e) {
                this.logger.log(this.logger.LOW, "Thread interrupted exception: " + e.getMessage());
            }
        }
        this.logger.log(this.logger.EXTREME, "Shutting down database");
        this.conn.dbShutdown();
        this.logger.log(this.logger.EXTREME, "Database shut down.  Exiting thread");
    }

    private String removeTags(String text) {
        StringBuffer buffer = new StringBuffer(text);
        boolean inTag = false;
        int i = buffer.length() - 1;
        while (i >= 0) {
            if (buffer.charAt(i) == '>') {
                inTag = true;
            }
            if (buffer.charAt(i) == '<') {
                inTag = false;
            }
            if (inTag || buffer.charAt(i) == '<') {
                buffer.deleteCharAt(i);
            }
            --i;
        }
        return buffer.toString();
    }

    public synchronized boolean addWork(String request) {
        if (this.workQueue.size() == 0) {
            this.workQueue.offer(request);
            return true;
        }
        return false;
    }

    public synchronized int getWorkQueueSize() {
        return this.workQueue.size();
    }

    public void indexResource() {
        if (this.guid == null) {
            return;
        }
        this.foundWords.clear();
        Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResourceRecognition(this.guid);
        this.resourceBinary = !this.indexImageRecognition || r == null || r.getRecognition() == null || r.getRecognition().getBody() == null || r.getRecognition().getBody().length == 0 ? new QByteArray(" ") : new QByteArray(r.getRecognition().getBody());
        this.conn.commitTransaction();
        this.conn.beginTransaction();
        this.conn.getWordsTable().expungeFromWordIndex(r.getNoteGuid(), "RESOURCE");
        this.conn.getWordsTable().expungeFromWordIndex(this.guid, "RESOURCE");
        this.conn.commitTransaction();
        this.uncommittedCount = 0;
        this.conn.beginTransaction();
        this.doc.setContent(this.resourceBinary);
        QDomElement docElem = this.doc.documentElement();
        QDomNodeList anchors = docElem.elementsByTagName("t");
        int i = 0;
        while (i < anchors.length() && this.keepRunning) {
            if (this.interrupt && this.interrupt) {
                this.processInterrupt();
            }
            QDomElement enmedia = anchors.at(i).toElement();
            String weight = new String(enmedia.attribute("w"));
            String text = new String(enmedia.text()).toLowerCase();
            if (!text.equals("")) {
                this.conn.getWordsTable().addWordToNoteIndex(r.getNoteGuid(), text, "RESOURCE", new Integer(weight));
                ++this.uncommittedCount;
                if (this.uncommittedCount > 100) {
                    this.conn.commitTransaction();
                    this.uncommittedCount = 0;
                }
            }
            ++i;
        }
        if (Global.keepRunning && this.indexAttachmentsLocally) {
            this.conn.commitTransaction();
            this.uncommittedCount = 0;
            this.conn.beginTransaction();
            this.indexResourceContent(this.guid);
        }
        if (Global.keepRunning) {
            this.conn.getNoteTable().noteResourceTable.setIndexNeeded(this.guid, false);
        }
        this.conn.commitTransaction();
        this.uncommittedCount = 0;
    }

    private void indexResourceContent(String guid) {
        Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResource(guid, true);
        if (r != null && r.getMime() != null) {
            if (r.getMime().equalsIgnoreCase("application/pdf")) {
                this.indexResourcePDF(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/docx") || r.getMime().equalsIgnoreCase("application/xlsx") || r.getMime().equalsIgnoreCase("application/pptx")) {
                this.indexResourceOOXML(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/vsd") || r.getMime().equalsIgnoreCase("application/ppt") || r.getMime().equalsIgnoreCase("application/xls") || r.getMime().equalsIgnoreCase("application/msg") || r.getMime().equalsIgnoreCase("application/doc")) {
                this.indexResourceOffice(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/rtf")) {
                this.indexResourceRTF(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/odf") || r.getMime().equalsIgnoreCase("application/odt") || r.getMime().equalsIgnoreCase("application/odp") || r.getMime().equalsIgnoreCase("application/odg") || r.getMime().equalsIgnoreCase("application/odb") || r.getMime().equalsIgnoreCase("application/ods")) {
                this.indexResourceODF(r);
                return;
            }
        }
    }

    private void indexResourceRTF(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            RTFParser parser = new RTFParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            this.updateResourceText(r.getGuid(), textHandler.toString());
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourceODF(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            OpenDocumentParser parser = new OpenDocumentParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            this.updateResourceText(r.getGuid(), textHandler.toString());
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourceOffice(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            OfficeParser parser = new OfficeParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            this.updateResourceText(r.getGuid(), textHandler.toString());
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourcePDF(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            PDFParser parser = new PDFParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            this.updateResourceText(r.getGuid(), textHandler.toString());
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourceOOXML(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            OOXMLParser parser = new OOXMLParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            this.updateResourceText(r.getGuid(), textHandler.toString());
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private QTemporaryFile writeResource(Data d) {
        QTemporaryFile newFile = new QTemporaryFile();
        newFile.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
        newFile.write(d.getBody());
        newFile.close();
        return newFile;
    }

    private String removeEnCrypt(String content) {
        int index = content.indexOf("<en-crypt");
        boolean tagFound = true;
        while (tagFound && this.keepRunning) {
            int endPos;
            if (this.interrupt) {
                this.processInterrupt();
            }
            if ((endPos = content.indexOf("</en-crypt>", index) + 11) > -1 && index > -1) {
                content = String.valueOf(content.substring(0, index)) + content.substring(endPos);
                index = content.indexOf("<en-crypt");
                continue;
            }
            tagFound = false;
        }
        return content;
    }

    private void updateResourceText(String guid, String text) {
        this.conn.getNoteTable().noteResourceTable.updateResourceText(guid, text);
    }

    private void scanUnindexed() {
        this.guid = null;
        boolean started = false;
        List<String> unindexedResources = this.conn.getNoteTable().noteResourceTable.getUnindexed();
        if (unindexedResources.size() > 0 && !started) {
            this.signal.indexStarted.emit();
            started = true;
        }
        int i = 0;
        while (i < unindexedResources.size() && this.keepRunning) {
            if (this.interrupt) {
                this.processInterrupt();
            }
            this.guid = unindexedResources.get(i);
            if (this.keepRunning) {
                this.indexResource();
            }
            ++i;
        }
        List<String> guids = this.conn.getWordsTable().getGuidList();
        this.logger.log(this.logger.LOW, "GUIDS in index: " + guids.size());
        int i2 = 0;
        while (i2 < guids.size() && this.keepRunning) {
            if (!this.conn.getNoteTable().exists(guids.get(i2))) {
                this.logger.log(this.logger.LOW, "Old GUID found: " + guids.get(i2));
                this.conn.getWordsTable().expunge(guids.get(i2));
            }
            ++i2;
        }
        if (started && this.keepRunning) {
            this.signal.indexFinished.emit();
        }
    }

    private void reindexNote() {
        if (this.guid == null) {
            return;
        }
        this.conn.getNoteTable().setIndexNeeded(this.guid, true);
    }

    private void reindexAll() {
        this.conn.getNoteTable().reindexAllNotes();
        this.conn.getNoteTable().noteResourceTable.reindexAll();
    }

    private void waitSeconds(int len) {
        long starttime = 0L;
        starttime = System.currentTimeMillis();
        starttime = (long)((double)starttime + 1000.0);
        LockSupport.parkNanos(Math.max(0L, starttime - System.currentTimeMillis()) * 1000000L);
    }

    private void processInterrupt() {
        this.conn.commitTransaction();
        this.waitSeconds(1);
        this.uncommittedCount = 0;
        this.conn.beginTransaction();
        this.interrupt = false;
    }
}

