/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;

public class StaredTable {
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public StaredTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        this.logger.log(this.logger.HIGH, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059...");
        if (!query.exec("Create table StaredNotes (id integer primary key auto_increment, masterGuid varchar, staredGuid varchar)")) {
            this.logger.log(this.logger.HIGH, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u4f5c\u6210\u5931\u6557!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.exec("Drop table StaredNotes");
    }

    public void addStaredItem(String masterGuid, String staredGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.prepare("Insert Into StaredNotes (masterGuid, staredGuid) Values(:masterGuid, :staredGuid)");
        query.bindValue(":masterGuid", masterGuid);
        query.bindValue(":staredGuid", staredGuid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u3078\u306e\u30a2\u30a4\u30c6\u30e0\u8ffd\u52a0\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void removeStaredItem(String masterGuid, String staredGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.prepare("Delete from StaredNotes where (masterGuid=:masterGuid and staredGuid=:staredGuid)");
        query.bindValue(":masterGuid", masterGuid);
        query.bindValue(":staredGuid", staredGuid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089\u306e\u30a2\u30a4\u30c6\u30e0\u524a\u9664\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void expungeStaredNote(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.prepare("Delete from StaredNotes where masterGuid=:masterGuid or staredGuid=:staredGuid");
        query.bindValue(":masterGuid", guid);
        query.bindValue(":staredGuid", guid);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid=" + guid + "\u306e\u30c7\u30fc\u30bf\u524a\u9664\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void mergeHistoryGuid(String masterGuid, String childGuid) {
        NSqlQuery staredNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        boolean check = false;
        staredNotesQuery.prepare("Delete from StaredNotes where (masterGuid=:masterGuid1 and staredGuid=:staredGuid1) or (masterGuid=:masterGuid2 and staredGuid=:staredGuid2)");
        staredNotesQuery.bindValue(":masterGuid1", masterGuid);
        staredNotesQuery.bindValue(":childGuid1", childGuid);
        staredNotesQuery.bindValue(":masterGuid2", childGuid);
        staredNotesQuery.bindValue(":staredGuid2", masterGuid);
        check = staredNotesQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "staredNotes\u30c6\u30fc\u30d6\u30eb\u306e\u91cd\u8907\u524a\u9664\u3067\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, staredNotesQuery.lastError());
        }
        this.updateStaredNoteGuid(masterGuid, childGuid);
    }

    public void updateStaredNoteGuid(String newGuid, String oldGuid) {
        NSqlQuery staredNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        boolean check = false;
        staredNotesQuery.prepare("Update StaredNotes set masterGuid=:newGuid where masterGuid=:oldGuid");
        staredNotesQuery.bindValue(":newGuid", newGuid);
        staredNotesQuery.bindValue(":oldGuid", oldGuid);
        check = staredNotesQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u306emasterGuid\u306e\u3068\u3053\u308d\u3067guid\u66f4\u65b0\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, staredNotesQuery.lastError());
        }
        staredNotesQuery.prepare("Update StaredNotes set staredGuid=:newGuid where staredGuid=:oldGuid");
        staredNotesQuery.bindValue(":newGuid", newGuid);
        staredNotesQuery.bindValue(":oldGuid", oldGuid);
        check = staredNotesQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u306estaredGuid\u306e\u3068\u3053\u308d\u3067guid\u66f4\u65b0\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, staredNotesQuery.lastError());
        }
    }

    public boolean existNote(String masterGuid, String staredGuid) {
        NSqlQuery staredNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        staredNotesQuery.prepare("Select * from StaredNotes where Exists(Select * from StaredNotes where (masterGuid=:masterGuid1 and staredGuid=:staredGuid1) or (masterGuid=:masterGuid2 and staredGuid=:staredGuid2))");
        staredNotesQuery.bindValue(":masterGuid1", masterGuid);
        staredNotesQuery.bindValue(":staredGuid1", staredGuid);
        staredNotesQuery.bindValue(":masterGuid2", masterGuid);
        staredNotesQuery.bindValue(":staredGuid2", staredGuid);
        if (!staredNotesQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089masterGuid=" + masterGuid + "\u304b\u3064staredGuid=" + staredGuid + "\uff08\u307e\u305f\u306f\u305d\u306e\u9006\uff09\u306e\u30a2\u30a4\u30c6\u30e0\u306e\u5b58\u5728\u78ba\u8a8d\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, staredNotesQuery.lastError());
        }
        return staredNotesQuery.next();
    }

    public void duplicateStaredNotes(String newGuid, String oldGuid) {
        NSqlQuery staredNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        staredNotesQuery.prepare("Select staredGuid from StaredNotes where masterGuid=:oldGuid");
        staredNotesQuery.bindValue(":oldGuid", oldGuid);
        if (!staredNotesQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089masterGuid=" + oldGuid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, staredNotesQuery.lastError());
        }
        while (staredNotesQuery.next()) {
            String staredGuid = staredNotesQuery.valueString(0);
            this.addStaredItem(newGuid, staredGuid);
        }
        staredNotesQuery.prepare("Select masterGuid from StaredNotes where staredGuid=:oldGuid");
        staredNotesQuery.bindValue(":oldGuid", oldGuid);
        if (!staredNotesQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "StaredNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089staredGuid=" + oldGuid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, staredNotesQuery.lastError());
        }
        while (staredNotesQuery.next()) {
            String masterGuid = staredNotesQuery.valueString(0);
            this.addStaredItem(masterGuid, newGuid);
        }
    }
}

