/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFileDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;

public class SetIcon
extends QDialog {
    private boolean okPressed = false;
    QPushButton ok;
    QPushButton iconButton;
    QCheckBox useDefault;
    QIcon defaultIcon;
    boolean startUseDefault;
    String path;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public SetIcon(QIcon i, String path) {
        this.path = path;
        this.setWindowTitle(this.tr("Set Icon"));
        QGridLayout grid = new QGridLayout();
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "nevernote.png"));
        this.setLayout((QLayout)grid);
        QGridLayout textGrid = new QGridLayout();
        textGrid.setContentsMargins(10, 10, -10, -10);
        this.useDefault = new QCheckBox();
        this.iconButton = new QPushButton();
        this.iconButton.setSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed);
        this.iconButton.clicked.connect((Object)this, "iconButtonPressed()");
        this.useDefault.setText(this.tr("Use Default"));
        this.iconButton.setIcon(i);
        textGrid.addWidget((QWidget)this.iconButton, 1, 1);
        textGrid.addWidget((QWidget)this.useDefault, 2, 1);
        this.useDefault.clicked.connect((Object)this, "useDefaultIconChecked(Boolean)");
        grid.addLayout((QLayout)textGrid, 1, 1);
        QGridLayout buttonGrid = new QGridLayout();
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        buttonGrid.addWidget((QWidget)this.ok, 3, 1);
        buttonGrid.addWidget((QWidget)cancel, 3, 2);
        grid.addLayout((QLayout)buttonGrid, 2, 1);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private void iconButtonPressed() {
        QFileDialog fd = new QFileDialog((QWidget)this);
        fd.setFileMode(QFileDialog.FileMode.ExistingFile);
        fd.setConfirmOverwrite(true);
        fd.setWindowTitle(this.tr("Icon"));
        fd.setFilter(this.tr("PNG (*.png);;All Files (*.*)"));
        fd.setAcceptMode(QFileDialog.AcceptMode.AcceptOpen);
        if (this.path == null || this.path.equals("")) {
            fd.setDirectory(Global.getFileManager().getImageDirPath(""));
        } else {
            fd.setDirectory(this.path);
        }
        if (fd.exec() == 0 || fd.selectedFiles().size() == 0) {
            return;
        }
        this.path = (String)fd.selectedFiles().get(0);
        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
        this.ok.setEnabled(true);
        String path = (String)fd.selectedFiles().get(0);
        this.iconButton.setIcon(new QIcon(path));
        this.iconButton.setSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed);
    }

    public void setUseDefaultIcon(boolean val) {
        this.useDefault.setChecked(val);
        this.iconButton.setEnabled(!val);
        this.startUseDefault = val;
    }

    public QIcon getIcon() {
        if (this.useDefault.isChecked()) {
            return null;
        }
        return this.iconButton.icon();
    }

    public void useDefaultIconChecked(Boolean value) {
        this.iconButton.setEnabled(value == false);
        if (value != this.startUseDefault) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public String getFileType() {
        return "PNG";
    }

    public String getPath() {
        return this.path;
    }
}

