/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.SavedSearch;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class SavedSearchEdit
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit searchName;
    private final QLineEdit query;
    QPushButton ok;
    List<SavedSearch> currentSearches;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public SavedSearchEdit() {
        this.setWindowTitle(this.tr("Add a search"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "search.png"));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        QGridLayout textLayout = new QGridLayout();
        this.searchName = new QLineEdit();
        textLayout.addWidget((QWidget)new QLabel(this.tr("Name")), 1, 1);
        textLayout.addWidget((QWidget)this.searchName, 1, 2);
        this.query = new QLineEdit();
        textLayout.addWidget((QWidget)new QLabel(this.tr("String")), 2, 1);
        textLayout.addWidget((QWidget)this.query, 2, 2);
        textLayout.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)textLayout, 1, 1);
        QGridLayout buttonLayout = new QGridLayout();
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        this.searchName.textChanged.connect((Object)this, "textChanged()");
        this.query.textChanged.connect((Object)this, "textChanged()");
        buttonLayout.addWidget((QWidget)this.ok, 1, 1);
        buttonLayout.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)buttonLayout, 2, 1);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public String getName() {
        return this.searchName.text().trim();
    }

    public void setName(String name) {
        this.searchName.setText(name);
    }

    public String getQuery() {
        return this.query.text().trim();
    }

    public void setQuery(String q) {
        this.query.setText(q);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void setTitle(String s) {
        this.setWindowTitle(s);
    }

    public void setSearchList(List<SavedSearch> t) {
        this.currentSearches = t;
    }

    private void textChanged() {
        if (this.searchName.text().trim().equals("")) {
            this.ok.setEnabled(false);
            return;
        }
        if (this.currentSearches == null) {
            this.ok.setEnabled(false);
            return;
        }
        if (this.query.text().trim().equals("")) {
            this.ok.setEnabled(false);
            return;
        }
        this.ok.setEnabled(true);
    }
}

