/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.filters;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QSortFilterProxyModel;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.evernote.NoteMetadata;
import java.util.HashMap;

public class NoteSortFilterProxyModel
extends QSortFilterProxyModel {
    private final HashMap<String, NoteMetadata> guids = new HashMap();
    private final HashMap<String, NoteMetadata> pinnedGuids = new HashMap();
    public QSignalEmitter.Signal2<Integer, Integer> sortChanged;
    public boolean blocked;

    public NoteSortFilterProxyModel(QObject parent) {
        super(parent);
        this.setDynamicSortFilter(true);
        this.sortChanged = new QSignalEmitter.Signal2((QSignalEmitter)this);
    }

    public void clear() {
        this.guids.clear();
    }

    public void addGuid(String guid, NoteMetadata meta) {
        if (!this.guids.containsKey(guid)) {
            this.guids.put(guid, meta);
        }
        if (meta != null && this.pinnedGuids != null && meta.isPinned() && !this.pinnedGuids.containsKey(guid)) {
            this.pinnedGuids.put(guid, meta);
        }
    }

    public void filter() {
        this.invalidateFilter();
    }

    protected boolean filterAcceptsRow(int sourceRow, QModelIndex sourceParent) {
        QModelIndex guidIndex;
        QAbstractItemModel model = this.sourceModel();
        String guid = (String)model.data(guidIndex = this.sourceModel().index(sourceRow, Global.noteTableGuidPosition));
        return this.guids.containsKey(guid) || this.pinnedGuids.containsKey(guid);
    }

    public void sort(int col, Qt.SortOrder order) {
        if (col != Global.noteTableThumbnailPosition) {
            if (!this.blocked) {
                this.sortChanged.emit((Object)col, (Object)order.value());
            }
            super.sort(col, order);
        }
    }

    protected boolean lessThan(QModelIndex left, QModelIndex right) {
        Object leftData = this.sourceModel().data(left);
        Object rightData = this.sourceModel().data(right);
        if (rightData == null) {
            return true;
        }
        if (leftData instanceof QIcon) {
            return true;
        }
        if (leftData instanceof QImage && rightData instanceof QImage) {
            return true;
        }
        if (leftData instanceof Long && rightData instanceof Long) {
            Long leftLong = (Long)leftData;
            Long rightLong = (Long)rightData;
            return leftLong.compareTo(rightLong) < 0;
        }
        if (leftData instanceof String && rightData instanceof String) {
            String leftString = (String)leftData;
            String rightString = (String)rightData;
            return leftString.toLowerCase().compareTo(rightString.toLowerCase()) < 0;
        }
        return super.lessThan(left, right);
    }
}

