/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.evernote;

import cx.fbn.nevernote.utilities.Base64;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CRC32;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EnCrypt {
    public static String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        int i = 0;
        while (i < buf.length) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
            ++i;
        }
        return strbuf.toString();
    }

    private Charset getCharset() {
        boolean useUtf8 = true;
        Charset charSet = useUtf8 ? Charset.forName("UTF-8") : Charset.defaultCharset();
        return charSet;
    }

    private byte[] encodeStringOld(String text) {
        int len = text.length() + 4;
        int mod = len % 8;
        if (mod > 0) {
            while (mod != 0) {
                mod = len % 8;
                ++len;
            }
            --len;
        }
        StringBuffer textBuffer = new StringBuffer(text);
        textBuffer.setLength(len -= 4);
        String encoded = String.valueOf(this.crcHeader(textBuffer.toString())) + textBuffer;
        return encoded.getBytes();
    }

    private byte[] encodeStringNew(String text) {
        int align8;
        int paddingNeeded;
        Charset charSet = this.getCharset();
        byte[] bytes = text.getBytes(charSet);
        byte[] paddedBytes = Arrays.copyOf(bytes, bytes.length + (paddingNeeded = 8 - (align8 = (bytes.length + 4) % 8)));
        String crc = this.crcHeader(paddedBytes);
        byte[] crcBytes = crc.getBytes(charSet);
        if (crcBytes.length != 4) {
            System.err.println("CRC Bytes really should be 4 in length!");
            return null;
        }
        byte[] total = new byte[paddedBytes.length + crcBytes.length];
        System.arraycopy(crcBytes, 0, total, 0, crcBytes.length);
        System.arraycopy(paddedBytes, 0, total, crcBytes.length, paddedBytes.length);
        return total;
    }

    private String decodeBytesNew(byte[] bytes) {
        Charset charSet = this.getCharset();
        byte[] crcBytes = Arrays.copyOfRange(bytes, 0, 4);
        byte[] textBytes = Arrays.copyOfRange(bytes, 4, bytes.length);
        CharBuffer crcChar = charSet.decode(ByteBuffer.wrap(crcBytes));
        CharBuffer textChar = charSet.decode(ByteBuffer.wrap(textBytes));
        String cryptCRC = crcChar.toString();
        String realCRC = this.crcHeader(textBytes);
        if (realCRC.equals(cryptCRC)) {
            while (textChar.get(textChar.limit() - 1) == '\u0000' && textChar.limit() != 0) {
                textChar.limit(textChar.limit() - 1);
            }
            String str = textChar.toString();
            return str;
        }
        return null;
    }

    private String decodeBytesOld(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(new String(bytes));
        String cryptCRC = buffer.substring(0, 4);
        String clearText = buffer.substring(4);
        String realCRC = this.crcHeader(clearText);
        if (realCRC.equalsIgnoreCase(cryptCRC)) {
            int endPos = clearText.length();
            int i = buffer.length() - 1;
            while (i >= 0) {
                if (buffer.charAt(i) == '\u0000') {
                    --endPos;
                } else {
                    i = -1;
                }
                --i;
            }
            clearText = clearText.substring(0, endPos);
            return clearText;
        }
        return null;
    }

    public String encrypt(String text, String passphrase, int keylen) {
        RC2ParameterSpec parm = new RC2ParameterSpec(keylen);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passphrase.getBytes(this.getCharset()));
            SecretKeySpec skeySpec = new SecretKeySpec(md.digest(), "RC2");
            Cipher cipher = Cipher.getInstance("RC2/ECB/NoPadding");
            cipher.init(1, (Key)skeySpec, parm);
            byte[] newBytes = this.encodeStringNew(text);
            byte[] d = cipher.doFinal(newBytes);
            return Base64.encodeBytes(d);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String decrypt(String text, String passphrase, int keylen) {
        RC2ParameterSpec parm = new RC2ParameterSpec(keylen);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passphrase.getBytes(this.getCharset()));
            SecretKeySpec skeySpec = new SecretKeySpec(md.digest(), "RC2");
            Cipher cipher = Cipher.getInstance("RC2/ECB/NOPADDING");
            cipher.init(2, (Key)skeySpec, parm);
            byte[] dString = Base64.decode(text);
            byte[] d = cipher.doFinal(dString);
            String clearTextNew = this.decodeBytesNew(d);
            return clearTextNew;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String crcHeader(String text) {
        return this.crcHeader(text.getBytes());
    }

    private String crcHeader(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        int realCRC = (int)crc.getValue();
        realCRC ^= 0xFFFFFFFF;
        String hexCRC = Integer.toHexString(realCRC >>>= 0).substring(0, 4);
        return hexCRC.toString().toUpperCase();
    }
}

