/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Publishing;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;

public class PublishNotebook
extends QDialog {
    private final QPushButton okButton;
    private final QPushButton cancelButton;
    private boolean okClicked;
    private final QLabel urlLabel;
    private final QLineEdit url;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
    private final QTextEdit description;
    private final QComboBox sortedBy;
    private final QComboBox sortOrder;
    private boolean stopButtonPressed = false;
    private final QPushButton stopButton;

    public PublishNotebook(String userid, String url, Notebook n) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "globe.png"));
        this.okClicked = false;
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        userid = "sysrabt";
        this.urlLabel = new QLabel("http://" + url + this.tr("/pub/") + userid + this.tr("/"));
        QHBoxLayout urlLayout = new QHBoxLayout();
        urlLayout.addWidget((QWidget)this.urlLabel);
        this.url = new QLineEdit();
        this.url.textChanged.connect((Object)this, "urlEdited()");
        urlLayout.addWidget((QWidget)this.url);
        QVBoxLayout textEditLayout = new QVBoxLayout();
        textEditLayout.addWidget((QWidget)new QLabel(String.valueOf(this.tr("Notebook: ")) + n.getName()));
        textEditLayout.addWidget((QWidget)new QLabel(this.tr("Public URL")));
        textEditLayout.addLayout((QLayout)urlLayout);
        textEditLayout.addWidget((QWidget)new QLabel(this.tr("Description")));
        this.description = new QTextEdit();
        textEditLayout.addWidget((QWidget)this.description);
        this.sortedBy = new QComboBox((QWidget)this);
        this.sortOrder = new QComboBox((QWidget)this);
        QHBoxLayout orderLayout = new QHBoxLayout();
        orderLayout.addWidget((QWidget)new QLabel(this.tr("Sort By")));
        Qt.Alignment right = new Qt.Alignment(new Qt.AlignmentFlag[0]);
        right.set((QtEnumerator[])new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
        orderLayout.setAlignment(right);
        orderLayout.addWidget((QWidget)this.sortedBy);
        orderLayout.addSpacing(50);
        orderLayout.addWidget((QWidget)new QLabel(this.tr("Sort Order")));
        orderLayout.addWidget((QWidget)this.sortOrder);
        this.sortedBy.addItem(this.tr("Date Created"), (Object)NoteSortOrder.CREATED);
        this.sortedBy.addItem(this.tr("Date Updated"), (Object)NoteSortOrder.UPDATED);
        this.sortOrder.addItem(this.tr("Newest to oldest"), (Object)false);
        this.sortOrder.addItem(this.tr("Oldest to newest"), (Object)true);
        textEditLayout.addLayout((QLayout)orderLayout);
        this.cancelButton = new QPushButton();
        this.cancelButton.setText(this.tr("Cancel"));
        this.cancelButton.pressed.connect((Object)this, "onCancel()");
        this.stopButton = new QPushButton(this.tr("Stop Sharing"));
        this.stopButton.setVisible(false);
        this.stopButton.clicked.connect((Object)this, "stopPublishing()");
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.stopButton);
        buttonLayout.addWidget((QWidget)this.okButton);
        buttonLayout.addWidget((QWidget)this.cancelButton);
        this.setWindowTitle(this.tr("Share A Notebook With The World"));
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)textEditLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        if (n.isPublished()) {
            Publishing p = n.getPublishing();
            this.url.setText(p.getUri());
            this.description.setText(p.getPublicDescription());
            int position = this.sortOrder.findData((Object)p.isAscending());
            this.sortOrder.setCurrentIndex(position);
            position = this.sortedBy.findData((Object)p.getOrder());
            this.sortedBy.setCurrentIndex(position);
            this.okButton.setText(this.tr("Save Changes"));
            this.stopButton.setVisible(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.resize(500, 200);
    }

    private void onClicked() {
        this.okClicked = true;
        this.stopButtonPressed = false;
        this.close();
    }

    private void onCancel() {
        this.okClicked = false;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void itemSelected() {
        this.okButton.setEnabled(true);
    }

    private void urlEdited() {
        if (this.url.text().trim().equals("")) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private void stopPublishing() {
        this.stopButtonPressed = true;
        this.okClicked = true;
        this.close();
    }

    public boolean isStopPressed() {
        return this.stopButtonPressed;
    }

    public Publishing getPublishing() {
        Publishing p = new Publishing();
        p.setPublicDescription(this.description.toPlainText());
        int i = this.sortedBy.currentIndex();
        p.setOrder((NoteSortOrder)this.sortedBy.itemData(i));
        p.setAscending(((Boolean)this.sortOrder.itemData(i)).booleanValue());
        p.setUri(this.url.text());
        return p;
    }
}

