/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNode;
import com.trolltech.qt.xml.QDomNodeList;
import com.trolltech.qt.xml.QDomText;
import cx.fbn.nevernote.Global;
import java.util.ArrayList;
import java.util.List;

public class XMLCleanup {
    private String content;
    private QDomDocument doc;
    private final List<String> resources = new ArrayList<String>();

    public void setValue(String text) {
        this.content = text;
    }

    public String getValue() {
        return this.content;
    }

    public void validate() {
        QDomElement element;
        int i;
        int enMediaCount;
        this.doc = new QDomDocument();
        int br = this.content.lastIndexOf("</en-note>");
        this.content = new String(this.content.substring(0, br));
        int k = this.content.indexOf("<en-note");
        String newContent = new String(this.content.substring(k));
        newContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">\n" + newContent + "</en-note>";
        QDomDocument.Result result = this.doc.setContent(newContent);
        if (!result.success) {
            System.out.println("DOM error in XMLValidator.validate()");
            System.out.println(newContent);
            System.out.println("Location : Line-" + result.errorLine + " Column-" + result.errorColumn);
            System.out.println("Exiting");
            this.content = null;
            return;
        }
        QDomNodeList noteAnchors = this.doc.elementsByTagName("en-note");
        int noteCount = noteAnchors.length();
        int i2 = noteCount - 1;
        while (i2 >= 0) {
            String style;
            int startColor;
            if (noteAnchors.at(i2).toElement().hasAttribute("style") && (startColor = (style = noteAnchors.at(i2).toElement().attribute("style")).indexOf("background-color:")) > -1) {
                String color = style.substring(startColor + 17);
                color = color.substring(0, color.indexOf(";"));
                noteAnchors.at(i2).toElement().setAttribute("bgcolor", color);
            }
            --i2;
        }
        this.scanTags();
        QDomNodeList anchorList = this.doc.elementsByTagName("a");
        int anchorCount = anchorList.length();
        int i3 = anchorCount - 1;
        while (i3 >= 0) {
            QDomNode link = anchorList.at(i3);
            link = this.fixLinkNode(link);
            --i3;
        }
        for (String key : Global.invalidAttributes.keySet()) {
            QDomNodeList anchors = this.doc.elementsByTagName(key);
            enMediaCount = anchors.length();
            i = enMediaCount - 1;
            while (i >= 0) {
                element = anchors.at(i).toElement();
                ArrayList<String> names = Global.invalidAttributes.get(element.nodeName().toLowerCase());
                if (names != null) {
                    int j = 0;
                    while (j < names.size()) {
                        element.removeAttribute(names.get(j));
                        ++j;
                    }
                }
                --i;
            }
        }
        List<String> elements = Global.invalidElements;
        int j = 0;
        while (j < elements.size()) {
            QDomNodeList anchors = this.doc.elementsByTagName(elements.get(j));
            enMediaCount = anchors.length();
            i = enMediaCount - 1;
            while (i >= 0) {
                element = anchors.at(i).toElement();
                element.setTagName("span");
                --i;
            }
            ++j;
        }
        this.content = this.doc.toString().replace("&#xd;", "");
    }

    private void scanTags() {
        if (this.doc.hasChildNodes()) {
            this.parseNodes(this.doc.childNodes());
        }
    }

    private void parseNodes(QDomNodeList nodes) {
        int i = 0;
        while (i < nodes.size()) {
            QDomNode node = nodes.at(i);
            if (node.hasChildNodes()) {
                this.parseNodes(node.childNodes());
            }
            this.fixNode(node);
            ++i;
        }
    }

    private void fixNode(QDomNode node) {
        QDomText newText;
        QDomNode firstChild;
        QDomElement childElement;
        QDomElement e;
        QDomElement scanChecked = node.toElement();
        if (scanChecked.hasAttribute("checked")) {
            System.out.println(scanChecked.attribute("checked"));
            if (!scanChecked.attribute("checked").equalsIgnoreCase("true")) {
                scanChecked.setAttribute("checked", "false");
            }
        }
        if (node.nodeName().equalsIgnoreCase("#comment") || node.nodeName().equalsIgnoreCase("script")) {
            node.parentNode().removeChild(node);
        }
        if (node.nodeName().equalsIgnoreCase("input")) {
            e = node.toElement();
            e.setTagName("en-todo");
            String value = e.attribute("value");
            if (value.trim().equals("")) {
                value = "false";
            }
            e.removeAttribute("value");
            e.removeAttribute("unchecked");
            e.setAttribute("checked", value);
            e.removeAttribute("onclick");
            e.removeAttribute("onmouseover");
            e.removeAttribute("type");
        }
        if (node.nodeName().equalsIgnoreCase("a")) {
            node = this.fixLinkNode(node);
        }
        if (node.nodeName().equalsIgnoreCase("img")) {
            e = node.toElement();
            String enType = e.attribute("en-tag");
            if (enType.equalsIgnoreCase("en-crypt")) {
                String encrypted = e.attribute("alt");
                QDomText crypt = this.doc.createTextNode(encrypted);
                e.appendChild((QDomNode)crypt);
                e.removeAttribute("v:shapes");
                e.removeAttribute("en-tag");
                e.removeAttribute("contenteditable");
                e.removeAttribute("alt");
                e.removeAttribute("src");
                e.removeAttribute("id");
                e.removeAttribute("onclick");
                e.removeAttribute("onmouseover");
                e.setTagName("en-crypt");
                node.removeChild((QDomNode)e);
                return;
            }
            if (enType.equalsIgnoreCase("en-latex")) {
                enType = "en-media";
                QDomNode parent = e.parentNode();
                parent.removeChild((QDomNode)e);
                parent.parentNode().replaceChild((QDomNode)e, parent);
            }
            e.setTagName(enType);
            this.resources.add(e.attribute("guid"));
            e.removeAttribute("guid");
            e.removeAttribute("src");
            e.removeAttribute("en-new");
            e.removeAttribute("en-tag");
        }
        if (node.nodeName().equalsIgnoreCase("ul") && (childElement = (firstChild = node.firstChild()).toElement()).nodeName().equalsIgnoreCase("ul")) {
            QDomElement newElement = this.doc.createElement("li");
            node.insertBefore((QDomNode)newElement, firstChild);
            node.removeChild(firstChild);
            newElement.appendChild(firstChild);
        }
        if (node.nodeName().equalsIgnoreCase("en-hilight")) {
            e = node.toElement();
            newText = this.doc.createTextNode(e.text());
            e.parentNode().replaceChild((QDomNode)newText, (QDomNode)e);
        }
        if (node.nodeName().equalsIgnoreCase("span")) {
            e = node.toElement();
            if (e.attribute("class").equalsIgnoreCase("en-hilight") || e.attribute("class").equalsIgnoreCase("en-spell")) {
                newText = this.doc.createTextNode(e.text());
                e.parentNode().replaceChild((QDomNode)newText, (QDomNode)e);
            }
            if (e.attribute("pdfnavigationtable").equalsIgnoreCase("true")) {
                node.parentNode().removeChild(node);
            }
        }
        if (node.nodeName().equalsIgnoreCase("en-crypt-temp")) {
            e = node.toElement();
            e.setTagName("en-crypt");
            String crypt = e.attribute("value");
            e.removeAttribute("value");
            QDomText cryptValue = this.doc.createTextNode(crypt);
            e.appendChild((QDomNode)cryptValue);
        }
    }

    private QDomNode fixLinkNode(QDomNode node) {
        QDomElement e = node.toElement();
        String enTag = e.attribute("en-tag");
        if (enTag.equalsIgnoreCase("en-media")) {
            e.setTagName("en-media");
            e.removeAttribute("en-type");
            e.removeAttribute("en-tag");
            e.removeAttribute("en-new");
            this.resources.add(e.attribute("guid"));
            e.removeAttribute("href");
            e.removeAttribute("guid");
            e.setNodeValue("");
            e.removeChild((QDomNode)e.firstChildElement());
        }
        return e;
    }

    public List<String> getResources() {
        return this.resources;
    }
}

