/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.LinkedNotebook;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.List;

public class LinkedNotebookTable {
    private final ApplicationLogger logger;
    DatabaseConnection db;

    public LinkedNotebookTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table LinkedNotebook...");
        if (!query.exec("Create table LinkedNotebook (guid VarChar primary key, shareName VarChar, username VarChar, shardID VarChar, shareKey VarChar, uri VarChar, updateSequenceNumber Long,lastSequenceNumber Integer,lastSequenceDate Long,notebookGuid VarChar,isDirty boolean)")) {
            this.logger.log(this.logger.HIGH, "Table LinkedNotebook creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table LinkedNotebook");
    }

    public void addNotebook(LinkedNotebook tempNotebook, boolean isDirty) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Insert Into LinkedNotebook (guid, shareName, username,  shardId, shareKey, uri, updateSequenceNumber, isDirty, lastSequenceNumber, lastSequenceDate, notebookGuid)  Values(:guid, :shareName, :username, :shardId, :shareKey, :uri,:usn, :isDirty, 0, 0, :notebookGuid)");
        query.bindValue(":guid", tempNotebook.getGuid());
        query.bindValue(":shareName", tempNotebook.getShareName());
        query.bindValue(":username", tempNotebook.getUsername());
        query.bindValue(":shardId", tempNotebook.getShardId());
        query.bindValue(":shareKey", tempNotebook.getShareKey());
        query.bindValue(":usn", tempNotebook.getUpdateSequenceNum());
        query.bindValue(":uri", tempNotebook.getUri());
        query.bindValue(":notebookGuid", "");
        if (isDirty) {
            query.bindValue(":isDirty", true);
        } else {
            query.bindValue(":isDirty", false);
        }
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "LinkedNotebook Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
            return;
        }
    }

    public void expungeNotebook(String id, boolean needsSync) {
        String notebookGuid = this.getNotebookGuid(id);
        this.db.getNotebookTable().deleteLinkedTags(notebookGuid);
        List<String> notes = this.db.getNoteTable().getNotesByNotebook(notebookGuid);
        int i = 0;
        while (i < notes.size()) {
            this.db.getNoteTable().expungeNote(notes.get(i), true, needsSync);
            ++i;
        }
        this.db.getNotebookTable().expungeNotebook(notebookGuid, needsSync);
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("delete from LinkedNotebook where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "LinkedNotebook SQL delete prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        query.bindValue(":guid", id);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "LinkedNotebook delete failed.");
        }
        if (needsSync) {
            DeletedTable deletedTable = new DeletedTable(this.logger, this.db);
            deletedTable.addDeletedItem(new Long(id).toString(), "LinkedNotebook");
        }
    }

    public boolean exists(String id) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid from linkednotebook where guid=:guid");
        query.bindValue(":guid", id);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "LinkedNotebook Table exists check failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
        return query.next();
    }

    public void updateNotebook(LinkedNotebook tempNotebook, boolean isDirty) {
        if (!this.exists(tempNotebook.getGuid())) {
            this.addNotebook(tempNotebook, isDirty);
            return;
        }
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update LinkedNotebook set guid=:guid, shareName=:shareName, username=:username, shardID=:shardID, uri=:uri, updateSequenceNumber=:usn, isDirty=:isDirty where guid=:keyGuid");
        query.bindValue(":guid", tempNotebook.getGuid());
        query.bindValue(":keyGuid", tempNotebook.getGuid());
        query.bindValue(":shareName", tempNotebook.getShareName());
        query.bindValue(":username", tempNotebook.getUsername());
        query.bindValue(":shardID", tempNotebook.getShardId());
        query.bindValue(":shareKey", tempNotebook.getShareKey());
        query.bindValue(":uri", tempNotebook.getUri());
        query.bindValue(":usn", tempNotebook.getUpdateSequenceNum());
        query.bindValue(":isDirty", isDirty);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "LinkedNotebook Table update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public List<LinkedNotebook> getAll() {
        ArrayList<LinkedNotebook> index = new ArrayList<LinkedNotebook>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, shareName, username, shardID, shareKey, uri  from LinkedNotebook");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve has failed.");
        }
        while (query.next()) {
            LinkedNotebook tempNotebook = new LinkedNotebook();
            tempNotebook.setGuid(query.valueString(0));
            tempNotebook.setShareName(query.valueString(1));
            tempNotebook.setUsername(query.valueString(2));
            tempNotebook.setShardId(query.valueString(3));
            tempNotebook.setShareKey(query.valueString(4));
            tempNotebook.setUri(query.valueString(5));
            index.add(tempNotebook);
        }
        return index;
    }

    public LinkedNotebook getNotebook(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid, shareName, username, shardID, shareKey, uri  from LinkedNotebook where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve notebook prepare has failed.");
        }
        query.bindValue(":guid", guid);
        query.exec();
        if (query.next()) {
            LinkedNotebook tempNotebook = new LinkedNotebook();
            tempNotebook.setGuid(query.valueString(0));
            tempNotebook.setShareName(query.valueString(1));
            tempNotebook.setUsername(query.valueString(2));
            tempNotebook.setShardId(query.valueString(3));
            tempNotebook.setShareKey(query.valueString(4));
            tempNotebook.setUri(query.valueString(5));
            return tempNotebook;
        }
        return null;
    }

    public LinkedNotebook getByNotebookGuid(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid, shareName, username, shardID, shareKey, uri  from LinkedNotebook where notebookguid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve notebook prepare has failed.");
        }
        query.bindValue(":guid", guid);
        query.exec();
        if (query.next()) {
            LinkedNotebook tempNotebook = new LinkedNotebook();
            tempNotebook.setGuid(query.valueString(0));
            tempNotebook.setShareName(query.valueString(1));
            tempNotebook.setUsername(query.valueString(2));
            tempNotebook.setShardId(query.valueString(3));
            tempNotebook.setShareKey(query.valueString(4));
            tempNotebook.setUri(query.valueString(5));
            return tempNotebook;
        }
        return null;
    }

    public long getLastSequenceDate(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select LastSequenceDate from LinkedNotebook where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "LinkedNotebook SQL retrieve last sequence date has failed.");
        }
        if (query.next()) {
            return query.valueLong(0);
        }
        return 0L;
    }

    public String getNotebookGuid(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select notebookGuid from LinkedNotebook where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "LinkedNotebook SQL retrieve of notebookguid by guidhas failed.");
        }
        if (query.next()) {
            return query.valueString(0);
        }
        return null;
    }

    public int getLastSequenceNumber(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select LastSequenceNumber from LinkedNotebook where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve has failed.");
        }
        if (query.next()) {
            return query.valueInteger(0);
        }
        return 0;
    }

    public String getLocalNotebookGuid(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select notebookGuid from LinkedNotebook where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve has failed.");
        }
        if (query.next()) {
            return query.valueString(0);
        }
        return null;
    }

    public String findNotebookByShareName(String name) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from Linkednotebook where shareName=:name");
        query.bindValue(":name", name);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Linked notebook SQL retrieve by share name has failed.");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    public String setNotebookGuid(String shareKey, String notebookGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update LinkedNotebook set notebookGuid=:notebookGuid where shareKey=:shareKey");
        query.bindValue(":notebookGuid", notebookGuid);
        query.bindValue(":shareKey", shareKey);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Linked notebook SQL retrieve by share name has failed.");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    public String setLastSequenceDate(String guid, long date) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update LinkedNotebook set lastsequencedate=:date where guid=:guid");
        query.bindValue(":date", date);
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Linked notebook SQL retrieve by share name has failed.");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    public String setLastSequenceNumber(String guid, int number) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update LinkedNotebook set lastsequencenumber=:number where guid=:guid");
        query.bindValue(":number", number);
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Linked notebook SQL retrieve by share name has failed.");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    public List<String> getDirtyGuids() {
        ArrayList<String> index = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid from LinkedNotebook where isDirty = true");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "LinkedNotebook SQL retrieve has failed in getdirtyIds.");
        }
        while (query.next()) {
            index.add(query.valueString(0));
        }
        return index;
    }
}

