/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import java.text.SimpleDateFormat;

public class AccountDialog
extends QDialog {
    String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
    private final QPushButton ok;

    public AccountDialog() {
        this.setWindowTitle(this.tr("Account Information"));
        this.setWindowIcon(new QIcon(new QIcon(String.valueOf(this.iconPath) + "account.png")));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        QLabel premium = Global.isPremium() ? new QLabel(this.tr("Premium")) : new QLabel(this.tr("Free"));
        String userName = Global.username;
        Long uploadAmt = Global.getUploadAmount();
        Long uploadLimit = Global.getUploadLimit();
        Long uploadLimitEnd = Global.getUploadLimitEnd();
        Long pct = uploadLimit > 0L ? Long.valueOf(uploadAmt * 100L / uploadLimit) : new Long(0L);
        String unit = this.tr(" Bytes");
        if (uploadAmt > 0L) {
            uploadAmt = uploadAmt / 1024L;
            unit = this.tr(" KB");
        }
        if (uploadAmt >= 1024L) {
            uploadAmt = uploadAmt / 1024L;
            unit = this.tr(" MB");
        }
        if (uploadLimit > 0L) {
            uploadLimit = uploadLimit / 1024L / 1024L;
        }
        String fmt = Global.getDateFormat();
        String dateTimeFormat = new String(fmt);
        SimpleDateFormat simple = new SimpleDateFormat(dateTimeFormat);
        StringBuilder endDate = new StringBuilder(simple.format(uploadLimitEnd));
        QGroupBox limitGroup = new QGroupBox(this.tr("Account:"));
        QGridLayout textGrid = new QGridLayout();
        textGrid.addWidget((QWidget)new QLabel(this.tr("User Name:")), 1, 1);
        textGrid.addWidget((QWidget)new QLabel(userName), 1, 2);
        textGrid.addWidget((QWidget)new QLabel(this.tr("Account Type:")), 2, 1);
        textGrid.addWidget((QWidget)premium, 2, 2);
        textGrid.addWidget((QWidget)new QLabel(this.tr("Limit:")), 3, 1);
        textGrid.addWidget((QWidget)new QLabel(String.valueOf(uploadLimit.toString()) + " MB"), 3, 2);
        textGrid.addWidget((QWidget)new QLabel(this.tr("Uploaded In This Period:")), 4, 1);
        if (uploadAmt > 0L) {
            textGrid.addWidget((QWidget)new QLabel(String.valueOf(uploadAmt.toString()) + unit + " (" + pct + "%)"), 4, 2);
        } else {
            textGrid.addWidget((QWidget)new QLabel(this.tr("Less than 1MB")), 4, 2);
        }
        textGrid.addWidget((QWidget)new QLabel(this.tr("Current Cycle Ends:")), 5, 1);
        textGrid.addWidget((QWidget)new QLabel(endDate.toString()), 5, 2);
        limitGroup.setLayout((QLayout)textGrid);
        grid.addWidget((QWidget)limitGroup, 1, 1);
        QHBoxLayout buttonLayout = new QHBoxLayout();
        this.ok = new QPushButton("OK");
        this.ok.clicked.connect((Object)this, "okPushed()");
        buttonLayout.addStretch();
        buttonLayout.addWidget((QWidget)this.ok);
        buttonLayout.addStretch();
        grid.addLayout((QLayout)buttonLayout, 3, 1);
    }

    private void okPushed() {
        this.close();
    }

    public QPushButton getOkButton() {
        return this.ok;
    }
}

