/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.utilities;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteAttributes;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.webkit.QWebPage;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.FileUtils;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class FileImporter {
    private final ApplicationLogger logger;
    private String fileName;
    private String content;
    private QFileInfo fileInfo;
    private Note newNote;
    private String noteString;
    private final DatabaseConnection conn;

    public FileImporter(ApplicationLogger l, DatabaseConnection c) {
        this.logger = l;
        this.conn = c;
    }

    public boolean importFile() {
        if (this.fileInfo.isFile()) {
            if (this.fileInfo.completeSuffix().equalsIgnoreCase("txt")) {
                return this.importTextFile();
            }
            return this.importAttachment();
        }
        return false;
    }

    public boolean importTextFile() {
        QFile file = new QFile(this.fileName);
        if (!file.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly}))) {
            this.logger.log(this.logger.LOW, "Unable to save externally edited file - locked.  Saving for later.");
            return false;
        }
        QByteArray binData = file.readAll();
        file.close();
        if (binData.size() == 0) {
            this.logger.log(this.logger.LOW, "Unable to save externally edited file - zero size.  Saving for later.");
            return false;
        }
        String fileData = binData.toString();
        QWebPage page = new QWebPage();
        page.mainFrame().setContent(binData);
        fileData = page.mainFrame().toHtml();
        fileData = fileData.replace("\n", "<br>\n");
        this.noteString = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">\n<en-note>\n<br clear=\"none\" />" + fileData + "</en-note>");
        this.noteString = fileData;
        this.buildEmptyNote();
        this.newNote.setAttributes(new NoteAttributes());
        return true;
    }

    public boolean importAttachment() {
        Resource newRes;
        QFile file = new QFile(this.fileName);
        if (!file.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly}))) {
            this.logger.log(this.logger.LOW, "Unable to save externally edited file - locked.  Saving for later.");
            return false;
        }
        QByteArray binData = file.readAll();
        file.close();
        if (binData.size() == 0) {
            this.logger.log(this.logger.LOW, "Unable to save externally edited file - zero size.  Saving for later.");
            return false;
        }
        this.buildEmptyNote();
        this.newNote.setAttributes(new NoteAttributes());
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><head></head><body>\n");
        if (this.isImage(this.fileInfo.completeSuffix())) {
            String mimeType = "image/" + this.fileInfo.completeSuffix();
            if (mimeType.equals("image/jpg")) {
                mimeType = "image/jpeg";
            }
            newRes = this.createResource(mimeType, false);
            buffer.append("<img src=\"" + this.fileName);
            buffer.append("\" en-tag=\"en-media\" type=\"" + mimeType + "\"" + " hash=\"" + Global.byteArrayToHexString(newRes.getData().getBodyHash()) + "\"" + " guid=\"" + newRes.getGuid() + "\">");
        } else {
            String mimeType = "application/" + this.fileInfo.completeSuffix();
            newRes = this.createResource(mimeType, false);
            newRes.getAttributes().setFileName(this.fileInfo.fileName());
            String icon = this.findIcon(this.fileInfo.completeSuffix());
            String imageURL = FileUtils.toFileURLString(Global.getFileManager().getImageDirFile(icon));
            buffer.append("<a en-tag=\"en-media\" guid=\"" + newRes.getGuid() + "\" ");
            buffer.append("type=\"" + mimeType + "\" href=\"nnres://" + this.fileName + "\" hash=\"" + Global.byteArrayToHexString(newRes.getData().getBodyHash()) + "\" >");
            buffer.append("<img src=\"" + imageURL + "\" title=\"" + newRes.getAttributes().getFileName());
            buffer.append("\">");
            buffer.append("</a>");
        }
        buffer.append("</body></html>");
        this.content = buffer.toString();
        this.noteString = buffer.toString();
        this.newNote.setContent(this.content);
        this.newNote.setResources(new ArrayList());
        this.newNote.getResources().add(newRes);
        this.newNote.setResourcesIsSet(true);
        return true;
    }

    private boolean isImage(String type) {
        if (type.equalsIgnoreCase("JPG")) {
            return true;
        }
        if (type.equalsIgnoreCase("JPEG")) {
            return true;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return true;
        }
        if (type.equalsIgnoreCase("GIF")) {
            return true;
        }
        if (!Global.isPremium()) {
            return false;
        }
        if (type.equalsIgnoreCase("XPM")) {
            return true;
        }
        return type.equalsIgnoreCase("BMP");
    }

    private void buildEmptyNote() {
        GregorianCalendar currentTime = new GregorianCalendar();
        String baseNote = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">\n<en-note>\n<br clear=\"none\" /></en-note>");
        Long l = new Long(currentTime.getTimeInMillis());
        long prevTime = l;
        while (prevTime == l) {
            currentTime = new GregorianCalendar();
            l = currentTime.getTimeInMillis();
        }
        String randint = new String(Long.toString(l));
        this.newNote = new Note();
        this.newNote.setUpdateSequenceNum(0);
        this.newNote.setGuid(randint);
        this.newNote.setTitle(this.fileName);
        this.newNote.setContent(baseNote);
        this.newNote.setDeleted(0L);
        int cdate = this.fileInfo.created().toTime_t();
        int mdate = this.fileInfo.lastModified().toTime_t();
        this.newNote.setCreated((long)cdate * 1000L);
        this.newNote.setUpdated((long)mdate * 1000L);
        this.newNote.setActive(true);
        NoteAttributes na = new NoteAttributes();
        na.setLatitude(0.0);
        na.setLongitude(0.0);
        na.setAltitude(0.0);
    }

    public boolean isValidType() {
        return this.checkFileAttachmentSize(this.fileName);
    }

    private boolean checkFileAttachmentSize(String url) {
        QFile resourceFile = new QFile(this.fileName);
        resourceFile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly}));
        long size = resourceFile.size();
        resourceFile.close();
        size = size / 1024L / 1024L;
        if (size < 50L && Global.isPremium()) {
            return true;
        }
        return size < 25L;
    }

    private Resource createResource(String mime, boolean attachment) {
        QFile resourceFile = new QFile(this.fileName);
        resourceFile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly}));
        byte[] fileData = resourceFile.readAll().toByteArray();
        resourceFile.close();
        if (fileData.length == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(fileData);
            byte[] hash = md.digest();
            Resource r = new Resource();
            GregorianCalendar time = new GregorianCalendar();
            Long l = time.getTimeInMillis();
            long prevTime = l;
            while (l == prevTime) {
                time = new GregorianCalendar();
                l = time.getTimeInMillis();
            }
            r.setGuid(new Long(l).toString());
            r.setNoteGuid(this.newNote.getGuid());
            r.setMime(mime);
            r.setActive(true);
            r.setUpdateSequenceNum(0);
            r.setWidth((short)0);
            r.setHeight((short)0);
            r.setDuration((short)0);
            Data d = new Data();
            d.setBody(fileData);
            d.setBodyIsSet(true);
            d.setBodyHash(hash);
            d.setBodyHashIsSet(true);
            r.setData(d);
            d.setSize(fileData.length);
            ResourceAttributes a = new ResourceAttributes();
            a.setAltitude(0.0);
            a.setAltitudeIsSet(false);
            a.setLongitude(0.0);
            a.setLongitudeIsSet(false);
            a.setLatitude(0.0);
            a.setLatitudeIsSet(false);
            a.setCameraMake("");
            a.setCameraMakeIsSet(false);
            a.setCameraModel("");
            a.setCameraModelIsSet(false);
            a.setAttachment(attachment);
            a.setAttachmentIsSet(true);
            a.setClientWillIndex(false);
            a.setClientWillIndexIsSet(true);
            a.setRecoType("");
            a.setRecoTypeIsSet(false);
            a.setSourceURLIsSet(false);
            a.setTimestamp(0L);
            a.setTimestampIsSet(false);
            a.setFileName(this.fileInfo.fileName());
            a.setFileNameIsSet(true);
            r.setAttributes(a);
            this.conn.getNoteTable().noteResourceTable.saveNoteResource(r, true);
            return r;
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public void setFileInfo(QFileInfo f) {
        this.fileInfo = f;
    }

    public void setFileName(String f) {
        this.fileName = f;
    }

    public String getContent() {
        return this.content;
    }

    public Note getNote() {
        return this.newNote;
    }

    public String getNoteContent() {
        return this.noteString;
    }

    private String findIcon(String appl) {
        appl = appl.toLowerCase();
        String relativePath = String.valueOf(appl) + ".png";
        File f = Global.getFileManager().getImageDirFile(relativePath);
        if (f.exists()) {
            return relativePath;
        }
        return "attachment.png";
    }
}

