/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.ListManager;
import java.util.ArrayList;
import java.util.List;

public class SyncTable {
    ListManager parent;
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public SyncTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table Sync...");
        if (!query.exec("Create table Sync (key varchar primary key, value varchar);")) {
            this.logger.log(this.logger.HIGH, "Table Sync creation FAILED!!!");
        }
        this.addRecord("LastSequenceDate", "0");
        this.addRecord("UpdateSequenceNumber", "0");
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table Sync");
    }

    public void addRecord(String key, String value) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Insert Into Sync (key,  value) values (:key, :value);");
        query.bindValue(":key", key);
        query.bindValue(":value", value);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Add to into Sync failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void deleteRecord(String key) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Delete From Sync where key=:key");
        query.bindValue(":key", key);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Delete from Sync failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public String getRecord(String key) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select value from Sync where key=:key");
        query.bindValue(":key", key);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "getRecord from sync failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        if (query.next()) {
            return query.valueString(0);
        }
        return null;
    }

    public void setRecord(String key, String value) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update Sync set value=:value where key=:key");
        query.bindValue(":key", key);
        query.bindValue(":value", value);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "setRecord from sync failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void setLastSequenceDate(long date) {
        this.logger.log(this.logger.LOW, "Updating Last Sequence Date: " + date);
        long old = this.getLastSequenceDate();
        this.logger.log(this.logger.LOW, "Old Last Sequence Date: " + old);
        if (date < old) {
            this.logger.log(this.logger.LOW, "************* SEQUENCE DATE PROBLEM!!! " + (old - date));
        }
        this.setRecord("LastSequenceDate", new Long(date).toString());
    }

    public void setUpdateSequenceNumber(int number) {
        this.logger.log(this.logger.LOW, "Updating Last Sequence Number: " + number);
        int old = this.getUpdateSequenceNumber();
        this.logger.log(this.logger.LOW, "Old Last Sequence Number: " + old);
        if (number < old) {
            this.logger.log(this.logger.LOW, "************* SEQUENCE NUMBER PROBLEM!!! " + (old - number));
        }
        this.setRecord("UpdateSequenceNumber", new Integer(number).toString());
    }

    public long getLastSequenceDate() {
        return new Long(this.getRecord("LastSequenceDate"));
    }

    public int getUpdateSequenceNumber() {
        return new Integer(this.getRecord("UpdateSequenceNumber"));
    }

    public List<String> getIgnoreRecords(String type) {
        ArrayList<String> values = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select value from Sync where key like :type")) {
            this.logger.log(this.logger.MEDIUM, "getIgnoreRecords from sync failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        query.bindValue(":type", "IGNORE" + type + "-%");
        query.exec();
        while (query.next()) {
            values.add(query.valueString(0));
        }
        return values;
    }
}

