/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.gui.QDesktopServices;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPrintDialog;
import com.trolltech.qt.gui.QPrinter;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.dialog.FindDialog;
import cx.fbn.nevernote.gui.BrowserWindow;
import cx.fbn.nevernote.gui.TabBrowserWidget;
import cx.fbn.nevernote.neighbornote.ClipBoardObserver;
import cx.fbn.nevernote.sql.DatabaseConnection;
import java.awt.Desktop;

public class TabBrowse
extends QWidget {
    private final DatabaseConnection conn;
    private final BrowserWindow browser;
    public QSignalEmitter.Signal4<String, String, Boolean, BrowserWindow> contentsChanged;
    private boolean noteDirty;
    String saveTitle;
    private final FindDialog find;
    private final TabBrowserWidget parent;
    private final ClipBoardObserver cbObserver;

    public TabBrowse(DatabaseConnection c, TabBrowserWidget p, ClipBoardObserver cbObserver) {
        this.conn = c;
        this.parent = p;
        this.cbObserver = cbObserver;
        this.contentsChanged = new QSignalEmitter.Signal4((QSignalEmitter)this);
        this.browser = new BrowserWindow(this.conn, this.cbObserver);
        QVBoxLayout v = new QVBoxLayout();
        v.addWidget((QWidget)this.browser);
        this.setLayout((QLayout)v);
        this.noteDirty = false;
        this.browser.titleLabel.textChanged.connect((Object)this, "titleChanged(String)");
        this.browser.getBrowser().page().contentsChanged.connect((Object)this, "contentChanged()");
        this.find = new FindDialog();
        this.find.getOkButton().clicked.connect((Object)this, "doFindText()");
    }

    private void contentChanged() {
        this.noteDirty = true;
        this.contentsChanged.emit((Object)this.getBrowserWindow().getNote().getGuid(), (Object)this.getBrowserWindow().getContent(), (Object)false, (Object)this.getBrowserWindow());
    }

    public BrowserWindow getBrowserWindow() {
        return this.browser;
    }

    private void titleChanged(String value) {
        int index = this.parent.indexOf(this);
        if (index >= 0) {
            this.parent.setTabTitle(index, value);
        }
    }

    private void findText() {
        this.find.show();
        this.find.setFocusOnTextField();
    }

    private void doFindText() {
        this.browser.getBrowser().page().findText(this.find.getText(), this.find.getFlags());
        this.find.setFocus();
    }

    private void printNote() {
        QPrintDialog dialog = new QPrintDialog();
        if (dialog.exec() == QDialog.DialogCode.Accepted.value()) {
            QPrinter printer = dialog.printer();
            this.browser.getBrowser().print(printer);
        }
    }

    private void emailNote() {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            String text2 = this.browser.getContentsToEmail();
            QUrl url = new QUrl("mailto:");
            url.addQueryItem("subject", this.browser.getTitle());
            url.addQueryItem("body", text2);
            QDesktopServices.openUrl((QUrl)url);
        }
    }

    public boolean getNoteDirty() {
        return this.noteDirty;
    }
}

