/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import java.text.NumberFormat;

public class DatabaseStatus
extends QDialog {
    QLabel indexNeeded;
    QLabel syncNeeded;
    QLabel noteCount;
    QLabel notebookCount;
    QLabel tagCount;
    QLabel savedSearchCount;
    QLabel resourceCount;
    QLabel indexCount;
    QLabel resourceIndexNeeded;
    QLabel historyCount;
    private final QPushButton ok;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public DatabaseStatus() {
        this.setWindowTitle(this.tr("Current Database Status"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "database.png"));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        this.noteCount = new QLabel();
        this.indexNeeded = new QLabel();
        this.syncNeeded = new QLabel();
        this.notebookCount = new QLabel();
        this.tagCount = new QLabel();
        this.savedSearchCount = new QLabel();
        this.resourceCount = new QLabel();
        this.resourceIndexNeeded = new QLabel();
        this.indexCount = new QLabel();
        this.historyCount = new QLabel();
        grid.addWidget((QWidget)new QLabel(this.tr("Notebooks:")), 0, 0);
        grid.addWidget((QWidget)this.notebookCount, 0, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Tags:")), 1, 0);
        grid.addWidget((QWidget)this.tagCount, 1, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Total Notes:")), 2, 0);
        grid.addWidget((QWidget)this.noteCount, 2, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Unsynchronized Notes:")), 3, 0);
        grid.addWidget((QWidget)this.syncNeeded, 3, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Unindexed Notes:")), 4, 0);
        grid.addWidget((QWidget)this.indexNeeded, 4, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Attachments/Images:")), 5, 0);
        grid.addWidget((QWidget)this.resourceCount, 5, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Unindexed Attachments/Images:")), 6, 0);
        grid.addWidget((QWidget)this.resourceIndexNeeded, 6, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Saved Searches:")), 7, 0);
        grid.addWidget((QWidget)this.savedSearchCount, 7, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Words In Index")), 8, 0);
        grid.addWidget((QWidget)this.indexCount, 8, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("Tobal Behavior History:")), 9, 0);
        grid.addWidget((QWidget)this.historyCount, 9, 1);
        QGridLayout buttonLayout = new QGridLayout();
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okPushed()");
        buttonLayout.addWidget((QWidget)this.ok, 1, 1);
        grid.addLayout((QLayout)buttonLayout, 10, 1);
    }

    private void okPushed() {
        this.close();
    }

    public void setUnindexed(int d) {
        this.indexNeeded.setText(NumberFormat.getInstance().format(d));
    }

    public void setUnsynchronized(int d) {
        this.syncNeeded.setText(NumberFormat.getInstance().format(d));
    }

    public void setNoteCount(int d) {
        this.noteCount.setText(NumberFormat.getInstance().format(d));
    }

    public void setNotebookCount(int d) {
        this.notebookCount.setText(NumberFormat.getInstance().format(d));
    }

    public void setTagCount(int d) {
        this.tagCount.setText(NumberFormat.getInstance().format(d));
    }

    public void setSavedSearchCount(int d) {
        this.savedSearchCount.setText(NumberFormat.getInstance().format(d));
    }

    public void setResourceCount(int d) {
        this.resourceCount.setText(NumberFormat.getInstance().format(d));
    }

    public void setUnindexedResourceCount(int r) {
        this.resourceIndexNeeded.setText(NumberFormat.getInstance().format(r));
    }

    public void setWordCount(int d) {
        this.indexCount.setText(NumberFormat.getInstance().format(d));
    }

    public void setHistoryCount(int d) {
        this.historyCount.setText(NumberFormat.getInstance().format(d));
    }

    public QPushButton getOkButton() {
        return this.ok;
    }
}

