/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteAttributes;
import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Publishing;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.Tag;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.xml.QXmlStreamAttributes;
import com.trolltech.qt.xml.QXmlStreamReader;
import cx.fbn.nevernote.evernote.NoteMetadata;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class ImportData {
    public int lastError;
    private String errorMessage;
    private String fileName;
    DatabaseConnection conn;
    QXmlStreamReader reader;
    private Note note;
    private boolean noteIsDirty;
    private Notebook notebook;
    private boolean notebookIsDirty;
    private boolean notebookIsLocal;
    private boolean notebookIsReadOnly;
    private QIcon notebookIcon;
    private Tag tag;
    private boolean tagIsDirty;
    private SavedSearch search;
    private boolean searchIsDirty;
    public int highUpdateSequenceNumber;
    public long lastSequenceDate;
    private final ApplicationLogger logger = new ApplicationLogger("import.log");
    private final boolean backup;
    private String notebookGuid;
    private boolean linkedNotebookIsDirty;
    private boolean sharedNotebookIsDirty;
    private LinkedNotebook linkedNotebook;
    private SharedNotebook sharedNotebook;
    public final boolean importTags = false;
    public final boolean importNotebooks = false;
    private final HashMap<String, String> noteMap;
    private final HashMap<String, NoteMetadata> metaData;

    public ImportData(DatabaseConnection c, boolean full) {
        this.backup = full;
        this.conn = c;
        this.metaData = new HashMap();
        this.noteMap = new HashMap();
    }

    public void importData(String f) {
        this.fileName = f;
        this.errorMessage = "";
        this.lastError = 0;
        this.errorMessage = "";
        QFile xmlFile = new QFile(this.fileName);
        if (!xmlFile.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
            this.lastError = 16;
            this.errorMessage = "Cannot open file.";
        }
        this.reader = new QXmlStreamReader((QIODevice)xmlFile);
        while (!this.reader.atEnd()) {
            this.reader.readNext();
            if (this.reader.hasError()) {
                this.errorMessage = this.reader.errorString();
                this.logger.log(this.logger.LOW, "************************* ERROR READING BACKUP " + this.reader.errorString());
                this.lastError = 16;
                return;
            }
            if (this.reader.name().equalsIgnoreCase("nevernote-export") && this.reader.isStartElement()) {
                QXmlStreamAttributes attributes = this.reader.attributes();
                String version = attributes.value("version");
                String type = attributes.value("exportType");
                String application = attributes.value("application");
                if (!(version.equalsIgnoreCase("0.85") || version.equalsIgnoreCase("0.86") || version.equalsIgnoreCase("0.95"))) {
                    this.lastError = 1;
                    this.errorMessage = "Unknown backup version = " + version;
                    return;
                }
                if (!application.equalsIgnoreCase("NeverNote")) {
                    this.lastError = 2;
                    this.errorMessage = "This backup is from an unknown application = " + application;
                    return;
                }
                if (!type.equalsIgnoreCase("backup") && this.backup) {
                    this.lastError = 4;
                    this.errorMessage = "This is an export file, not a backup file";
                    return;
                }
                if (type.equalsIgnoreCase("export") && this.backup) {
                    this.lastError = 5;
                    this.errorMessage = "This is a backup file, not an export file";
                    return;
                }
            }
            if (this.reader.name().equalsIgnoreCase("Synchronization") && this.reader.isStartElement() && this.backup) {
                this.processSynchronizationNode();
                this.conn.getSyncTable().setLastSequenceDate(this.lastSequenceDate);
                this.conn.getSyncTable().setUpdateSequenceNumber(this.highUpdateSequenceNumber);
            }
            if (this.reader.name().equalsIgnoreCase("note") && this.reader.isStartElement()) {
                this.processNoteNode();
                if (this.backup) {
                    this.conn.getNoteTable().addNote(this.note, this.noteIsDirty);
                } else {
                    this.note.setUpdateSequenceNum(0);
                    if (this.notebookGuid != null) {
                        this.note.setNotebookGuid(this.notebookGuid);
                    }
                    int i = 0;
                    while (i < this.note.getResourcesSize()) {
                        ((Resource)this.note.getResources().get(i)).setUpdateSequenceNum(0);
                        ++i;
                    }
                    this.conn.getNoteTable().addNote(this.note, true);
                }
                if (this.metaData.containsKey(this.note.getGuid())) {
                    this.conn.getNoteTable().updateNoteMetadata(this.metaData.get(this.note.getGuid()));
                }
            }
            if (this.reader.name().equalsIgnoreCase("notebook") && this.reader.isStartElement() && this.backup) {
                this.processNotebookNode();
                String existingGuid = this.conn.getNotebookTable().findNotebookByName(this.notebook.getName());
                if (existingGuid == null) {
                    this.conn.getNotebookTable().addNotebook(this.notebook, this.notebookIsDirty, this.notebookIsLocal);
                } else {
                    this.conn.getNotebookTable().updateNotebookGuid(existingGuid, this.notebook.getGuid());
                    this.conn.getNotebookTable().updateNotebook(this.notebook, this.notebookIsDirty);
                }
                this.conn.getNotebookTable().setIcon(this.notebook.getGuid(), this.notebookIcon, "PNG");
                this.conn.getNotebookTable().setReadOnly(this.notebook.getGuid(), this.notebookIsReadOnly);
            }
            if (this.reader.name().equalsIgnoreCase("tag") && this.reader.isStartElement() && this.backup) {
                this.processTagNode();
                String testGuid = this.conn.getTagTable().findTagByName(this.tag.getName());
                if (testGuid == null) {
                    this.conn.getTagTable().addTag(this.tag, this.tagIsDirty);
                } else {
                    this.conn.getTagTable().updateTagGuid(testGuid, this.tag.getGuid());
                    this.conn.getTagTable().updateTag(this.tag, this.tagIsDirty);
                }
            }
            if (this.reader.name().equalsIgnoreCase("savedsearch") && this.reader.isStartElement() && this.backup) {
                this.processSavedSearchNode();
                this.conn.getSavedSearchTable().addSavedSearch(this.search, this.searchIsDirty);
            }
            if (this.reader.name().equalsIgnoreCase("LinkedNotebook") && this.reader.isStartElement() && this.backup) {
                this.processLinkedNotebookNode();
                this.conn.getLinkedNotebookTable().addNotebook(this.linkedNotebook, this.linkedNotebookIsDirty);
            }
            if (!this.reader.name().equalsIgnoreCase("SharedNotebook") || !this.reader.isStartElement() || !this.backup) continue;
            this.processSharedNotebookNode();
            this.conn.getSharedNotebookTable().addNotebook(this.sharedNotebook, this.sharedNotebookIsDirty);
        }
        xmlFile.close();
    }

    private void processNoteNode() {
        this.note = new Note();
        this.note.setResources(new ArrayList());
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Guid")) {
                    this.note.setGuid(this.textValue());
                    if (!this.backup) {
                        Random random1 = new Random();
                        String newGuid = "IMP" + new Integer(random1.nextInt(1000)).toString();
                        newGuid = String.valueOf(newGuid) + "-" + new Integer(random1.nextInt(1000)).toString();
                        newGuid = String.valueOf(newGuid) + "-" + new Integer(random1.nextInt(1000)).toString();
                        newGuid = String.valueOf(newGuid) + "-" + new Integer(random1.nextInt(1000)).toString();
                        this.noteMap.put(this.note.getGuid(), newGuid);
                        this.note.setGuid(newGuid);
                    } else {
                        this.noteMap.put(this.note.getGuid(), this.note.getGuid());
                    }
                }
                if (this.reader.name().equalsIgnoreCase("UpdateSequenceNumber")) {
                    this.note.setUpdateSequenceNum(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("Title")) {
                    this.note.setTitle(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Created")) {
                    this.note.setCreated(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("Updated")) {
                    this.note.setUpdated(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("Deleted")) {
                    this.note.setDeleted(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("Active")) {
                    this.note.setActive(this.booleanValue());
                }
                if (this.reader.name().equalsIgnoreCase("NotebookGuid")) {
                    this.note.setNotebookGuid(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Content")) {
                    this.note.setContent(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("NoteTags")) {
                    this.note.setTagGuids(this.processNoteTagList());
                }
                if (this.reader.name().equalsIgnoreCase("NoteAttributes")) {
                    this.note.setAttributes(this.processNoteAttributes());
                }
                if (this.reader.name().equalsIgnoreCase("NoteResource")) {
                    this.note.getResources().add(this.processResource());
                }
                if (this.reader.name().equalsIgnoreCase("Dirty") && this.booleanValue()) {
                    this.noteIsDirty = true;
                }
                if (this.reader.name().equalsIgnoreCase("TitleColor")) {
                    if (this.metaData.get(this.note.getGuid()) == null) {
                        NoteMetadata m = new NoteMetadata();
                        m.setColor(this.intValue());
                        this.metaData.put(this.note.getGuid(), m);
                    } else {
                        this.metaData.get(this.note.getGuid()).setColor(this.intValue());
                    }
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("note") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private Resource processResource() {
        Resource resource = new Resource();
        boolean atEnd = false;
        boolean isDirty = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Guid")) {
                    resource.setGuid(this.textValue());
                }
                if (!this.backup) {
                    Random random1 = new Random();
                    String newGuid = "IMP" + new Integer(random1.nextInt(1000)).toString();
                    newGuid = String.valueOf(newGuid) + "-" + new Integer(random1.nextInt(1000)).toString();
                    newGuid = String.valueOf(newGuid) + "-" + new Integer(random1.nextInt(1000)).toString();
                    newGuid = String.valueOf(newGuid) + "-" + new Integer(random1.nextInt(1000)).toString();
                    resource.setGuid(newGuid);
                }
                if (this.reader.name().equalsIgnoreCase("NoteGuid")) {
                    String tx = this.textValue();
                    resource.setNoteGuid(this.noteMap.get(this.textValue()));
                    resource.setNoteGuid(this.noteMap.get(tx));
                }
                if (this.reader.name().equalsIgnoreCase("UpdateSequenceNumber")) {
                    resource.setUpdateSequenceNum(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("Active")) {
                    resource.setActive(this.booleanValue());
                }
                if (this.reader.name().equalsIgnoreCase("Mime")) {
                    resource.setMime(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Duration")) {
                    resource.setDuration(this.shortValue());
                }
                if (this.reader.name().equalsIgnoreCase("Height")) {
                    resource.setHeight(this.shortValue());
                }
                if (this.reader.name().equalsIgnoreCase("Width")) {
                    resource.setWidth(this.shortValue());
                }
                if (this.reader.name().equalsIgnoreCase("dirty")) {
                    isDirty = this.booleanValue();
                }
                if (this.reader.name().equalsIgnoreCase("Data")) {
                    resource.setData(this.processData("Data"));
                }
                if (this.reader.name().equalsIgnoreCase("AlternateData")) {
                    resource.setAlternateData(this.processData("AlternateData"));
                }
                if (this.reader.name().equalsIgnoreCase("RecognitionData")) {
                    resource.setRecognition(this.processData("RecognitionData"));
                }
                if (this.reader.name().equalsIgnoreCase("NoteResourceAttribute")) {
                    resource.setAttributes(this.processResourceAttributes());
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("noteresource") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        this.conn.getNoteTable().noteResourceTable.saveNoteResource(resource, isDirty);
        return resource;
    }

    private Data processData(String nodeName) {
        Data data = new Data();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                QByteArray binData;
                QByteArray hexData;
                byte[] b;
                if (this.reader.name().equalsIgnoreCase("Size")) {
                    data.setSize(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("Body")) {
                    b = this.textValue().getBytes();
                    hexData = new QByteArray(b);
                    binData = new QByteArray(QByteArray.fromHex((QByteArray)hexData));
                    data.setBody(binData.toByteArray());
                }
                if (this.reader.name().equalsIgnoreCase("BodyHash")) {
                    b = this.textValue().getBytes();
                    hexData = new QByteArray(b);
                    binData = new QByteArray(QByteArray.fromHex((QByteArray)hexData));
                    data.setBodyHash(binData.toByteArray());
                }
                this.reader.readNext();
                if (this.reader.name().equalsIgnoreCase("data") && this.reader.isEndElement()) {
                    atEnd = true;
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase(nodeName) || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        return data;
    }

    private ResourceAttributes processResourceAttributes() {
        ResourceAttributes attributes = new ResourceAttributes();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("CameraMake")) {
                    attributes.setCameraMake(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("CameraModel")) {
                    attributes.setCameraModel(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("FileName")) {
                    attributes.setFileName(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("RecoType")) {
                    attributes.setRecoType(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("CameraModel")) {
                    attributes.setCameraMake(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("SourceURL")) {
                    attributes.setSourceURL(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Altitude")) {
                    attributes.setAltitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Longitude")) {
                    attributes.setLongitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Latitude")) {
                    attributes.setLatitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Timestamp")) {
                    attributes.setTimestamp(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("Attachment")) {
                    attributes.setAttachment(this.booleanValue());
                }
                if (this.reader.name().equalsIgnoreCase("ClientWillIndex")) {
                    attributes.setClientWillIndex(this.booleanValue());
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("noteresourceattribute") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        return attributes;
    }

    private List<String> processNoteTagList() {
        ArrayList<String> guidList = new ArrayList<String>();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement() && this.reader.name().equalsIgnoreCase("guid")) {
                guidList.add(this.textValue());
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("notetags") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        return guidList;
    }

    private NoteAttributes processNoteAttributes() {
        NoteAttributes attributes = new NoteAttributes();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Author")) {
                    attributes.setAuthor(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("SourceURL")) {
                    attributes.setSourceURL(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Source")) {
                    attributes.setSource(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("SourceApplication")) {
                    attributes.setSourceApplication(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Altitude")) {
                    attributes.setAltitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Longitude")) {
                    attributes.setLongitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Latitude")) {
                    attributes.setLatitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("SubjectDate")) {
                    attributes.setSubjectDate(this.longValue());
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("noteattributes") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        return attributes;
    }

    private void processSynchronizationNode() {
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("UpdateSequenceNumber")) {
                    this.highUpdateSequenceNumber = this.intValue();
                }
                if (this.reader.name().equalsIgnoreCase("LastSequenceDate")) {
                    this.lastSequenceDate = this.longValue();
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("synchronization") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private void processSavedSearchNode() {
        this.search = new SavedSearch();
        this.searchIsDirty = false;
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Guid")) {
                    this.search.setGuid(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Name")) {
                    this.search.setName(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("UpdateSequenceNumber")) {
                    this.search.setUpdateSequenceNum(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("Query")) {
                    this.search.setQuery(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Dirty") && this.booleanValue()) {
                    this.searchIsDirty = true;
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("savedsearch") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private void processLinkedNotebookNode() {
        this.linkedNotebook = new LinkedNotebook();
        this.linkedNotebookIsDirty = false;
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Guid")) {
                    this.linkedNotebook.setGuid(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("ShardID")) {
                    this.linkedNotebook.setShardId(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("UpdateSequenceNumber")) {
                    this.linkedNotebook.setUpdateSequenceNum(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("ShareKey")) {
                    this.linkedNotebook.setShareKey(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("ShareName")) {
                    this.linkedNotebook.setShareName(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Uri")) {
                    this.linkedNotebook.setUri(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Username")) {
                    this.linkedNotebook.setUsername(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Dirty") && this.booleanValue()) {
                    this.linkedNotebookIsDirty = true;
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("LinkedNotebook") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private void processSharedNotebookNode() {
        this.sharedNotebook = new SharedNotebook();
        this.sharedNotebookIsDirty = false;
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Id")) {
                    this.sharedNotebook.setId((long)this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("Userid")) {
                    this.sharedNotebook.setUserId(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("Email")) {
                    this.sharedNotebook.setEmail(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("NotebookGuid")) {
                    this.sharedNotebook.setNotebookGuid(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("ShareKey")) {
                    this.sharedNotebook.setShareKey(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Username")) {
                    this.sharedNotebook.setUsername(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("ServiceCreated")) {
                    this.sharedNotebook.setServiceCreated(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("Dirty") && this.booleanValue()) {
                    this.sharedNotebookIsDirty = true;
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("LinkedNotebook") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private void processNotebookNode() {
        this.notebook = new Notebook();
        Publishing p = new Publishing();
        this.notebook.setPublishing(p);
        this.notebookIsDirty = false;
        this.notebookIsLocal = false;
        this.notebookIsReadOnly = false;
        this.notebookIcon = null;
        boolean atEnd = false;
        while (!atEnd) {
            if (this.backup && this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Guid")) {
                    this.notebook.setGuid(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Name")) {
                    this.notebook.setName(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("UpdateSequenceNumber")) {
                    this.notebook.setUpdateSequenceNum(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("ServiceCreated")) {
                    this.notebook.setServiceCreated(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("ServiceUpdated")) {
                    this.notebook.setServiceUpdated(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("DefaultNotebook")) {
                    this.notebook.setDefaultNotebook(this.booleanValue());
                }
                if (this.reader.name().equalsIgnoreCase("Dirty") && this.booleanValue()) {
                    this.notebookIsDirty = true;
                }
                if (this.reader.name().equalsIgnoreCase("LocalNotebook") && this.booleanValue()) {
                    this.notebookIsLocal = true;
                }
                if (this.reader.name().equalsIgnoreCase("ReadOnly") && this.booleanValue()) {
                    this.notebookIsReadOnly = true;
                }
                if (this.reader.name().equalsIgnoreCase("PublishingPublicDescription")) {
                    this.notebook.getPublishing().setPublicDescription(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("PublishingUri")) {
                    this.notebook.getPublishing().setUri(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("PublishingOrder")) {
                    this.notebook.getPublishing().setOrder(NoteSortOrder.findByValue((int)this.intValue()));
                }
                if (this.reader.name().equalsIgnoreCase("ReadOnly") && this.booleanValue()) {
                    this.notebookIsReadOnly = true;
                }
                if (this.reader.name().equalsIgnoreCase("PublishingAscending")) {
                    if (this.booleanValue()) {
                        this.notebook.getPublishing().setAscending(true);
                    } else {
                        this.notebook.getPublishing().setAscending(false);
                    }
                }
                if (this.reader.name().equalsIgnoreCase("Icon")) {
                    byte[] b = this.textValue().getBytes();
                    QByteArray hexData = new QByteArray(b);
                    QByteArray binData = new QByteArray(QByteArray.fromHex((QByteArray)hexData));
                    this.notebookIcon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)binData)));
                }
                if (this.reader.name().equalsIgnoreCase("Stack")) {
                    this.notebook.setStack(this.textValue());
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("notebook") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private void processTagNode() {
        this.tag = new Tag();
        this.tagIsDirty = false;
        boolean atEnd = false;
        while (!atEnd) {
            if (this.backup && this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("Guid")) {
                    this.tag.setGuid(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Name")) {
                    this.tag.setName(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("UpdateSequenceNumber")) {
                    this.tag.setUpdateSequenceNum(this.intValue());
                }
                if (this.reader.name().equalsIgnoreCase("ParentGuid")) {
                    this.tag.setParentGuid(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Dirty") && this.booleanValue()) {
                    this.tagIsDirty = true;
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("tag") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private String textValue() {
        return this.reader.readElementText();
    }

    private int intValue() {
        return new Integer(this.textValue());
    }

    private long longValue() {
        return new Long(this.textValue());
    }

    private double doubleValue() {
        return new Double(this.textValue());
    }

    private boolean booleanValue() {
        String value = this.textValue();
        return value.equalsIgnoreCase("true");
    }

    private short shortValue() {
        return new Short(this.textValue());
    }

    public void setNotebookGuid(String g) {
        this.notebookGuid = g;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

