/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QDoubleValidator;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QValidator;
import com.trolltech.qt.gui.QWidget;

public class GeoDialog
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit altitude;
    private final QLineEdit latitude;
    private final QLineEdit longitude;
    private final QPushButton ok;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public GeoDialog() {
        this.setWindowTitle(this.tr("Geo Location"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "globe.png"));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        QGridLayout passwordGrid = new QGridLayout();
        QGridLayout buttonGrid = new QGridLayout();
        this.longitude = new QLineEdit();
        QDoubleValidator longVal = new QDoubleValidator(-180.0, 180.0, 4, (QObject)this.longitude);
        longVal.setNotation(QDoubleValidator.Notation.StandardNotation);
        this.longitude.setValidator((QValidator)longVal);
        this.latitude = new QLineEdit();
        QDoubleValidator latVal = new QDoubleValidator(-90.0, 90.0, 4, (QObject)this.latitude);
        latVal.setNotation(QDoubleValidator.Notation.StandardNotation);
        this.latitude.setValidator((QValidator)latVal);
        this.altitude = new QLineEdit();
        QDoubleValidator altVal = new QDoubleValidator(-9999.0, 9999.0, 4, (QObject)this.altitude);
        altVal.setNotation(QDoubleValidator.Notation.StandardNotation);
        this.altitude.setValidator((QValidator)altVal);
        passwordGrid.addWidget((QWidget)new QLabel(this.tr("Longitude")), 1, 1);
        passwordGrid.addWidget((QWidget)this.longitude, 1, 2);
        passwordGrid.addWidget((QWidget)new QLabel(this.tr("Latitude")), 2, 1);
        passwordGrid.addWidget((QWidget)this.latitude, 2, 2);
        passwordGrid.addWidget((QWidget)new QLabel(this.tr("Altitude")), 3, 1);
        passwordGrid.addWidget((QWidget)this.altitude, 3, 2);
        passwordGrid.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)passwordGrid, 1, 1);
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        buttonGrid.addWidget((QWidget)this.ok, 1, 1);
        buttonGrid.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)buttonGrid, 2, 1);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public double getLongitude() {
        try {
            return new Double(this.longitude.text());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public double getLatitude() {
        try {
            return new Double(this.latitude.text());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public double getAltitude() {
        try {
            return new Double(this.altitude.text());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public void setLongitude(double value) {
        this.longitude.setText(new Float(value).toString());
    }

    public void setLatitude(double value) {
        this.latitude.setText(new Float(value).toString());
    }

    public void setAltitude(double value) {
        this.altitude.setText(new Float(value).toString());
    }

    public boolean okPressed() {
        return this.okPressed;
    }
}

