/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Resource;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QTemporaryFile;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNodeList;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.signals.IndexSignal;
import cx.fbn.nevernote.signals.NoteResourceSignal;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IndexRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    private String guid;
    private QByteArray resourceBinary;
    public volatile NoteSignal noteSignal;
    public volatile NoteResourceSignal resourceSignal;
    private int indexType;
    public final int SCAN = 1;
    public final int REINDEXALL = 2;
    public final int REINDEXNOTE = 3;
    public boolean keepRunning;
    private final QDomDocument doc;
    private static String regex = Global.getWordRegex();
    public String specialIndexCharacters = "";
    public boolean indexNoteBody = true;
    public boolean indexNoteTitle = true;
    public boolean indexImageRecognition = true;
    private final DatabaseConnection conn;
    private volatile LinkedBlockingQueue<String> workQueue;
    private static int MAX_QUEUED_WAITING = 1000;
    public boolean interrupt;
    public boolean idle;
    public boolean indexAttachmentsLocally = true;
    public volatile IndexSignal signal;
    private final TreeSet<String> foundWords = new TreeSet();
    int uncommittedCount = 0;

    public IndexRunner(String logname, String u, String i, String r, String b, String uid, String pswd, String cpswd) {
        this.logger = new ApplicationLogger(logname);
        this.conn = new DatabaseConnection(this.logger, u, i, r, b, uid, pswd, cpswd, 500);
        this.indexType = 1;
        this.guid = null;
        this.keepRunning = true;
        this.doc = new QDomDocument();
        this.workQueue = new LinkedBlockingQueue(MAX_QUEUED_WAITING);
    }

    public void setIndexType(int t) {
        this.indexType = t;
    }

    @Override
    public void run() {
        this.thread().setPriority(1);
        this.noteSignal = new NoteSignal();
        this.resourceSignal = new NoteResourceSignal();
        this.signal = new IndexSignal();
        this.logger.log(this.logger.EXTREME, "Starting index thread ");
        while (this.keepRunning) {
            this.idle = true;
            try {
                this.conn.commitTransaction();
                this.uncommittedCount = 0;
                String work = this.workQueue.take();
                this.idle = false;
                if (work.startsWith("SCAN")) {
                    this.guid = null;
                    this.interrupt = false;
                    this.indexType = 1;
                }
                if (work.startsWith("REINDEXALL")) {
                    this.guid = null;
                    this.indexType = 2;
                }
                if (work.startsWith("REINDEXNOTE")) {
                    this.guid = work = work.replace("REINDEXNOTE ", "");
                    this.indexType = 3;
                }
                if (work.startsWith("STOP")) {
                    this.keepRunning = false;
                    this.guid = null;
                }
                this.logger.log(this.logger.EXTREME, "Type:" + this.indexType);
                if (this.indexType == 1 && this.keepRunning) {
                    this.logger.log(this.logger.MEDIUM, "Scanning for unindexed notes & resources");
                    this.scanUnindexed();
                    this.setIndexType(0);
                }
                if (this.indexType == 2 && this.keepRunning) {
                    this.logger.log(this.logger.MEDIUM, "Marking all for reindex");
                    this.reindexAll();
                    this.setIndexType(0);
                }
                if (this.indexType != 3 || !this.keepRunning) continue;
                this.reindexNote();
            }
            catch (InterruptedException e) {
                this.logger.log(this.logger.LOW, "Thread interrupted exception: " + e.getMessage());
            }
        }
        this.logger.log(this.logger.EXTREME, "Shutting down database");
        this.conn.dbShutdown();
        this.logger.log(this.logger.EXTREME, "Database shut down.  Exiting thread");
    }

    public void indexNoteContent() {
        String data;
        this.foundWords.clear();
        this.logger.log(this.logger.EXTREME, "Entering indexRunner.indexNoteContent()");
        this.logger.log(this.logger.EXTREME, "Getting note content");
        Note n = this.conn.getNoteTable().getNote(this.guid, true, false, true, true, true);
        if (this.indexNoteBody) {
            data = n.getContent();
            data = this.conn.getNoteTable().getNoteContentNoUTFConversion(n.getGuid());
            this.logger.log(this.logger.EXTREME, "Removing any encrypted data");
            data = this.removeEnCrypt(data.toString());
            this.logger.log(this.logger.EXTREME, "Removing xml markups");
        } else {
            data = "";
        }
        String text = this.indexNoteTitle ? this.removeTags(String.valueOf(StringEscapeUtils.unescapeHtml4((String)data)) + " " + n.getTitle()) : this.removeTags(StringEscapeUtils.unescapeHtml4((String)data));
        this.logger.log(this.logger.EXTREME, "Splitting words");
        String[] result = text.toString().split(regex);
        this.conn.commitTransaction();
        this.conn.beginTransaction();
        this.logger.log(this.logger.EXTREME, "Deleting existing words for note from index");
        this.conn.getWordsTable().expungeFromWordIndex(this.guid, "CONTENT");
        this.logger.log(this.logger.EXTREME, "Number of words found: " + result.length);
        int j = 0;
        while (j < result.length && this.keepRunning) {
            if (this.interrupt) {
                this.processInterrupt();
            }
            if (!result[j].trim().equals("")) {
                this.logger.log(this.logger.EXTREME, "Result word: " + result[j].trim());
                this.addToIndex(this.guid, result[j], "CONTENT");
            }
            ++j;
        }
        j = 0;
        while (j < n.getTagNamesSize()) {
            if (n.getTagNames() != null && n.getTagNames().get(j) != null && !((String)n.getTagNames().get(j)).trim().equals("")) {
                this.addToIndex(this.guid, (String)n.getTagNames().get(j), "CONTENT");
            }
            ++j;
        }
        if (Global.keepRunning) {
            this.logger.log(this.logger.EXTREME, "Resetting note guid needed");
            this.conn.getNoteTable().setIndexNeeded(this.guid, false);
        }
        this.conn.commitTransaction();
        this.uncommittedCount = 0;
        this.logger.log(this.logger.EXTREME, "Leaving indexRunner.indexNoteContent()");
    }

    private String removeTags(String text) {
        StringBuffer buffer = new StringBuffer(text);
        boolean inTag = false;
        int i = buffer.length() - 1;
        while (i >= 0) {
            if (buffer.charAt(i) == '>') {
                inTag = true;
            }
            if (buffer.charAt(i) == '<') {
                inTag = false;
            }
            if (inTag || buffer.charAt(i) == '<') {
                buffer.deleteCharAt(i);
            }
            --i;
        }
        return buffer.toString();
    }

    public synchronized boolean addWork(String request) {
        if (this.workQueue.size() == 0) {
            this.workQueue.offer(request);
            return true;
        }
        return false;
    }

    public synchronized int getWorkQueueSize() {
        return this.workQueue.size();
    }

    public void indexResource() {
        if (this.guid == null) {
            return;
        }
        this.foundWords.clear();
        Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResourceRecognition(this.guid);
        this.resourceBinary = !this.indexImageRecognition || r == null || r.getRecognition() == null || r.getRecognition().getBody() == null || r.getRecognition().getBody().length == 0 ? new QByteArray(" ") : new QByteArray(r.getRecognition().getBody());
        this.conn.commitTransaction();
        this.conn.beginTransaction();
        this.conn.getWordsTable().expungeFromWordIndex(r.getNoteGuid(), "RESOURCE");
        this.conn.getWordsTable().expungeFromWordIndex(this.guid, "RESOURCE");
        this.conn.commitTransaction();
        this.uncommittedCount = 0;
        this.conn.beginTransaction();
        this.doc.setContent(this.resourceBinary);
        QDomElement docElem = this.doc.documentElement();
        QDomNodeList anchors = docElem.elementsByTagName("t");
        int i = 0;
        while (i < anchors.length() && this.keepRunning) {
            if (this.interrupt && this.interrupt) {
                this.processInterrupt();
            }
            QDomElement enmedia = anchors.at(i).toElement();
            String weight = new String(enmedia.attribute("w"));
            String text = new String(enmedia.text()).toLowerCase();
            if (!text.equals("")) {
                this.conn.getWordsTable().addWordToNoteIndex(r.getNoteGuid(), text, "RESOURCE", new Integer(weight));
                ++this.uncommittedCount;
                if (this.uncommittedCount > 100) {
                    this.conn.commitTransaction();
                    this.uncommittedCount = 0;
                }
            }
            ++i;
        }
        if (Global.keepRunning && this.indexAttachmentsLocally) {
            this.conn.commitTransaction();
            this.uncommittedCount = 0;
            this.conn.beginTransaction();
            this.indexResourceContent(this.guid);
        }
        if (Global.keepRunning) {
            this.conn.getNoteTable().noteResourceTable.setIndexNeeded(this.guid, false);
        }
        this.conn.commitTransaction();
        this.uncommittedCount = 0;
    }

    private void indexResourceContent(String guid) {
        Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResource(guid, true);
        if (r != null && r.getMime() != null) {
            if (r.getMime().equalsIgnoreCase("application/pdf")) {
                this.indexResourcePDF(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/docx") || r.getMime().equalsIgnoreCase("application/xlsx") || r.getMime().equalsIgnoreCase("application/pptx")) {
                this.indexResourceOOXML(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/vsd") || r.getMime().equalsIgnoreCase("application/ppt") || r.getMime().equalsIgnoreCase("application/xls") || r.getMime().equalsIgnoreCase("application/msg") || r.getMime().equalsIgnoreCase("application/doc")) {
                this.indexResourceOffice(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/rtf")) {
                this.indexResourceRTF(r);
                return;
            }
            if (r.getMime().equalsIgnoreCase("application/odf") || r.getMime().equalsIgnoreCase("application/odt") || r.getMime().equalsIgnoreCase("application/odp") || r.getMime().equalsIgnoreCase("application/odg") || r.getMime().equalsIgnoreCase("application/odb") || r.getMime().equalsIgnoreCase("application/ods")) {
                this.indexResourceODF(r);
                return;
            }
        }
    }

    private void indexResourceRTF(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            RTFParser parser = new RTFParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            String[] result = textHandler.toString().split(regex);
            int i2 = 0;
            while (i2 < result.length && this.keepRunning) {
                this.addToIndex(r.getNoteGuid(), result[i2], "RESOURCE");
                ++i2;
            }
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourceODF(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            OpenDocumentParser parser = new OpenDocumentParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            String[] result = textHandler.toString().split(regex);
            int i2 = 0;
            while (i2 < result.length && this.keepRunning) {
                if (this.interrupt) {
                    this.processInterrupt();
                }
                this.addToIndex(r.getNoteGuid(), result[i2], "RESOURCE");
                ++i2;
            }
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourceOffice(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            OfficeParser parser = new OfficeParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            String[] result = textHandler.toString().split(regex);
            int i2 = 0;
            while (i2 < result.length && this.keepRunning) {
                if (this.interrupt) {
                    this.processInterrupt();
                }
                this.addToIndex(r.getNoteGuid(), result[i2], "RESOURCE");
                ++i2;
            }
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourcePDF(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            PDFParser parser = new PDFParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            String[] result = textHandler.toString().split(regex);
            int i2 = 0;
            while (i2 < result.length && this.keepRunning) {
                if (this.interrupt) {
                    this.processInterrupt();
                }
                this.addToIndex(r.getNoteGuid(), result[i2], "RESOURCE");
                ++i2;
            }
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private void indexResourceOOXML(Resource r) {
        Data d = r.getData();
        int i = 0;
        while (i < 20 && d.getSize() == 0) {
            d = r.getData();
            ++i;
        }
        if (d.getSize() == 0) {
            return;
        }
        QTemporaryFile f = this.writeResource(d);
        if (!this.keepRunning) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(new File(f.fileName()));
            BodyContentHandler textHandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            OOXMLParser parser = new OOXMLParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)textHandler, metadata, context);
            String[] result = textHandler.toString().split(regex);
            int i2 = 0;
            while (i2 < result.length && this.keepRunning) {
                if (this.interrupt) {
                    this.processInterrupt();
                }
                this.addToIndex(r.getNoteGuid(), result[i2], "RESOURCE");
                ++i2;
            }
            ((InputStream)input).close();
            f.close();
        }
        catch (ClassCastException e) {
            this.logger.log(this.logger.LOW, "Cast exception: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.log(this.logger.LOW, "FileNotFound  exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.log(this.logger.LOW, "IO  exception: " + e.getMessage());
        }
        catch (SAXException e) {
            this.logger.log(this.logger.LOW, "SAX  exception: " + e.getMessage());
        }
        catch (TikaException e) {
            this.logger.log(this.logger.LOW, "Tika  exception: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(this.logger.LOW, "Unknown  exception: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            this.logger.log(this.logger.LOW, "NoSuchMethod error: " + e.getMessage());
        }
        catch (Error e) {
            this.logger.log(this.logger.LOW, "Unknown error: " + e.getMessage());
        }
    }

    private QTemporaryFile writeResource(Data d) {
        QTemporaryFile newFile = new QTemporaryFile();
        newFile.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
        newFile.write(d.getBody());
        newFile.close();
        return newFile;
    }

    private String removeEnCrypt(String content) {
        int index = content.indexOf("<en-crypt");
        boolean tagFound = true;
        while (tagFound && this.keepRunning) {
            int endPos;
            if (this.interrupt) {
                this.processInterrupt();
            }
            if ((endPos = content.indexOf("</en-crypt>", index) + 11) > -1 && index > -1) {
                content = String.valueOf(content.substring(0, index)) + content.substring(endPos);
                index = content.indexOf("<en-crypt");
                continue;
            }
            tagFound = false;
        }
        return content;
    }

    private void addToIndex(String guid, String word, String type) {
        if (this.foundWords.contains(word)) {
            return;
        }
        StringBuffer buffer = new StringBuffer(word.toLowerCase());
        int i = buffer.length() - 1;
        while (i >= 0) {
            if (Character.isLetterOrDigit(buffer.charAt(i)) || this.specialIndexCharacters.indexOf(buffer.charAt(i)) != -1) break;
            buffer.deleteCharAt(i);
            --i;
        }
        buffer = buffer.reverse();
        i = buffer.length() - 1;
        while (i >= 0) {
            if (Character.isLetterOrDigit(buffer.charAt(i))) break;
            buffer.deleteCharAt(i);
            --i;
        }
        if ((buffer = buffer.reverse()).length() > 0 && !this.foundWords.contains(buffer.toString())) {
            this.foundWords.add(buffer.toString());
            this.foundWords.add(word);
            this.conn.getWordsTable().addWordToNoteIndex(guid, buffer.toString(), type, 100);
            ++this.uncommittedCount;
            if (this.uncommittedCount > 100) {
                this.conn.commitTransaction();
                this.uncommittedCount = 0;
            }
        }
    }

    private void scanUnindexed() {
        List<String> notes = this.conn.getNoteTable().getUnindexed();
        this.guid = null;
        boolean started = false;
        if (notes.size() > 0) {
            this.signal.indexStarted.emit();
            started = true;
        }
        int i = 0;
        while (i < notes.size() && this.keepRunning) {
            if (this.interrupt) {
                this.processInterrupt();
            }
            this.guid = notes.get(i);
            if (this.guid != null && this.keepRunning) {
                this.indexNoteContent();
            }
            ++i;
        }
        List<String> unindexedResources = this.conn.getNoteTable().noteResourceTable.getUnindexed();
        if (unindexedResources.size() > 0 && !started) {
            this.signal.indexStarted.emit();
            started = true;
        }
        int i2 = 0;
        while (i2 < unindexedResources.size() && this.keepRunning) {
            if (this.interrupt) {
                this.processInterrupt();
            }
            this.guid = unindexedResources.get(i2);
            if (this.keepRunning) {
                this.indexResource();
            }
            ++i2;
        }
        List<String> guids = this.conn.getWordsTable().getGuidList();
        this.logger.log(this.logger.LOW, "GUIDS in index: " + guids.size());
        int i3 = 0;
        while (i3 < guids.size() && this.keepRunning) {
            if (!this.conn.getNoteTable().exists(guids.get(i3))) {
                this.logger.log(this.logger.LOW, "Old GUID found: " + guids.get(i3));
                this.conn.getWordsTable().expunge(guids.get(i3));
            }
            ++i3;
        }
        if (started && this.keepRunning) {
            this.signal.indexFinished.emit();
        }
    }

    private void reindexNote() {
        if (this.guid == null) {
            return;
        }
        this.conn.getNoteTable().setIndexNeeded(this.guid, true);
    }

    private void reindexAll() {
        this.conn.getNoteTable().reindexAllNotes();
        this.conn.getNoteTable().noteResourceTable.reindexAll();
    }

    private void waitSeconds(int len) {
        long starttime = 0L;
        starttime = System.currentTimeMillis();
        starttime = (long)((double)starttime + 1000.0);
        LockSupport.parkNanos(Math.max(0L, starttime - System.currentTimeMillis()) * 1000000L);
    }

    private void processInterrupt() {
        this.conn.commitTransaction();
        this.waitSeconds(1);
        this.uncommittedCount = 0;
        this.conn.beginTransaction();
        this.interrupt = false;
    }
}

