/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteAttributes;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.Tag;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QTextCodec;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.evernote.EnmlConverter;
import cx.fbn.nevernote.evernote.NoteMetadata;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedTable;
import cx.fbn.nevernote.sql.NoteResourceTable;
import cx.fbn.nevernote.sql.NoteTagsTable;
import cx.fbn.nevernote.sql.NotebookTable;
import cx.fbn.nevernote.sql.TagTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class NoteTable {
    private final ApplicationLogger logger;
    public final NoteTagsTable noteTagsTable;
    public NoteResourceTable noteResourceTable;
    private final DatabaseConnection db;
    int id;
    private NSqlQuery getQueryWithContent;
    private NSqlQuery getQueryWithoutContent;
    private NSqlQuery getAllQueryWithoutContent;

    public NoteTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
        this.id = 0;
        this.noteResourceTable = new NoteResourceTable(this.logger, this.db);
        this.noteTagsTable = new NoteTagsTable(this.logger, this.db);
        this.getQueryWithContent = null;
        this.getQueryWithoutContent = null;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table Note...");
        if (!query.exec("Create table Note (guid varchar primary key, updateSequenceNumber integer, title varchar, content varchar, contentHash varchar, contentLength integer, created timestamp, updated timestamp, deleted timestamp, active integer, notebookGuid varchar, attributeSubjectDate timestamp, attributeLatitude double, attributeLongitude double, attributeAltitude double,attributeAuthor varchar, attributeSource varchar, attributeSourceUrl varchar, attributeSourceApplication varchar, indexNeeded boolean, isExpunged boolean, isDirty boolean)")) {
            this.logger.log(this.logger.HIGH, "Table Note creation FAILED!!!");
        }
        if (!query.exec("CREATE INDEX unindexed_notess on note (indexneeded desc, guid);")) {
            this.logger.log(this.logger.HIGH, "Note unindexed_notes index creation FAILED!!!");
        }
        if (!query.exec("CREATE INDEX unsynchronized_notes on note (isDirty desc, guid);")) {
            this.logger.log(this.logger.HIGH, "note unsynchronized_notes index creation FAILED!!!");
        }
        this.noteTagsTable.createTable();
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table Note");
        this.noteTagsTable.dropTable();
        this.noteResourceTable.dropTable();
    }

    public void addNote(Note n, boolean isDirty) {
        this.logger.log(this.logger.EXTREME, "Inside addNote");
        if (n == null) {
            return;
        }
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Insert Into Note (guid, updateSequenceNumber, title, content, contentHash, contentLength, created, updated, deleted, active, notebookGuid, attributeSubjectDate, attributeLatitude, attributeLongitude, attributeAltitude, attributeAuthor, attributeSource, attributeSourceUrl, attributeSourceApplication, indexNeeded, isExpunged, isDirty, titlecolor, thumbnailneeded) Values(:guid, :updateSequenceNumber, :title, :content, :contentHash, :contentLength, :created, :updated, :deleted, :active, :notebookGuid, :attributeSubjectDate, :attributeLatitude, :attributeLongitude, :attributeAltitude, :attributeAuthor, :attributeSource, :attributeSourceUrl, :attributeSourceApplication, :indexNeeded, :isExpunged, :isDirty, -1, true) ");
        StringBuilder created = new StringBuilder(simple.format(n.getCreated()));
        StringBuilder updated = new StringBuilder(simple.format(n.getUpdated()));
        StringBuilder deleted = new StringBuilder(simple.format(n.getDeleted()));
        query.bindValue(":guid", n.getGuid());
        query.bindValue(":updateSequenceNumber", n.getUpdateSequenceNum());
        query.bindValue(":title", n.getTitle());
        if (isDirty) {
            EnmlConverter enml = new EnmlConverter(this.logger);
            query.bindValue(":content", enml.fixEnXMLCrap(enml.fixEnMediaCrap(n.getContent())));
        } else {
            query.bindValue(":content", n.getContent());
        }
        query.bindValue(":contentHash", n.getContentHash());
        query.bindValue(":contentLength", n.getContentLength());
        query.bindValue(":created", created.toString());
        query.bindValue(":updated", updated.toString());
        query.bindValue(":deleted", deleted.toString());
        query.bindValue(":active", n.isActive());
        query.bindValue(":notebookGuid", n.getNotebookGuid());
        if (n.getAttributes() != null) {
            created = new StringBuilder(simple.format(n.getAttributes().getSubjectDate()));
            query.bindValue(":attributeSubjectDate", created.toString());
            query.bindValue(":attributeLatitude", n.getAttributes().getLatitude());
            query.bindValue(":attributeLongitude", n.getAttributes().getLongitude());
            query.bindValue(":attributeAltitude", n.getAttributes().getAltitude());
            query.bindValue(":attributeAuthor", n.getAttributes().getAuthor());
            query.bindValue(":attributeSource", n.getAttributes().getSource());
            query.bindValue(":attributeSourceUrl", n.getAttributes().getSourceURL());
            query.bindValue(":attributeSourceApplication", n.getAttributes().getSourceApplication());
        } else {
            created = new StringBuilder(simple.format(n.getCreated()));
            query.bindValue(":attributeSubjectDate", created.toString());
            query.bindValue(":attributeLatitude", 0.0);
            query.bindValue(":attributeLongitude", 0.0);
            query.bindValue(":attributeAltitude", 0.0);
            query.bindValue(":attributeAuthor", "");
            query.bindValue(":attributeSource", "");
            query.bindValue(":attributeSourceUrl", "");
            query.bindValue(":attributeSourceApplication", "");
        }
        query.bindValue(":indexNeeded", true);
        query.bindValue(":isExpunged", false);
        query.bindValue(":isDirty", isDirty);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        if (n.getTagGuids() != null) {
            int i = 0;
            while (i < n.getTagGuids().size()) {
                this.noteTagsTable.saveNoteTag(n.getGuid(), (String)n.getTagGuids().get(i), isDirty);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving addNote");
    }

    private void prepareQueries() {
        if (this.getQueryWithContent == null) {
            this.getQueryWithContent = new NSqlQuery(this.db.getConnection());
            if (!this.getQueryWithContent.prepare("Select guid, updateSequenceNumber, title, created, updated, deleted, active, notebookGuid, attributeSubjectDate, attributeLatitude, attributeLongitude, attributeAltitude, attributeAuthor, attributeSource, attributeSourceUrl, attributeSourceApplication, attributeContentClass, content, contentHash, contentLength from Note where guid=:guid and isExpunged=false")) {
                this.logger.log(this.logger.EXTREME, "Note SQL select prepare with content has failed.");
                this.logger.log(this.logger.MEDIUM, this.getQueryWithContent.lastError());
            }
        }
        if (this.getQueryWithoutContent == null) {
            this.getQueryWithoutContent = new NSqlQuery(this.db.getConnection());
            if (!this.getQueryWithoutContent.prepare("Select guid, updateSequenceNumber, title, created, updated, deleted, active, notebookGuid, attributeSubjectDate, attributeLatitude, attributeLongitude, attributeAltitude, attributeAuthor, attributeSource, attributeSourceUrl, attributeSourceApplication, attributeContentClass from Note where guid=:guid and isExpunged=false")) {
                this.logger.log(this.logger.EXTREME, "Note SQL select prepare without content has failed.");
                this.logger.log(this.logger.MEDIUM, this.getQueryWithoutContent.lastError());
            }
        }
        if (this.getAllQueryWithoutContent == null) {
            this.getAllQueryWithoutContent = new NSqlQuery(this.db.getConnection());
            if (!this.getAllQueryWithoutContent.prepare("Select guid, updateSequenceNumber, title, created, updated, deleted, active, notebookGuid, attributeSubjectDate, attributeLatitude, attributeLongitude, attributeAltitude, attributeAuthor, attributeSource, attributeSourceUrl, attributeSourceApplication, attributeContentClass  from Note where isExpunged = false")) {
                this.logger.log(this.logger.EXTREME, "Note SQL select prepare without content has failed.");
                this.logger.log(this.logger.MEDIUM, this.getQueryWithoutContent.lastError());
            }
        }
    }

    public String getNoteContentNoUTFConversion(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select content from note where guid=:guid");
        query.bindValue(":guid", guid);
        query.exec();
        query.next();
        return query.valueString(0);
    }

    public Note getNote(String noteGuid, boolean loadContent, boolean loadResources, boolean loadRecognition, boolean loadBinary, boolean loadTags) {
        if (noteGuid == null) {
            return null;
        }
        if (noteGuid.trim().equals("")) {
            return null;
        }
        this.prepareQueries();
        NSqlQuery query = loadContent ? this.getQueryWithContent : this.getQueryWithoutContent;
        query.bindValue(":guid", noteGuid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Note SQL select exec has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        if (!query.next()) {
            this.logger.log(this.logger.EXTREME, "SQL Retrieve failed for note guid " + noteGuid + " in getNote()");
            this.logger.log(this.logger.EXTREME, " -> " + query.lastError().toString());
            this.logger.log(this.logger.EXTREME, " -> " + query.lastError());
            return null;
        }
        Note n = this.mapNoteFromQuery(query, loadContent, loadResources, loadRecognition, loadBinary, loadTags);
        n.setContent(this.fixCarriageReturn(n.getContent()));
        n.getAttributes().setContentClassIsSet(false);
        return n;
    }

    public Note mapNoteFromQuery(NSqlQuery query, boolean loadContent, boolean loadResources, boolean loadRecognition, boolean loadBinary, boolean loadTags) {
        SimpleDateFormat indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        Note n = new Note();
        NoteAttributes na = new NoteAttributes();
        n.setAttributes(na);
        n.setGuid(query.valueString(0));
        n.setUpdateSequenceNum(new Integer(query.valueString(1)).intValue());
        n.setTitle(query.valueString(2));
        try {
            n.setCreated(indfm.parse(query.valueString(3)).getTime());
            n.setUpdated(indfm.parse(query.valueString(4)).getTime());
            n.setDeleted(indfm.parse(query.valueString(5)).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        n.setActive(query.valueBoolean(6, true));
        n.setNotebookGuid(query.valueString(7));
        try {
            String attributeSubjectDate = query.valueString(8);
            if (!attributeSubjectDate.equals("")) {
                na.setSubjectDate(indfm.parse(attributeSubjectDate).getTime());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        na.setLatitude((double)new Float(query.valueString(9)).floatValue());
        na.setLongitude((double)new Float(query.valueString(10)).floatValue());
        na.setAltitude((double)new Float(query.valueString(11)).floatValue());
        na.setAuthor(query.valueString(12));
        na.setSource(query.valueString(13));
        na.setSourceURL(query.valueString(14));
        na.setSourceApplication(query.valueString(15));
        na.setContentClass(query.valueString(16));
        if (loadTags) {
            List<String> tagGuids = this.noteTagsTable.getNoteTags(n.getGuid());
            ArrayList<String> tagNames = new ArrayList<String>();
            TagTable tagTable = this.db.getTagTable();
            int i = 0;
            while (i < tagGuids.size()) {
                String currentGuid = tagGuids.get(i);
                Tag tag = tagTable.getTag(currentGuid);
                if (tag.getName() != null) {
                    tagNames.add(tag.getName());
                } else {
                    tagNames.add("");
                }
                ++i;
            }
            n.setTagNames(tagNames);
            n.setTagGuids(tagGuids);
        }
        if (loadContent) {
            QTextCodec codec = QTextCodec.codecForLocale();
            codec = QTextCodec.codecForName((String)"UTF-8");
            String unicode = codec.fromUnicode(query.valueString(17)).toString();
            StringBuffer buffer = new StringBuffer(unicode);
            if (Global.enableHTMLEntitiesFix && unicode.indexOf("&#") > 0) {
                unicode = query.valueString(17);
                int j = 1;
                int i = buffer.indexOf("&#");
                while (i != -1 && buffer.indexOf("&#", i) > 0) {
                    j = buffer.indexOf(";", i) + 1;
                    if (i < j) {
                        String entity = buffer.substring(i, j).toString();
                        int len = entity.length() - 1;
                        String tempEntity = entity.substring(2, len);
                        try {
                            Integer.parseInt(tempEntity);
                            entity = codec.fromUnicode(StringEscapeUtils.unescapeHtml4((String)entity)).toString();
                            buffer.delete(i, j);
                            buffer.insert(i, entity);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    i = buffer.indexOf("&#", i + 1);
                }
            }
            n.setContent(unicode);
            String contentHash = query.valueString(18);
            if (contentHash != null) {
                n.setContentHash(contentHash.getBytes());
            }
            n.setContentLength(new Integer(query.valueString(19)).intValue());
        }
        if (loadResources) {
            n.setResources(this.noteResourceTable.getNoteResources(n.getGuid(), loadBinary));
        }
        if (loadRecognition) {
            if (n.getResources() == null) {
                List<Resource> resources = this.noteResourceTable.getNoteResourcesRecognition(n.getGuid());
                n.setResources(resources);
            } else {
                int i = 0;
                while (i < n.getResources().size()) {
                    Resource r = this.noteResourceTable.getNoteResourceRecognition(((Resource)n.getResources().get(i)).getGuid());
                    ((Resource)n.getResources().get(i)).setRecognition(r.getRecognition());
                    ++i;
                }
            }
        }
        n.setContent(this.fixCarriageReturn(n.getContent()));
        return n;
    }

    public void updateNoteTitle(String guid, String title) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteTitle");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set title=:title, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note title sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":title", title);
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note title has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteTitle");
    }

    public void updateNoteCreatedDate(String guid, QDateTime date) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteCreatedDate");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set created=:created, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note creation update sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":created", date.toString("yyyy-MM-dd HH:mm:ss"));
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note creation date has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteCreatedDate");
    }

    public void updateNoteAlteredDate(String guid, QDateTime date) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteAlteredDate");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set updated=:altered, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note altered sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":altered", date.toString("yyyy-MM-dd HH:mm:ss"));
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note altered date has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteAlteredDate");
    }

    public void updateNoteSubjectDate(String guid, QDateTime date) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteSubjectDate");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set attributeSubjectDate=:altered, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note subject date sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":altered", date.toString("yyyy-MM-dd HH:mm:ss"));
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note subject date date has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteSubjectDate");
    }

    public void updateNoteAuthor(String guid, String author) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteSubject");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set attributeAuthor=:author, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note author sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":author", author);
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note author has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteSubject");
    }

    public void updateNoteGeoTags(String guid, Double lon, Double lat, Double alt) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteGeoTags");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set attributeLongitude=:longitude, attributeLatitude=:latitude, attributeAltitude=:altitude, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note author sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":longitude", lon);
        query.bindValue(":latitude", lat);
        query.bindValue(":altitude", alt);
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note geo tag has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteGeoTags");
    }

    public void updateNoteSourceUrl(String guid, String url) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteSourceUrl");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set attributeSourceUrl=:url, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note url sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":url", url);
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note url has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteSourceUrl");
    }

    public void updateNoteNotebook(String guid, String notebookGuid, boolean expungeFromRemote) {
        NSqlQuery query;
        boolean check;
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteNotebook");
        String currentNotebookGuid = new String("");
        NotebookTable notebookTable = new NotebookTable(this.logger, this.db);
        DeletedTable deletedTable = new DeletedTable(this.logger, this.db);
        if (expungeFromRemote && !notebookTable.isNotebookLocal(currentNotebookGuid) & notebookTable.isNotebookLocal(notebookGuid)) {
            deletedTable.addDeletedItem(guid, "NOTE");
        }
        if (!(check = (query = new NSqlQuery(this.db.getConnection())).prepare("Update Note set notebookGuid=:notebook, isDirty=true where guid=:guid"))) {
            this.logger.log(this.logger.EXTREME, "Update note notebook sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":notebook", notebookGuid);
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note notebook has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteNotebook");
    }

    public void updateNoteContent(String guid, String content) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteContent");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set content=:content, updated=CURRENT_TIMESTAMP(), isDirty=true, indexNeeded=true,  thumbnailneeded=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note content sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":content", content);
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note content has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteContent");
    }

    public void deleteNote(String guid) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.deleteNote");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update Note set deleted=CURRENT_TIMESTAMP(), active=false, isDirty=true where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Note delete failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.deleteNote");
    }

    public void restoreNote(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update Note set deleted=:reset, active=true, isDirty=true where guid=:guid");
        query.bindValue(":guid", guid);
        query.bindValue(":reset", "1969-12-31 19:00:00");
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Note restore failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void expungeNote(String guid, boolean permanentExpunge, boolean needsSync) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.expungeNote");
        if (!permanentExpunge) {
            this.hideExpungedNote(guid, needsSync);
            return;
        }
        NSqlQuery note = new NSqlQuery(this.db.getConnection());
        NSqlQuery resources = new NSqlQuery(this.db.getResourceConnection());
        NSqlQuery tags = new NSqlQuery(this.db.getConnection());
        NSqlQuery words = new NSqlQuery(this.db.getIndexConnection());
        note.prepare("Delete from Note where guid=:guid");
        resources.prepare("Delete from NoteResources where noteGuid=:guid");
        tags.prepare("Delete from NoteTags where noteGuid=:guid");
        words.prepare("Delete from words where guid=:guid");
        note.bindValue(":guid", guid);
        resources.bindValue(":guid", guid);
        tags.bindValue(":guid", guid);
        words.bindValue(":guid", guid);
        if (!note.exec()) {
            this.logger.log(this.logger.MEDIUM, "Purge from note failed.");
            this.logger.log(this.logger.MEDIUM, note.lastError());
        }
        if (!resources.exec()) {
            this.logger.log(this.logger.MEDIUM, "Purge from resources failed.");
            this.logger.log(this.logger.MEDIUM, resources.lastError());
        }
        if (!tags.exec()) {
            this.logger.log(this.logger.MEDIUM, "Note tags delete failed.");
            this.logger.log(this.logger.MEDIUM, tags.lastError());
        }
        if (!words.exec()) {
            this.logger.log(this.logger.MEDIUM, "Word delete failed.");
            this.logger.log(this.logger.MEDIUM, words.lastError());
        }
        if (needsSync) {
            DeletedTable deletedTable = new DeletedTable(this.logger, this.db);
            deletedTable.addDeletedItem(guid, "Note");
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.expungeNote");
    }

    public void expungeNotesByNotebook(String notebookGuid, boolean permanentExpunge, boolean needsSync) {
        List<String> notes = this.getNotesByNotebook(notebookGuid);
        int i = 0;
        while (i < notes.size()) {
            this.expungeNote(notes.get(i), permanentExpunge, needsSync);
            ++i;
        }
    }

    public void hideExpungedNote(String guid, boolean needsSync) {
        NSqlQuery note = new NSqlQuery(this.db.getConnection());
        NSqlQuery resources = new NSqlQuery(this.db.getResourceConnection());
        NSqlQuery tags = new NSqlQuery(this.db.getConnection());
        NSqlQuery words = new NSqlQuery(this.db.getIndexConnection());
        note.prepare("Update Note set isExpunged=true where guid=:guid");
        resources.prepare("Delete from NoteResources where noteGuid=:guid");
        tags.prepare("Delete from NoteTags where noteGuid=:guid");
        note.bindValue(":guid", guid);
        resources.bindValue(":guid", guid);
        tags.bindValue(":guid", guid);
        words.bindValue(":guid", guid);
        if (!note.exec()) {
            this.logger.log(this.logger.MEDIUM, "Purge from note failed.");
            this.logger.log(this.logger.MEDIUM, note.lastError());
        }
        if (!resources.exec()) {
            this.logger.log(this.logger.MEDIUM, "Purge from resources failed.");
            this.logger.log(this.logger.MEDIUM, resources.lastError());
        }
        if (!tags.exec()) {
            this.logger.log(this.logger.MEDIUM, "Note tags delete failed.");
            this.logger.log(this.logger.MEDIUM, tags.lastError());
        }
        if (needsSync) {
            DeletedTable deletedTable = new DeletedTable(this.logger, this.db);
            deletedTable.addDeletedItem(guid, "Note");
        }
    }

    public void expungeAllDeletedNotes() {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.expungeAllDeletedNotes");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("select guid, updateSequenceNumber from note where active = false");
        ArrayList<String> guids = new ArrayList<String>();
        ArrayList<Integer> usns = new ArrayList<Integer>();
        while (query.next()) {
            guids.add(query.valueString(0));
            Integer usn = new Integer(query.valueString(1));
            usns.add(usn);
        }
        int i = 0;
        while (i < guids.size()) {
            Integer usn = (Integer)usns.get(i);
            String guid = (String)guids.get(i);
            if (usn == 0) {
                this.expungeNote(guid, true, false);
            } else {
                this.expungeNote(guid, false, true);
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.expungeAllDeletedNotes");
    }

    public void updateNoteSequence(String guid, int sequence) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteSequence");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set updateSequenceNumber=:sequence where guid=:guid");
        query.bindValue(":sequence", sequence);
        query.bindValue(":guid", guid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Note sequence update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNoteSequence");
    }

    public void updateNoteGuid(String oldGuid, String newGuid) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNoteGuid");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        NSqlQuery resQuery = new NSqlQuery(this.db.getResourceConnection());
        NSqlQuery wordQuery = new NSqlQuery(this.db.getIndexConnection());
        query.prepare("Update Note set guid=:newGuid, original_guid=:original_guid where guid=:oldGuid");
        query.bindValue(":original_guid", oldGuid);
        query.bindValue(":newGuid", newGuid);
        query.bindValue(":oldGuid", oldGuid);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Note Guid update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.prepare("Update NoteTags set noteGuid=:newGuid where noteGuid=:oldGuid");
        query.bindValue(":newGuid", newGuid);
        query.bindValue(":oldGuid", oldGuid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Note guid update failed for NoteTags.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        wordQuery.prepare("Update words set guid=:newGuid where guid=:oldGuid");
        wordQuery.bindValue(":newGuid", newGuid);
        wordQuery.bindValue(":oldGuid", oldGuid);
        check = wordQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Note guid update failed for Words.");
            this.logger.log(this.logger.MEDIUM, wordQuery.lastError());
        }
        resQuery.prepare("Update noteresources set noteguid=:newGuid where noteguid=:oldGuid");
        resQuery.bindValue(":newGuid", newGuid);
        resQuery.bindValue(":oldGuid", oldGuid);
        check = resQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Note guid update failed for noteresources.");
            this.logger.log(this.logger.MEDIUM, resQuery.lastError());
        }
        this.db.getHistoryTable().updateHistoryGuid(newGuid, oldGuid);
        this.db.getExcludedTable().updateExcludedNoteGuid(newGuid, oldGuid);
        this.db.getStaredTable().updateStaredNoteGuid(newGuid, oldGuid);
    }

    public void updateNote(Note n) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.updateNote");
        NoteMetadata meta = this.getNoteMetaInformation(n.getGuid());
        String originalGuid = this.findAlternateGuid(n.getGuid());
        this.expungeNote(n.getGuid(), true, false);
        this.addNote(n, false);
        if (n != null) {
            this.updateNoteMetadata(meta);
        }
        if (originalGuid != null) {
            this.updateNoteGuid(n.getGuid(), originalGuid);
            this.updateNoteGuid(originalGuid, n.getGuid());
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.updateNote");
    }

    public boolean exists(String guid) {
        if (guid == null) {
            return false;
        }
        if (guid.trim().equals("")) {
            return false;
        }
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from note where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "note.exists SQL retrieve has failed.");
        }
        boolean retVal = query.next();
        return retVal;
    }

    public boolean isNoteExpunged(String guid) {
        if (guid == null) {
            return false;
        }
        if (guid.trim().equals("")) {
            return false;
        }
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select isExpunged from note where guid=:guid and isExpunged = true");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "note.isNoteExpunged SQL retrieve has failed.");
        }
        boolean retVal = query.next();
        return retVal;
    }

    public void syncNote(Note note) {
        this.logger.log(this.logger.HIGH, "Entering NoteTable.syncNote");
        NoteMetadata meta = null;
        meta = note.getAttributes() != null && note.getAttributes().getSourceApplication() != null ? this.extractMetadata(note.getAttributes().getSourceApplication()) : this.getNoteMetaInformation(note.getGuid());
        if (this.exists(note.getGuid())) {
            this.updateNote(note);
        } else {
            this.addNote(note, false);
        }
        if (meta != null) {
            meta.setGuid(note.getGuid());
            this.updateNoteMetadata(meta);
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteTable.syncNote");
    }

    public List<Note> getDirty() {
        ArrayList<Note> notes = new ArrayList<Note>();
        ArrayList<String> index = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid from Note where isDirty = true and isExpunged = false and notebookGuid not in (select guid from notebook where local = true or linked = true)");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed: " + query.lastError().toString());
        }
        while (query.next()) {
            String guid = new String();
            guid = query.valueString(0);
            index.add(guid);
        }
        int i = 0;
        while (i < index.size()) {
            Note tempNote = this.getNote((String)index.get(i), true, true, false, true, true);
            notes.add(tempNote);
            ++i;
        }
        this.logger.log(this.logger.LOW, "Dirty local notes: " + new Integer(notes.size()).toString());
        return notes;
    }

    public List<Note> getDirtyLinkedNotes() {
        ArrayList<Note> notes = new ArrayList<Note>();
        ArrayList<String> index = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid from Note where isDirty = true and isExpunged = false and notebookGuid in (select guid from notebook where linked = true)");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed: " + query.lastError().toString());
        }
        while (query.next()) {
            String guid = new String();
            guid = query.valueString(0);
            index.add(guid);
        }
        int i = 0;
        while (i < index.size()) {
            Note tempNote = this.getNote((String)index.get(i), true, true, false, true, true);
            notes.add(tempNote);
            ++i;
        }
        this.logger.log(this.logger.LOW, "Dirty linked local notes: " + new Integer(notes.size()).toString());
        return notes;
    }

    public List<Note> getDirtyLinked(String notebookGuid) {
        ArrayList<Note> notes = new ArrayList<Note>();
        ArrayList<String> index = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from Note where isDirty = true and isExpunged = false and notebookGuid=:notebookGuid");
        query.bindValue(":notebookGuid", notebookGuid);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed getting dirty linked notes: " + query.lastError().toString());
        }
        while (query.next()) {
            String guid = new String();
            guid = query.valueString(0);
            index.add(guid);
        }
        int i = 0;
        while (i < index.size()) {
            Note tempNote = this.getNote((String)index.get(i), true, true, false, true, true);
            notes.add(tempNote);
            ++i;
        }
        this.logger.log(this.logger.LOW, "Dirty local notes for notebook " + notebookGuid + ": " + new Integer(notes.size()).toString());
        return notes;
    }

    public List<String> getNotesByNotebook(String notebookGuid) {
        ArrayList<String> notes = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid from Note where notebookguid=:notebookguid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed: " + query.lastError().toString());
        }
        query.bindValue(":notebookguid", notebookGuid);
        query.exec();
        while (query.next()) {
            notes.add(query.valueString(0));
        }
        return notes;
    }

    public boolean isNoteDirty(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid from Note where isDirty = true and guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed: " + query.lastError().toString());
        }
        boolean returnValue = query.next();
        return returnValue;
    }

    public void resetDirtyFlag(String guid) {
        this.logger.log(this.logger.LOW, "Resetting dirty flag for " + guid);
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update note set isdirty=false where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error resetting note dirty field.");
        }
    }

    public List<String> getAllGuids() {
        ArrayList<String> notes = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid from Note");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve has failed: " + query.lastError());
        }
        while (query.next()) {
            notes.add(new String(query.valueString(0)));
        }
        return notes;
    }

    public List<Note> getAllNotes() {
        NSqlQuery query;
        boolean check;
        ArrayList<Note> notes = new ArrayList<Note>();
        this.prepareQueries();
        if (this.getAllQueryWithoutContent == null) {
            this.prepareQueries();
        }
        if (!(check = (query = this.getAllQueryWithoutContent).exec())) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve has failed: " + query.lastError());
        }
        while (query.next()) {
            notes.add(this.mapNoteFromQuery(query, false, false, false, false, true));
        }
        return notes;
    }

    public int getUnindexedCount() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("select count(*) from note where indexneeded=true and isExpunged = false");
        query.next();
        int returnValue = new Integer(query.valueString(0));
        return returnValue;
    }

    public int getDirtyCount() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("select count(guid) from note where isDirty=true and isExpunged = false");
        query.next();
        int returnValue = new Integer(query.valueString(0));
        this.logger.log(this.logger.LOW, "dirty count: " + returnValue);
        return returnValue;
    }

    public int getNoteCount() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("select count(*) from note where isExpunged = false");
        query.next();
        int returnValue = new Integer(query.valueString(0));
        return returnValue;
    }

    public int getDeletedCount() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("select count(*) from note where isExpunged = false and active = false");
        if (!query.next()) {
            return 0;
        }
        int returnValue = new Integer(query.valueString(0));
        return returnValue;
    }

    public void resetNoteSequence(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Note set updateSequenceNumber=0, isDirty=true where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note ResetSequence sql prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Update note sequence number has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void updateNoteResourceGuidbyHash(String noteGuid, String resGuid, String hash) {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("update noteresources set guid=:guid where noteGuid=:noteGuid and datahash=:hex");
        query.bindValue(":guid", resGuid);
        query.bindValue(":noteGuid", noteGuid);
        query.bindValue(":hex", hash);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Note Resource Update by Hash failed");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
    }

    private String fixCarriageReturn(String note) {
        if (note == null || !Global.enableCarriageReturnFix) {
            return note;
        }
        QByteArray a0Hex = new QByteArray("a0");
        String a0 = QByteArray.fromHex((QByteArray)a0Hex).toString();
        note = note.replace("<div>" + a0 + "</div>", "<div>&nbsp;</div>");
        return note.replace("<div/>", "<div>&nbsp;</div>");
    }

    public List<String> expungeIgnoreSynchronizedNotes(List<String> notebooks, List<String> tags, List<String> linked) {
        int j;
        List<String> notes;
        ArrayList<String> noteGuids = new ArrayList<String>();
        int i = 0;
        while (i < notebooks.size()) {
            notes = this.findNotesByNotebook(notebooks.get(i));
            j = 0;
            while (j < notes.size()) {
                if (!this.isNoteDirty(notes.get(j))) {
                    this.expungeNote(notes.get(j), true, false);
                    noteGuids.add(notes.get(j));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < tags.size()) {
            notes = this.findNotesByTag(tags.get(i));
            j = 0;
            while (j < notes.size()) {
                if (!this.isNoteDirty(notes.get(j))) {
                    this.expungeNote(notes.get(j), true, false);
                    noteGuids.add(notes.get(j));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < linked.size()) {
            String notebookGuid = this.db.getLinkedNotebookTable().getNotebookGuid(linked.get(i));
            if (notebookGuid != null && !notebookGuid.trim().equals("")) {
                List<Tag> linkedTags = this.db.getTagTable().getTagsForNotebook(notebookGuid);
                int j2 = 0;
                while (j2 < linkedTags.size()) {
                    this.db.getTagTable().expungeTag(linkedTags.get(j2).getGuid(), false);
                    ++j2;
                }
                List<String> notes2 = this.findNotesByNotebook(notebookGuid);
                int j3 = 0;
                while (j3 < notes2.size()) {
                    if (!this.isNoteDirty(notes2.get(j3))) {
                        this.expungeNote(notes2.get(j3), true, false);
                        noteGuids.add(notes2.get(j3));
                    }
                    ++j3;
                }
            }
            ++i;
        }
        return noteGuids;
    }

    public List<String> findNotesByNotebook(String notebook) {
        ArrayList<String> values = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from note where notebookguid=:notebook");
        query.bindValue(":notebook", notebook);
        query.exec();
        while (query.next()) {
            values.add(query.valueString(0));
        }
        return values;
    }

    public List<String> findNotesByTag(String tag) {
        ArrayList<String> values = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select distinct noteguid from notetags where tagguid=:tag");
        query.bindValue(":tag", tag);
        query.exec();
        while (query.next()) {
            values.add(query.valueString(0));
        }
        return values;
    }

    public List<Pair<String, String>> findNotesByTitle(String text) {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid,title from Note where lower(title) like :title");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL prepare for search by title has failed: " + query.lastError().toString());
        }
        query.bindValue(":title", "%" + text.toLowerCase() + "%");
        query.exec();
        while (query.next()) {
            Pair<String, String> p = new Pair<String, String>();
            p.setFirst(query.valueString(0));
            p.setSecond(query.valueString(1));
            results.add(p);
        }
        return results;
    }

    public void setIndexNeeded(String guid, Boolean flag) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update Note set indexNeeded=:flag where guid=:guid");
        if (flag.booleanValue()) {
            query.bindValue(":flag", 1);
        } else {
            query.bindValue(":flag", 0);
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Note indexNeeded update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        List<Resource> r = this.noteResourceTable.getNoteResources(guid, false);
        int i = 0;
        while (r != null && i < r.size()) {
            this.noteResourceTable.setIndexNeeded(r.get(i).getGuid(), true);
            ++i;
        }
    }

    public void reindexAllNotes() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("Update Note set indexNeeded=true")) {
            this.logger.log(this.logger.MEDIUM, "Note reindexAllNotes update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public List<String> getUnindexed() {
        ArrayList<String> index = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("Select guid from Note where isExpunged = false and indexNeeded = true and DATEDIFF('MINUTE',updated,CURRENT_TIMESTAMP)>5")) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed on getUnindexed().");
        }
        while (query.next()) {
            String guid = new String();
            guid = query.valueString(0);
            index.add(guid);
        }
        return index;
    }

    public List<String> getNextUnindexed(int limit) {
        ArrayList<String> guids = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("Select guid from Note where isExpunged = false and indexNeeded = true and DATEDIFF('MINUTE',Updated,CURRENT_TIMESTAMP)>5 limit " + limit)) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed on getUnindexed().");
        }
        while (query.next()) {
            String guid = new String();
            guid = query.valueString(0);
            guids.add(guid);
        }
        return guids;
    }

    public void updateNoteMetadata(NoteMetadata meta) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Update Note set titleColor=:color, pinned=:pinned, attributeSourceApplication=:metaString, isDirty=true where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Note SQL prepare has failed on updateNoteMetadata.");
        }
        query.bindValue(":color", meta.getColor());
        query.bindValue(":pinned", meta.isPinned());
        query.bindValue(":guid", meta.getGuid());
        query.bindValue(":metaString", this.buildMetadataString(meta));
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Note SQL exec has failed on updateNoteMetadata.");
        }
    }

    public HashMap<String, NoteMetadata> getNotesMetaInformation() {
        HashMap<String, NoteMetadata> returnValue = new HashMap<String, NoteMetadata>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("Select guid,titleColor, isDirty, pinned from Note")) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed on getNoteMetaInformation.");
        }
        while (query.next()) {
            NoteMetadata note = new NoteMetadata();
            note.setGuid(query.valueString(0));
            note.setColor(query.valueInteger(1));
            note.setDirty(query.valueBoolean(2, false));
            int pinned = query.valueInteger(3);
            if (pinned > 0) {
                note.setPinned(true);
            }
            returnValue.put(note.getGuid(), note);
        }
        return returnValue;
    }

    public NoteMetadata getNoteMetaInformation(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select guid,titleColor, isDirty, pinned from Note where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed on getNoteMetaInformation.");
            return null;
        }
        query.bindValue(":guid", guid);
        query.exec();
        if (query.next()) {
            NoteMetadata note = new NoteMetadata();
            note.setGuid(query.valueString(0));
            note.setColor(query.valueInteger(1));
            note.setDirty(query.valueBoolean(2, false));
            int pinned = query.valueInteger(3);
            if (pinned > 0) {
                note.setPinned(true);
            }
            return note;
        }
        return null;
    }

    public void setThumbnailNeeded(String guid, boolean needed) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update note set thumbnailneeded = :needed where guid=:guid");
        query.bindValue(":guid", guid);
        query.bindValue(":needed", needed);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL set thumbail needed failed: " + query.lastError().toString());
        }
    }

    public boolean isThumbnailNeeded(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("select thumbnailneeded from note where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL isThumbnailNeeded query failed: " + query.lastError().toString());
        }
        boolean returnValue = query.next() ? query.valueBoolean(0, false) : false;
        return returnValue;
    }

    public void setThumbnail(String guid, QByteArray thumbnail) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update note set thumbnail = :thumbnail where guid=:guid");
        query.bindValue(":guid", guid);
        query.bindValue(":thumbnail", thumbnail.toByteArray());
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL set thumbail failed: " + query.lastError().toString());
        }
    }

    public QByteArray getThumbnail(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select thumbnail from note where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL get thumbail failed: " + query.lastError().toString());
        }
        if (query.next()) {
            try {
                if (query.getBlob(0) != null) {
                    return new QByteArray(query.getBlob(0));
                }
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public HashMap<String, QPixmap> getThumbnails() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        HashMap<String, QPixmap> map = new HashMap<String, QPixmap>();
        boolean check = query.prepare("Select guid,thumbnail from note where thumbnailneeded=false and isExpunged=false");
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL get thumbail failed: " + query.lastError().toString());
        }
        while (query.next()) {
            try {
                QByteArray data;
                QPixmap img;
                if (query.getBlob(1) == null || !(img = new QPixmap()).loadFromData(data = new QByteArray(query.getBlob(1)))) continue;
                img = img.scaled(Global.largeThumbnailSize);
                map.put(query.valueString(0), img);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(this.logger.HIGH, "Error retrieving thumbnail " + e.getMessage());
            }
        }
        return map;
    }

    public List<String> findThumbnailsNeeded() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("select guid from note where thumbnailneeded=true and isExpunged=false and DATEDIFF('MINUTE',updated,CURRENT_TIMESTAMP)>5 limit 5");
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL findThumbnailsNeeded query failed: " + query.lastError().toString());
        }
        ArrayList<String> values = new ArrayList<String>();
        while (query.next()) {
            values.add(query.valueString(0));
        }
        return values;
    }

    public int getThumbnailNeededCount() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("select count(guid) from note where thumbnailneeded=true and isExpunged=false and DATEDIFF('MINUTE',updated,CURRENT_TIMESTAMP)>5 limit 2");
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL findThumbnailNeededCount query failed: " + query.lastError().toString());
        }
        if (query.next()) {
            return query.valueInteger(0);
        }
        return 0;
    }

    public String findAlternateGuid(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("select guid from note where original_guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL findAlternateguid query failed: " + query.lastError().toString());
        }
        if (query.next()) {
            return query.valueString(0);
        }
        return null;
    }

    public boolean guidExists(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("select guid from note where guid=:guid");
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL guidExists query failed: " + query.lastError().toString());
        }
        return query.next();
    }

    public void updateResourceContentHash(String guid, String oldHash, String newHash) {
        Note n = this.getNote(guid, true, false, false, false, false);
        int position = n.getContent().indexOf("<en-media");
        while (position > -1) {
            int hashEnd;
            int hashPos;
            int endPos = n.getContent().indexOf(">", position + 1);
            String oldSegment = n.getContent().substring(position, endPos);
            String hash = oldSegment.substring((hashPos = oldSegment.indexOf("hash=\"")) + 6, hashEnd = oldSegment.indexOf("\"", hashPos + 7));
            if (hash.equalsIgnoreCase(oldHash)) {
                String newSegment = oldSegment.replace(oldHash, newHash);
                String content = String.valueOf(n.getContent().substring(0, position)) + newSegment + n.getContent().substring(endPos);
                NSqlQuery query = new NSqlQuery(this.db.getConnection());
                query.prepare("update note set isdirty=true, thumbnailneeded=true, content=:content where guid=:guid");
                query.bindValue(":content", content);
                query.bindValue(":guid", n.getGuid());
                query.exec();
            }
            position = n.getContent().indexOf("<en-media", position + 1);
        }
    }

    private NoteMetadata extractMetadata(String sourceApplication) {
        String value;
        String consumerKey = "kimaira792:{";
        int startPos = sourceApplication.indexOf(consumerKey);
        if (startPos < 0) {
            return null;
        }
        NoteMetadata meta = new NoteMetadata();
        String metaString = sourceApplication.substring(startPos += consumerKey.length());
        int endPos = metaString.indexOf("};");
        if (endPos > 0) {
            metaString = metaString.substring(0, endPos);
        }
        if ((value = this.parseMetaString(metaString, "titleColor")) != null) {
            meta.setColor(Integer.parseInt(value));
        }
        if ((value = this.parseMetaString(metaString, "pinned")) != null && value.equals(true)) {
            meta.setPinned(true);
        }
        return meta;
    }

    private String parseMetaString(String metaString, String key) {
        int startPos = metaString.indexOf(key);
        if (startPos < 0) {
            return null;
        }
        String value = metaString.substring(startPos + key.length() + 1);
        int endPos = value.indexOf(";");
        if (endPos > 0) {
            value = value.substring(0, endPos);
        }
        return value;
    }

    private String buildMetadataString(NoteMetadata meta) {
        StringBuffer value = new StringBuffer(this.removeExistingMetaString(meta.getGuid()));
        StringBuffer metaString = new StringBuffer();
        if (meta.isPinned()) {
            metaString.append("pinned=true;");
        }
        if (meta.getColor() != -1) {
            metaString.append("titleColor=" + new Integer(meta.getColor()).toString() + ";");
        }
        if (metaString.length() > 0) {
            if (!(value.length() <= 1 || value.toString().trim().endsWith(";") && value.toString().trim().endsWith(";"))) {
                value.append("; ");
            }
            value.append("kimaira792:{");
            value.append(metaString);
            value.append("};");
            return value.toString();
        }
        return null;
    }

    private String removeExistingMetaString(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select attributeSourceApplication from Note where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Note SQL retrieve has failed in removeExistingMetaString.");
            return null;
        }
        query.bindValue(":guid", guid);
        query.exec();
        String sourceApplication = null;
        while (query.next()) {
            sourceApplication = query.valueString(0);
        }
        if (sourceApplication == null) {
            return "";
        }
        String consumerKey = "kimaira792:{";
        int startPos = sourceApplication.indexOf(consumerKey);
        if (startPos < 0) {
            return sourceApplication;
        }
        String startString = sourceApplication.substring(0, startPos);
        String metaString = sourceApplication.substring(startPos);
        String endString = metaString.substring(metaString.indexOf("};") + 2);
        return String.valueOf(startString) + endString;
    }

    public void dumpDirtyNotes() {
        this.logger.log(this.logger.LOW, "Dirty Notes: ");
        List<Note> noteList = this.getDirty();
        int i = 0;
        while (i < noteList.size()) {
            this.logger.log(this.logger.LOW, String.valueOf(i) + " : " + noteList.get(i).getGuid() + " : " + noteList.get(i).getTitle());
            ++i;
        }
    }

    public String getNoteTitle(String noteGuid) {
        if (noteGuid == null) {
            return null;
        }
        if (noteGuid.trim().equals("")) {
            return null;
        }
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select title from Note where guid=:guid and isExpunged=false");
        query.bindValue(":guid", noteGuid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Note\u30c6\u30fc\u30d6\u30eb\u304b\u3089\u30bf\u30a4\u30c8\u30eb\u306e\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        if (!query.next()) {
            this.logger.log(this.logger.EXTREME, "SQL Retrieve failed for note guid " + noteGuid + " in getNoteTitle()");
            this.logger.log(this.logger.EXTREME, " -> " + query.lastError().toString());
            this.logger.log(this.logger.EXTREME, " -> " + query.lastError());
            return null;
        }
        String noteTitle = query.valueString(0);
        return noteTitle;
    }
}

