/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;

public class ExcludedTable {
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public ExcludedTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        this.logger.log(this.logger.HIGH, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059...");
        if (!query.exec("Create table ExcludedNotes (id integer primary key auto_increment, guid1 varchar, guid2 varchar)")) {
            this.logger.log(this.logger.HIGH, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u4f5c\u6210\u5931\u6557!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.exec("Drop table ExcludedNotes");
    }

    public void addExclusion(String guid1, String guid2) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.prepare("Insert Into ExcludedNotes (guid1, guid2) Values(:guid1, :guid2)");
        query.bindValue(":guid1", guid1);
        query.bindValue(":guid2", guid2);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u3078\u306e\u30a2\u30a4\u30c6\u30e0\u8ffd\u52a0\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void mergeHistoryGuid(String masterGuid, String childGuid) {
        NSqlQuery excludedNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        boolean check = false;
        excludedNotesQuery.prepare("Delete from ExcludedNotes where (guid1=:oldGuid1 and guid2=:newGuid1) or (guid1=:newGuid2 and guid2=:oldGuid2)");
        excludedNotesQuery.bindValue(":oldGuid1", masterGuid);
        excludedNotesQuery.bindValue(":newGuid1", childGuid);
        excludedNotesQuery.bindValue(":oldGuid2", masterGuid);
        excludedNotesQuery.bindValue(":newGuid2", childGuid);
        check = excludedNotesQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "excludedNotes\u30c6\u30fc\u30d6\u30eb\u306e\u91cd\u8907\u524a\u9664\u3067\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, excludedNotesQuery.lastError());
        }
        this.updateExcludedNoteGuid(masterGuid, childGuid);
    }

    public void updateExcludedNoteGuid(String newGuid, String oldGuid) {
        NSqlQuery excludedNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        boolean check = false;
        excludedNotesQuery.prepare("Update ExcludedNotes set guid1=:newGuid where guid1=:oldGuid");
        excludedNotesQuery.bindValue(":newGuid", newGuid);
        excludedNotesQuery.bindValue(":oldGuid", oldGuid);
        check = excludedNotesQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u306eguid1\u306e\u3068\u3053\u308d\u3067guid\u66f4\u65b0\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, excludedNotesQuery.lastError());
        }
        excludedNotesQuery.prepare("Update ExcludedNotes set guid2=:newGuid where guid2=:oldGuid");
        excludedNotesQuery.bindValue(":newGuid", newGuid);
        excludedNotesQuery.bindValue(":oldGuid", oldGuid);
        check = excludedNotesQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u306eguid2\u306e\u3068\u3053\u308d\u3067guid\u66f4\u65b0\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, excludedNotesQuery.lastError());
        }
    }

    public boolean existNote(String guid1, String guid2) {
        NSqlQuery excludedNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        excludedNotesQuery.prepare("Select * from ExcludedNotes where Exists(Select * from ExcludedNotes where (guid1=:guid1_1 and guid2=:guid2_1) or (guid1=:guid2_2 and guid2=:guid1_2))");
        excludedNotesQuery.bindValue(":guid1_1", guid1);
        excludedNotesQuery.bindValue(":guid2_1", guid2);
        excludedNotesQuery.bindValue(":guid1_2", guid1);
        excludedNotesQuery.bindValue(":guid2_2", guid2);
        if (!excludedNotesQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid1=" + guid1 + "\u304b\u3064guid2=" + guid2 + "\uff08\u307e\u305f\u306f\u305d\u306e\u9006\uff09\u306e\u30a2\u30a4\u30c6\u30e0\u306e\u5b58\u5728\u78ba\u8a8d\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, excludedNotesQuery.lastError());
        }
        return excludedNotesQuery.next();
    }

    public void duplicateExcludedNotes(String newGuid, String oldGuid) {
        NSqlQuery excludedNotesQuery = new NSqlQuery(this.db.getBehaviorConnection());
        excludedNotesQuery.prepare("Select guid2 from ExcludedNotes where guid1=:oldGuid");
        excludedNotesQuery.bindValue(":oldGuid", oldGuid);
        if (!excludedNotesQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid1=" + oldGuid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, excludedNotesQuery.lastError());
        }
        while (excludedNotesQuery.next()) {
            String guid2 = excludedNotesQuery.valueString(0);
            this.addExclusion(newGuid, guid2);
        }
        excludedNotesQuery.prepare("Select guid1 from ExcludedNotes where guid2=:oldGuid");
        excludedNotesQuery.bindValue(":oldGuid", oldGuid);
        if (!excludedNotesQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid2=" + oldGuid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, excludedNotesQuery.lastError());
        }
        while (excludedNotesQuery.next()) {
            String guid1 = excludedNotesQuery.valueString(0);
            this.addExclusion(guid1, newGuid);
        }
    }

    public void expungeExcludedNote(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.prepare("Delete from ExcludedNotes where guid1=:guid1 or guid2=:guid2");
        query.bindValue(":guid1", guid);
        query.bindValue(":guid2", guid);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "ExcludedNotes\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid=" + guid + "\u306e\u30c7\u30fc\u30bf\u524a\u9664\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }
}

