/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Note;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractTableModel;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.evernote.NoteMetadata;
import cx.fbn.nevernote.filters.NoteSortFilterProxyModel;
import cx.fbn.nevernote.utilities.ListManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class NoteTableModel
extends QAbstractTableModel {
    private final ListManager listManager;
    private final Object[] headers = new Object[Global.noteTableColumnCount];
    private List<Note> noteIndex;
    private List<Note> masterNoteIndex;
    public HashMap<String, NoteMetadata> metaData;
    public NoteSortFilterProxyModel proxyModel;

    public NoteTableModel(ListManager m) {
        this.listManager = m;
        this.masterNoteIndex = null;
        this.metaData = new HashMap();
    }

    public List<Note> getNoteIndex() {
        return this.noteIndex;
    }

    public void setNoteIndex(List<Note> list) {
        this.noteIndex = list;
    }

    public List<Note> getMasterNoteIndex() {
        return this.masterNoteIndex;
    }

    public void setMasterNoteIndex(List<Note> list) {
        this.masterNoteIndex = list;
    }

    public void setSortProxyModel(NoteSortFilterProxyModel m) {
        this.proxyModel = m;
    }

    public void setNoteMetadata(HashMap<String, NoteMetadata> list) {
        this.metaData = list;
    }

    public int columnCount(QModelIndex arg0) {
        return Global.noteTableColumnCount;
    }

    public Object data(QModelIndex index, int role) {
        if (index == null) {
            return null;
        }
        switch (role) {
            case 0: {
                return this.valueAt(index.row(), index.column());
            }
            case 1: {
                if (index.column() == Global.noteTableThumbnailPosition || index.column() == Global.noteTableSynchronizedPosition || index.column() == Global.noteTablePinnedPosition) {
                    return this.valueAt(index.row(), index.column());
                }
                return null;
            }
            case 8: {
                String guid = (String)this.valueAt(index.row(), Global.noteTableGuidPosition);
                QColor backgroundColor = new QColor(QColor.white);
                if (this.metaData != null && this.metaData.containsKey(guid)) {
                    int color = this.metaData.get(guid).getColor();
                    backgroundColor.setRgb(color);
                }
                return backgroundColor;
            }
            case 9: {
                String guid = (String)this.valueAt(index.row(), Global.noteTableGuidPosition);
                QColor backgroundColor = new QColor(QColor.white);
                QColor foregroundColor = new QColor(QColor.black);
                if (this.metaData != null && this.metaData.containsKey(guid)) {
                    int color = this.metaData.get(guid).getColor();
                    backgroundColor.setRgb(color);
                    if (backgroundColor.rgb() == QColor.black.rgb() || backgroundColor.rgb() == QColor.blue.rgb()) {
                        foregroundColor.setRgb(QColor.white.rgb());
                    }
                }
                return foregroundColor;
            }
        }
        return null;
    }

    public int rowCount(QModelIndex arg0) {
        if (this.listManager != null && this.listManager.getMasterNoteIndex() != null) {
            return this.listManager.getMasterNoteIndex().size();
        }
        return 0;
    }

    private Object valueAt(int row, int col) {
        Note note = this.listManager.getMasterNoteIndex().get(row);
        if (col == Global.noteTableGuidPosition) {
            return note.getGuid();
        }
        if (col == Global.noteTableCreationPosition) {
            return note.getCreated();
        }
        if (col == Global.noteTableChangedPosition) {
            return note.getUpdated();
        }
        if (col == Global.noteTableSubjectDatePosition) {
            if (note.getAttributes().getSubjectDate() > 0L) {
                return note.getAttributes().getSubjectDate();
            }
            return note.getCreated();
        }
        if (col == Global.noteTableTitlePosition) {
            return note.getTitle();
        }
        if (col == Global.noteTableAuthorPosition) {
            return note.getAttributes().getAuthor();
        }
        if (col == Global.noteTableSourceUrlPosition) {
            return note.getAttributes().getSourceURL();
        }
        if (col == Global.noteTableSynchronizedPosition) {
            String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
            QIcon dotIcon = new QIcon(String.valueOf(iconPath) + "dot.png");
            String guid = note.getGuid();
            if (this.metaData.containsKey(guid) && this.metaData.get(guid).isDirty()) {
                return dotIcon;
            }
            return null;
        }
        if (col == Global.noteTablePinnedPosition) {
            String guid = note.getGuid();
            if (this.metaData.containsKey(guid) && this.metaData.get(guid).isPinned()) {
                String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
                QIcon dotIcon = new QIcon(String.valueOf(iconPath) + "dot.png");
                return dotIcon;
            }
            return null;
        }
        if (col == Global.noteTableTagPosition) {
            String tags = new String();
            ArrayList<String> tagNames = new ArrayList<String>();
            int i = 0;
            while (i < note.getTagNamesSize()) {
                tagNames.add((String)note.getTagNames().get(i));
                ++i;
            }
            while (tagNames.size() > 0) {
                int position = 0;
                int i2 = 0;
                while (i2 < tagNames.size() - 1) {
                    String name2;
                    String name1 = (String)tagNames.get(i2);
                    if (name1.compareTo(name2 = (String)tagNames.get(i2 + 1)) > 0) {
                        position = i2 + 1;
                    }
                    ++i2;
                }
                tags = String.valueOf(tags) + (String)tagNames.get(position);
                tagNames.remove(position);
                if (tagNames.size() <= 0) continue;
                tags = String.valueOf(tags) + ", ";
            }
            return tags;
        }
        if (col == Global.noteTableNotebookPosition) {
            int i = 0;
            while (i < this.listManager.getNotebookIndex().size()) {
                if (this.listManager.getNotebookIndex().get(i).getGuid().equals(note.getNotebookGuid())) {
                    return this.listManager.getNotebookIndex().get(i).getName();
                }
                ++i;
            }
        }
        if (col == Global.noteTableGuidPosition) {
            return note.getGuid();
        }
        if (col == Global.noteTableThumbnailPosition) {
            if (!Global.enableThumbnails()) {
                return null;
            }
            if (Global.getListView() == Global.View_List_Wide) {
                QPixmap img = this.listManager.getThumbnailPixmap(note.getGuid());
                if (img != null) {
                    return img.scaled(Global.smallThumbnailSize, Qt.AspectRatioMode.KeepAspectRatio, Qt.TransformationMode.SmoothTransformation);
                }
                return null;
            }
            QImage img = this.listManager.getThumbnail(note.getGuid());
            if (img != null) {
                return img.scaled(Global.largeThumbnailSize, Qt.AspectRatioMode.KeepAspectRatio, Qt.TransformationMode.SmoothTransformation);
            }
            return null;
        }
        return "";
    }

    public Object headerData(int section, Qt.Orientation orientation, int role) {
        if (role != 0) {
            return null;
        }
        if (orientation == Qt.Orientation.Horizontal && section < this.headers.length && section >= 0) {
            return this.headers[section];
        }
        return null;
    }

    public boolean setHeaderData(int section, Qt.Orientation orientation, Object value, int role) {
        if (orientation == Qt.Orientation.Horizontal && section < this.headers.length && role == 0) {
            this.headers[section] = value;
            this.headerDataChanged.emit((Object)orientation, (Object)section, (Object)section);
            return true;
        }
        return false;
    }

    public void updateNoteTitle(String guid, String title) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).setTitle(title);
                QModelIndex idx = this.createIndex(i, Global.noteTableTitlePosition, this.nativePointer());
                this.setData(idx, title, 2);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).setTitle(title);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteTags(String guid, List<String> tags, List<String> names) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).setTagGuids(tags);
                this.getMasterNoteIndex().get(i).setTagNames(names);
                String display = new String("");
                Collections.sort(names);
                int j = 0;
                while (j < names.size()) {
                    display = String.valueOf(display) + names.get(j);
                    if (j + 2 < names.size()) {
                        display = String.valueOf(display) + Global.tagDelimeter + " ";
                    }
                    ++j;
                }
                QModelIndex idx = this.createIndex(i, Global.noteTableTagPosition, this.nativePointer());
                this.setData(idx, display, 2);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteCreatedDate(String guid, QDateTime date) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).setCreated((long)date.toTime_t() * 1000L);
                QModelIndex idx = this.createIndex(i, Global.noteTableCreationPosition, this.nativePointer());
                this.setData(idx, new Long(this.getMasterNoteIndex().get(i).getCreated()), 2);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).setCreated((long)date.toTime_t() * 1000L);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteSubjectDate(String guid, QDateTime date) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).getAttributes().setSubjectDate((long)date.toTime_t() * 1000L);
                QModelIndex idx = this.createIndex(i, Global.noteTableSubjectDatePosition, this.nativePointer());
                this.setData(idx, new Long(this.getMasterNoteIndex().get(i).getAttributes().getSubjectDate()), 2);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).getAttributes().setSubjectDate((long)date.toTime_t() * 1000L);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteChangedDate(String guid, QDateTime date) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).setUpdated((long)date.toTime_t() * 1000L);
                QModelIndex idx = this.createIndex(i, Global.noteTableChangedPosition, this.nativePointer());
                this.setData(idx, new Long(this.getMasterNoteIndex().get(i).getAttributes().getSubjectDate()), 2);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).setUpdated((long)date.toTime_t() * 1000L);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteGuid(String oldGuid, String newGuid) {
        int i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid() != null && this.getNoteIndex().get(i).getGuid().equals(oldGuid)) {
                this.getNoteIndex().get(i).setGuid(newGuid);
                i = this.getNoteIndex().size() + 1;
            }
            ++i;
        }
        boolean k = true;
        if (k) {
            return;
        }
        int i2 = 0;
        while (i2 < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i2).getGuid() != null && this.getMasterNoteIndex().get(i2).getGuid().equals(oldGuid)) {
                this.getMasterNoteIndex().get(i2).setGuid(newGuid);
                i2 = this.getMasterNoteIndex().size() + 1;
            }
            ++i2;
        }
    }

    public void updateNoteNotebook(String guid, String notebookGuid) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).setNotebookGuid(notebookGuid);
                int j = 0;
                while (j < this.listManager.getNotebookIndex().size()) {
                    if (this.listManager.getNotebookIndex().get(j).getGuid().equals(notebookGuid)) {
                        String name = this.listManager.getNotebookIndex().get(j).getName();
                        QModelIndex idx = this.createIndex(i, Global.noteTableNotebookPosition, this.nativePointer());
                        this.setData(idx, name, 2);
                        j = this.listManager.getNotebookIndex().size();
                    }
                    ++j;
                }
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).setNotebookGuid(notebookGuid);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteAuthor(String guid, String author) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).getAttributes().setAuthor(author);
                this.getMasterNoteIndex().get(i).getAttributes().setAltitudeIsSet(true);
                QModelIndex idx = this.createIndex(i, Global.noteTableAuthorPosition, this.nativePointer());
                this.setData(idx, author, 2);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).getAttributes().setAuthor(author);
                this.getNoteIndex().get(i).getAttributes().setAuthorIsSet(true);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteSourceUrl(String guid, String url) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                this.getMasterNoteIndex().get(i).getAttributes().setSourceURL(url);
                this.getMasterNoteIndex().get(i).getAttributes().setSourceURLIsSet(true);
                QModelIndex idx = this.createIndex(i, Global.noteTableSourceUrlPosition, this.nativePointer());
                this.setData(idx, url, 2);
                i = this.getMasterNoteIndex().size();
            }
            ++i;
        }
        i = 0;
        while (i < this.getNoteIndex().size()) {
            if (this.getNoteIndex().get(i).getGuid().equals(guid)) {
                this.getNoteIndex().get(i).getAttributes().setSourceURL(url);
                this.getNoteIndex().get(i).getAttributes().setSourceURLIsSet(true);
                i = this.getNoteIndex().size();
            }
            ++i;
        }
    }

    public void updateNoteSyncStatus(String guid, boolean sync) {
        if (this.metaData.containsKey(guid)) {
            this.metaData.get(guid).setDirty(!sync);
        }
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                QModelIndex idx = this.createIndex(i, Global.noteTableSynchronizedPosition, this.nativePointer());
                String value = !sync ? this.tr("false") : this.tr("true");
                this.setData(idx, value, 2);
                return;
            }
            ++i;
        }
    }

    public void updateNotePinnedStatus(String guid, boolean pinned) {
        int i = 0;
        while (i < this.getMasterNoteIndex().size()) {
            if (this.getMasterNoteIndex().get(i).getGuid().equals(guid)) {
                QModelIndex idx = this.createIndex(i, Global.noteTablePinnedPosition, this.nativePointer());
                if (this.metaData.containsKey(guid)) {
                    // empty if block
                }
                this.metaData.get(guid).setPinned(pinned);
                String value = pinned ? this.tr("true") : this.tr("false");
                this.setData(idx, value, 2);
                return;
            }
            ++i;
        }
    }

    public void addNote(Note n, NoteMetadata meta) {
        this.getNoteIndex().add(n);
        this.getMasterNoteIndex().add(n);
        this.proxyModel.addGuid(n.getGuid(), meta);
        this.proxyModel.invalidate();
    }

    public boolean setData(QModelIndex index, Object value, int role) {
        if (role == 2) {
            this.dataChanged.emit((Object)index, (Object)index);
            return true;
        }
        return super.setData(index, value, role);
    }

    public void setMetaData(HashMap<String, NoteMetadata> h) {
        this.metaData = h;
    }

    public Qt.ItemFlags flags(QModelIndex index) {
        Qt.ItemFlag[] flags = new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsEnabled, Qt.ItemFlag.ItemIsDragEnabled, Qt.ItemFlag.ItemIsSelectable};
        return new Qt.ItemFlags(flags);
    }

    public void updateNoteTitleColor(String guid, int color) {
        NoteMetadata m = this.metaData.get(guid);
        if (m == null) {
            m = new NoteMetadata();
            m.setGuid(guid);
            this.metaData.put(guid, m);
        }
        if (this.metaData.containsKey(guid) && this.metaData.get(guid).getColor() != color) {
            this.metaData.get(guid).setColor(color);
            this.layoutChanged.emit();
        }
    }
}

