/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.filters;

import com.evernote.edam.type.Note;
import com.trolltech.qt.core.QDateTime;
import cx.fbn.nevernote.filters.AttributeFilter;
import java.text.SimpleDateFormat;

public abstract class DateAttributeFilter
extends AttributeFilter {
    protected boolean checkSince;
    private final boolean checkCreated;

    public DateAttributeFilter(boolean since, boolean created) {
        this.checkSince = since;
        this.checkCreated = created;
    }

    @Override
    public abstract boolean attributeCheck(Note var1);

    protected QDateTime noteTime(Note n) {
        String dateTimeFormat = new String("MM/dd/yyyy HH:mm:ss");
        SimpleDateFormat simple = new SimpleDateFormat(dateTimeFormat);
        if (this.checkCreated) {
            StringBuilder creationDate = new StringBuilder(simple.format(n.getCreated()));
            return QDateTime.fromString((String)creationDate.toString(), (String)"MM/dd/yyyy HH:mm:ss");
        }
        StringBuilder updatedDate = new StringBuilder(simple.format(n.getUpdated()));
        return QDateTime.fromString((String)updatedDate.toString(), (String)"MM/dd/yyyy HH:mm:ss");
    }

    protected QDateTime currentTime() {
        return QDateTime.currentDateTime();
    }
}

