/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Notebook;
import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class NotebookEdit
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit notebook;
    private final QCheckBox localRemote;
    private final QPushButton ok;
    private List<Notebook> currentNotebooks;
    private final QCheckBox isDefault;
    private boolean startDefault;
    private String startText;
    private List<String> stacks;
    private boolean stackEdit = false;
    private final QLabel notebookLabel;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public NotebookEdit() {
        this.setWindowTitle(this.tr("Add Notebook"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "notebook-green.png"));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        QGridLayout textLayout = new QGridLayout();
        this.notebook = new QLineEdit();
        this.notebookLabel = new QLabel(this.tr("Notebook Name"));
        textLayout.addWidget((QWidget)this.notebookLabel, 1, 1);
        textLayout.addWidget((QWidget)this.notebook, 1, 2);
        textLayout.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)textLayout, 1, 1);
        this.localRemote = new QCheckBox();
        this.localRemote.setText(this.tr("Local Notebook"));
        this.localRemote.setChecked(false);
        grid.addWidget((QWidget)this.localRemote, 2, 1);
        this.isDefault = new QCheckBox();
        this.isDefault.setText(this.tr("Default Notebook"));
        this.isDefault.setChecked(false);
        this.isDefault.toggled.connect((Object)this, "defaultNotebookChecked(Boolean)");
        grid.addWidget((QWidget)this.isDefault, 3, 1);
        QGridLayout buttonLayout = new QGridLayout();
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        this.notebook.textChanged.connect((Object)this, "textChanged()");
        buttonLayout.addWidget((QWidget)this.ok, 1, 1);
        buttonLayout.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)buttonLayout, 4, 1);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public String getNotebook() {
        return this.notebook.text();
    }

    public void setStacks(List<String> s) {
        this.stacks = s;
        this.stackEdit = true;
        this.notebookLabel.setText(new String(this.tr("Stack Name")));
    }

    public void setNotebook(String name) {
        if (name.equalsIgnoreCase("All Notebooks")) {
            this.notebook.setEnabled(false);
            this.localRemote.setEnabled(false);
            this.isDefault.setEnabled(false);
        }
        this.notebook.setText(name);
        this.startText = name;
    }

    public boolean isLocal() {
        return this.localRemote.isChecked();
    }

    public void setLocalCheckboxEnabled(boolean visible) {
        this.localRemote.setEnabled(visible);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void setTitle(String s) {
        this.setWindowTitle(s);
    }

    public void setNotebooks(List<Notebook> n) {
        this.currentNotebooks = n;
    }

    public void setDefaultNotebook(boolean val) {
        this.startDefault = val;
        this.isDefault.setChecked(val);
        if (val) {
            this.isDefault.setEnabled(true);
        }
    }

    public boolean isDefaultNotebook() {
        return this.isDefault.isChecked();
    }

    private void defaultNotebookChecked(Boolean val) {
        if (val != this.startDefault || !this.startText.equals(this.notebook.text())) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public void hideDefaultCheckbox() {
        this.isDefault.setVisible(false);
    }

    public void hideLocalCheckbox() {
        this.localRemote.setVisible(false);
    }

    private void textChanged() {
        int i;
        if (this.notebook.text().equals("")) {
            this.ok.setEnabled(false);
            return;
        }
        if (this.notebook.text().equalsIgnoreCase("All Notebooks")) {
            this.ok.setEnabled(false);
            return;
        }
        if (this.stackEdit) {
            i = 0;
            while (i < this.stacks.size()) {
                if (this.stacks.get(i).equalsIgnoreCase(this.notebook.text())) {
                    this.ok.setEnabled(false);
                    return;
                }
                ++i;
            }
        }
        if (!this.stackEdit) {
            if (this.currentNotebooks == null) {
                this.ok.setEnabled(false);
                return;
            }
            i = 0;
            while (i < this.currentNotebooks.size()) {
                String s = this.currentNotebooks.get(i).getName();
                if (s.equalsIgnoreCase(this.notebook.text())) {
                    this.ok.setEnabled(false);
                    return;
                }
                ++i;
            }
        }
        this.ok.setEnabled(true);
    }
}

