
	
#include <nds.h>
#include <nds/arm9/console.h> //basic print funcionality
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "enum.h"

#include "dir_info.h"
#include "nobelparser.h"
#include "ndsfont.h"
#include "fileselect.h"
//
#include "data_bin.h"

#include "page_wav_bin.h"

#include "gba_nds_fat.h"

SpriteEntry OAMCopySub[128];

volatile int frame = 0;
#define NUM_SPRITES 128	
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
void initOAM(void) {
//---------------------------------------------------------------------------------
	int i;

	for(i = 0; i < 128; i++) {
		OAMCopySub[i].attribute[0] = ATTR0_DISABLED;
		OAMCopySub[i].attribute[1] = 0;
		OAMCopySub[i].attribute[2] = 0;
		OAMCopySub[i].attribute[3] = 0;
	}	
}
void updateOAM(void) {
	DC_FlushAll();
	dmaCopy(OAMCopySub, OAM_SUB, 128 * sizeof(SpriteEntry));
}

//---------------------------------------------------------------------------------
void irqVBlank(void) {	
//---------------------------------------------------------------------------------
	//frame++;
}

/*
static void InterruptHandler(void) {
  if (IF & IRQ_VBLANK) {
 
  	updateDisplay();
	IF = IRQ_VBLANK;
  }
}
*/
//---------------------------------------------------------------------------------
int main(void) {
//---------------------------------------------------------------------------------

	powerON(POWER_ALL_2D);

	//	
	vramSetBankA(VRAM_A_MAIN_BG_0x6000000);
	//vramSetBankB(VRAM_B_MAIN_BG_0x6020000);
	videoSetMode( MODE_5_2D | DISPLAY_BG3_ACTIVE );

	{	//̐ݒ
		BG3_CR = BG_BMP16_256x256;
		//BG3_CR ^= BG_BMP_BASE( 128 / 16 );
		BG3_XDX = 1 << 8;
		BG3_XDY = 0;
		BG3_YDX = 0;
		BG3_YDY = 1 << 8;
		BG3_CX = 0 << 8;
		BG3_CY = 0 << 8;
	}
	uint16* fb_main  = (uint16*)0x6000000;	//BG_GFX;

	lcdSwap();


	//
	vramSetBankC(VRAM_C_SUB_BG);
	vramSetBankD(VRAM_D_SUB_SPRITE);
	videoSetModeSub( MODE_2_2D | DISPLAY_BG0_ACTIVE );

	{	//̃fobOconsoleݒ
		//videoSetModeSub( MODE_2_2D | DISPLAY_BG0_ACTIVE );
		SUB_BG0_CR = BG_MAP_BASE(31);
		BG_PALETTE_SUB[255] = RGB15(31,31,31);
		consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

		iprintf("\n nobel viewer(%s %s)\n", __DATE__, __TIME__ );
		//iprintf("debug window\n");
	}

	irqInit();
	irqSet(IRQ_VBLANK, irqVBlank);

	{	//͉̕ʐݒ
		//videoSetModeSub(MODE_2_2D | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_2D | DISPLAY_SPR_2D_BMP_256);

		initOAM();

		for(u32 idx = 0; idx < 12; idx++)
		{
			OAMCopySub[idx].attribute[0] = ATTR0_NORMAL | ATTR0_BMP | ATTR0_SQUARE | ATTR0_TYPE_NORMAL | ((idx / 4) * 64);
			OAMCopySub[idx].attribute[1] = ATTR1_ROTDATA(0) | ATTR1_SIZE_64 | ((idx % 4) * 64);
			OAMCopySub[idx].attribute[2] = ATTR2_PRIORITY(0) | ATTR2_ALPHA(15) | ((8*(idx % 4))+((8*8*4)*(idx / 4)));
		}

		updateOAM();
	}
	uint16* fb_sub = SPRITE_GFX_SUB;

	//Ѓobt@̊m
	bool is_set_internal_book = true;
	char *book_src = (char *)malloc(MAX_FILE_SIZE);

	//UNA
	memset( fb_main , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );
	memset( fb_sub , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );

	iprintf( "fat initializeing..." );
	FAT_InitFiles();
	swiWaitForVBlank();
	swiWaitForVBlank();
	swiWaitForVBlank();
	iprintf( " OK.\n" );

	iprintf( "CDir_Info...\n" );
	CDir_Info dir;
	if( dir.chdir("/") )
	{
		iprintf( " OK.\n" );

		for( vector<CFile_Info>::iterator p = dir.vec_files.begin() ; p != dir.vec_files.end() ; p++ ) {
			iprintf( "+%d t:%d n:%s l:%s\n", p->idx, p->type, p->name.c_str(), p->name_long.c_str() );
		}
	}
	else
		iprintf( " Err.\n" );

	//	̉
	iprintf("novel parsing...(sa:%x)\n", data_bin );
	CNobelParser parser( (const char*) data_bin );	
	//	CfbNX
	parser.createIndexEx();

	iprintf("novel parse end.\n");

	CFileSelect fileselect;

	CPage page;

	int page_index = 0;

	parser.getPageContentEx( page_index , page ); 
	memset( fb_main , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );
	page.printPage( fb_main, true );

	parser.getPageContentEx( page_index+1 , page ); 
	memset( fb_sub , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );
	page.printPage( fb_sub, false );


	bool key_pressed = false;
	touchPosition touch;

	bool is_console = false;
	videoSetModeSub(MODE_2_2D | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_2D | DISPLAY_SPR_2D_BMP_256);

	bool is_fileselect = false;
	int fselect_idx = 0;

	bool is_force_page_redraw = false;


	while(book_src != NULL) {
	
		scanKeys();
		touch=touchReadXY();
		int pressed = keysDown();	// buttons pressed this loop
		//int held = keysHeld();		// buttons currently held

		//if( !(pressed & KEY_TOUCH)
		if( pressed && key_pressed != true )
		{
			iprintf("touch or pressed.[%d]\n", keysHeld());

			int now_page_index = page_index;

			if( pressed & KEY_START )
			{
				if( is_console == true )
				{
					videoSetModeSub(MODE_2_2D | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_2D | DISPLAY_SPR_2D_BMP_256);
					is_console = false;
				}
				else 
				{
					videoSetModeSub( MODE_2_2D | DISPLAY_BG0_ACTIVE );
					is_console = true;
				}
			}

			if( pressed & KEY_LID )
			{
				powerOFF(POWER_ALL_2D);
			}

			if( pressed & KEY_SELECT )
			{
				if( is_fileselect == true )
				{
					is_force_page_redraw = true;
					is_fileselect = false;
				}
				else 
				{
					if( !strcmp(dir.current_path.c_str(), "") )
					{	//err
						iprintf( "dir initialize faild." );
					}
					else
					{
						fselect_idx = 0;

						memset( fb_main , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );
						fileselect.drawSelect( fb_main, fselect_idx, dir );

						memset( fb_sub , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );

						is_fileselect = true;
					}
				}
			}

			if( is_fileselect == true )
			{
				if( pressed & KEY_RIGHT )
				{
					fselect_idx -= 1;
				}

				if( pressed & KEY_LEFT )
				{
					fselect_idx += 1;
				}

				if( pressed & KEY_A )
				{

					if( dir.vec_files[fselect_idx].type == 1 )
					{
						const char * lname = dir.vec_files[fselect_idx].name_long.c_str();
						int lname_len = strlen(dir.vec_files[fselect_idx].name_long.c_str());
						u32 file_size = dir.vec_files[fselect_idx].size;

						if( 4 < lname_len )
						{
							if( !strcmp( ".txt", lname + lname_len - 4 )
								|| !strcmp( ".TXT", lname + lname_len - 4 ) )
							{
								if(  (MAX_FILE_SIZE - 1) < file_size )
								{
									iprintf( "over MAX_FILE_SIZE err.\n" );
								}
								else
								{
									char buff[1024];
									strcpy( buff, dir.current_path.c_str() );

									if( 0 < strlen( buff ) )
									{
										if( buff[strlen( buff ) - 1] != '/' )
										{
											strcat( buff, "/" );
										}

										strcat( buff, dir.vec_files[fselect_idx].name.c_str() );
										iprintf( "read txt[%d:%s]...\n", file_size, buff );


										FAT_FILE* p = FAT_fopen( buff, "r" );
										if( 0 <= p )
										{
											//if( is_set_internal_book == true ) { free( book_src ); }
											//book_src = (char *)malloc(file_size);

											if( book_src != NULL )
											{
												u32 read_size = 0;

												read_size = FAT_fread( book_src, 1, file_size, p );

												iprintf( "read size:%d\n" , read_size );

												book_src[read_size] = '\0';

												parser.setNobelData( book_src );
												iprintf("novel parsing...(sa:%x)\n", book_src );
												parser.createIndexEx();
												iprintf("novel parse end.\n");

												page_index = 0;

												is_fileselect = false;
												is_force_page_redraw = true;

												is_set_internal_book = false;

												//free( book_src );
											}
											else
											{
												iprintf( "malloc err.\n" );
											}

											FAT_fclose(p);
										}
										else
										{
											iprintf( "file open err.\n" );
										}
									}
								}
							}
						}
					}
					else if( dir.vec_files[fselect_idx].type == 2 )
					{
						char buff[1024];

						if( !strcmp( ".", dir.vec_files[fselect_idx].name.c_str() ) )
						{
						}
						else
						{
							if( !strcmp( "..", dir.vec_files[fselect_idx].name.c_str() ) )
							{
								strcpy( buff, dir.current_path.c_str() );
								iprintf( "chdir:%s\n", buff );
								
								if( 1 < strlen(buff) )
								{
									int pos = strlen(buff) - 1;
									while( buff[pos] != '/' )
									{
										buff[pos] = '\0';
										pos--;
									}

									if( 1 < pos )
									{
										buff[pos] = '\0';
									}
								}
							}
							else
							{
								strcpy( buff, dir.current_path.c_str() );

								if( 1 < strlen(buff) )
								{
									if( buff[strlen( buff ) - 1] != '/' )
									{
										strcat( buff, "/" );
									}
								}

								strcat( buff, dir.vec_files[fselect_idx].name.c_str() );
								iprintf( "chdir:%s\n", buff );
							}

							//fBNgύX
							if( dir.chdir( buff ) )
							{
								iprintf( " OK.\n" );

								for( vector<CFile_Info>::iterator p = dir.vec_files.begin() ; p != dir.vec_files.end() ; p++ ) {
									iprintf( "+%d t:%d n:%s l:%s\n", p->idx, p->type, p->name.c_str(), p->name_long.c_str() );
								}
							}
							else
								iprintf( " Err.\n" );

							fselect_idx = 0;
						}
					}
				}

				//ُindexԍ̕␳
				if( fselect_idx < 0 ) fselect_idx = 0;
				if( (signed)dir.vec_files.size() <= fselect_idx ) fselect_idx = dir.vec_files.size() - 1;

				memset( fb_main , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );
				fileselect.drawSelect( fb_main, fselect_idx, dir );
			}
			else
			{
				if( pressed & KEY_UP )
				{
					page_index += 2;
				}

				if( pressed & KEY_DOWN )
				{
					page_index -= 2;
				}

				if( pressed & KEY_TOUCH ){
					if( touch.px < (signed)(FONT_SIZE) )
					{
						//																						 01234567890123456789
						//	CNDSFont_Draw::Print( font_16, dest, FONT_HALF_SIZE * 9, SCREEN_HEIGHT - FONT_SIZE, "< +50 +10 -10 -50 >"  );
						int pager_offset = 0;
						signed int pager_dim[6][2] = {
							{ 0, 0 }, { 2, 4 }, { 6, 8 }, { 10, 12 }, { 14, 16 }, { 18, 18 }
						};

						for( int i = 0 ; i < 6 ; i++ )
						{
							pager_dim[i][0] = pager_dim[i][0] * FONT_HALF_SIZE + pager_offset;
							pager_dim[i][1] = pager_dim[i][1] * FONT_HALF_SIZE + FONT_HALF_SIZE + pager_offset;
						}

						int pager_index = 0;
						if( touch.py < pager_dim[pager_index][0] )
						{
						}
						else if( pager_dim[pager_index][0] <= touch.py && touch.py <= pager_dim[pager_index++][1] )
						{
							page_index = parser.getNumberOfTotalPage() - 1;
						}
						else if( pager_dim[pager_index][0] <= touch.py && touch.py <= pager_dim[pager_index++][1] )
						{
							page_index += 50;
						}
						else if( pager_dim[pager_index][0] <= touch.py && touch.py <= pager_dim[pager_index++][1] )
						{
							page_index += 10;
						}
						else if( pager_dim[pager_index][0] <= touch.py && touch.py <= pager_dim[pager_index++][1] )
						{
							page_index -= 10;
						}
						else if( pager_dim[pager_index][0] <= touch.py && touch.py <= pager_dim[pager_index++][1] )
						{
							page_index -= 50;
						}
						else if( pager_dim[pager_index][0] <= touch.py && touch.py <= pager_dim[pager_index++][1] )
						{
							page_index = 0;
						}
					}
					else
					{
						if( touch.py > (signed)(SCREEN_HEIGHT/2) ){
								iprintf(" page prev.\n");
								page_index -= 2;
						}else if( touch.py < (signed)(SCREEN_HEIGHT/2) ){
								iprintf(" page next.\n");
								page_index += 2;

						}
					}

				}

				//ُy[Wԍ̕␳
				if( page_index < 0 ) page_index = 0;
				if( parser.getNumberOfTotalPage() < page_index ) page_index = parser.getNumberOfTotalPage() - 1;
			}

			//y[W߂`攻
			if( now_page_index != page_index || is_force_page_redraw == true )
			{
				// set the generic sound parameters
				setGenericSound(	22050,	/* sample rate */
									127,	/* volume */
									64,		/* panning */
									3 );	/* sound format*/
				playGenericSound(page_wav_bin, page_wav_bin_size / 2);

				memset( fb_main , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );
				parser.getPageContentEx( page_index , page ); 
				page.printPage( fb_main, true );

				memset( fb_sub , 0x7FFFF , sizeof(uint16)*SCREEN_HEIGHT * SCREEN_WIDTH );
				parser.getPageContentEx( page_index+1 , page ); 
				page.printPage( fb_sub, false );

				is_force_page_redraw = false;
			}

			key_pressed = true;
		}

		if( !keysHeld() && key_pressed == true ){
			iprintf("key_pressed = false.\n");
			key_pressed = false;

			powerON(POWER_ALL_2D);
		}
	}

	free( book_src );
	return 0;
	
}
