#include "nobelparser.h"
#include "enum.h"
#include <string.h>


using namespace std;

#define ever (;;)
const char *split = "-------------------------------------------------------";
const char *crlf = "\x0D\x0A";
const char CR = 0x0D;
const char LF = 0x0A;


//------------------------------------

//ndsfont.*̊֌ŴŁACODE_SJISɂĂ삵ȂłB
#define CODE_EUC

#ifdef CODE_SJIS
	#define IS_ZENKAKU(c)	((((unsigned char)c) >= 0x81) && ((((unsigned char)c) <= 0x9f) || ((((unsigned char)c) >= 0xe0) && (((unsigned char)c) <= 0xfd))))
	#define IS_KANJI(c) ((((unsigned char)c) >= 0x88) && ((((unsigned char)c) <= 0x9f) || ((((unsigned char)c) >= 0xe0) && (((unsigned char)c) <= 0xfd))))
	const char *left_double_parentheses = "\x81\x73";	//	for s_jis
	const char *right_double_parentheses ="\x81\x74";	//  for s_jis
	const char *vertical_bar = "\x81\x62";				//	for s_jis

#else 
	#ifdef CODE_EUC
		#define	IS_ZENKAKU(c) ((unsigned char)c >= 0xA0)
		#define IS_KANJI(c) ((unsigned char)c >= 0xB0)
		const char *left_double_parentheses = "\xa1\xd4";	//	for s_jis
		const char *right_double_parentheses ="\xa1\xd5";	//  for s_jis
		const char *vertical_bar = "\xa1\xc3";				//	for s_jis
	#else
		#error invalid pratform
	#endif
#endif

#define diff2(p,q) ((unsigned char)*p==(unsigned char)*q && (unsigned char)*(p+1) == (unsigned char)*(q+1))

//	s܂ł擾
void get_line( std::string &s , const char *&p ) {
	for( ; *p != CR && *p !=LF ;p++ ) {
		s += *p;
	}
}

//	sǂݔ΂
void skip_lf( const char *&p ) {
	for( ; *p == CR || *p == LF || *p =='-' ;p++ ) {
	}
}

//	wSp\܂œǂݔ΂āAwSp̎܂Ń|C^ړ
void skip_char2( const char *&p , const char *q ,std::string &str) {
	char c[3]; c[2] = 0; 
	
	
	str = "";
	for ever {
		if( IS_ZENKAKU(*p) ) {
			if( diff2( p , q ) ){
				p += 2;
				return;
			}
			memcpy( &c , p , 2 );
			str += c;
			p +=2;
		}
		else{
			str += (char )(*p);
			p++;
		}
	}
}


//	kĊJEg
int count_kanji( const char *p , const char *top ) {
	int count = 0;
	p -=2;
	for( ; p - top !=0; p -= 2 ){
		if( IS_KANJI( *p ) == 1 && diff2( p , vertical_bar ) == false ) {
			count++;		
		}
		else {
			break;
		}
	}
	return count;
}

	
//-----------------------------------------------------------
//	class CNobelParser
//-----------------------------------------------------------

CNobelParser::CNobelParser( const char *src ) : nobel_body( src )
{
}

bool CNobelParser::is_kinsoku_char( u16 char_code )
{
	bool res = false;

	static const u16 kinsoku_chars[] = 
	{
		//󕶌ɂ̓LńAȂƎB
		//ndsfont.h̕Ƃ͏̗RŋʉłȂ̂ŗv
		//JbRńAJ͓o^ȂB̂݋֑B
		0xa1a2,0xa1a3,0xa1a4,0xa1a5,0xa1bc,0xa1bd,0xa1be,
		0xa1c1,0xa1c2,0xa1c4,0xa1c5,
		0xa1cb,0xa1cd,0xa1d1,0xa1d3,0xa1d7,0xa1d9,0xa1db
	};

	int i;
	for( i = 0 ; i < (int)(sizeof(kinsoku_chars) / 2) ; i++ )
	{
		if( kinsoku_chars[i] == char_code )
		{
			iprintf("[sc:%x]", char_code); 
			res = true;
			break;
		}
	}

	return res;
}

void CNobelParser::setNobelData( const char *src)
{
	nobel_body = src;
	page_index.clear();
}

bool CNobelParser::createIndexEx(){
	const char *p = nobel_body;
	nobel_body_size = strlen( nobel_body );

	//	^Cg擾
	get_line( nobel_title , p );
	skip_lf( p );
	//	Ҏ擾
	get_line( nobel_author , p );
	skip_lf( p );

	//	wb_[ǂݔ΂
	p = strstr( nobel_body , split ); 
	if( p == NULL ) return false;
	p = strstr( p , split );
	if( p == NULL ) return false;	
	p++;
	p = strstr( p , split );
	skip_lf( p );

	Ruby r;
	//	page top
	page_index.push_back( (int)(p - &nobel_body[0]) );

	int now_x_pos = 0;
	int now_y_pos = 0;
	const int x_max = HEIGHT_STR_MAX - 1;
	const int y_max = WIDTH_STR_MAX;
	
	for( ; (size_t)( p- &nobel_body[0]) != nobel_body_size ; ) {
		//	Sp
		if( IS_ZENKAKU(*p) ) {
			//	
			if( diff2( p , left_double_parentheses ) ) {
				//	ǂ݉̃XLbv
				skip_char2( p , left_double_parentheses  , r.ruby  );
				skip_char2( p , right_double_parentheses , r.ruby  );
			}
			else if( diff2( p ,vertical_bar ) ){
				//@ǂ݉wo[̃XLbv
				p += 2;
			}
			//	ʏSp
			else{
				now_x_pos += 1;
				p += 2;
			}
		}
		//	s
		else if( *p == CR || *p == LF ){
			if( *p == LF )
			{
				now_y_pos += 1;	
				now_x_pos = 0;
			}
			p += 1;
		}
		//	p
		else {
 			now_x_pos += 1;
			p++;
		}
		//	sJグ
		if( x_max <= now_x_pos ){
			u16 char_code = 0;
			if( IS_ZENKAKU(*p) )
			{
				char_code = (*p) << 8;
				char_code += *(p+1);
			}

			if( (x_max+1) <= now_x_pos || ( x_max == now_x_pos && is_kinsoku_char(char_code) == false) )
			{
				now_y_pos += 1;
				now_x_pos = 0;
			}
		}
		if( now_y_pos == y_max ){
			page_index.push_back( (int)(p - &nobel_body[0]) );
			now_y_pos = now_x_pos = 0;
		}
	}
	return true;

}	
	

bool CNobelParser::getPageContentEx( unsigned int index , CPage &page ) {
	
	page.initPage(); 
	page.page_no = index;
	
	if( page_index.size() <= index )
		return false;

	const char *p = nobel_body;
	p += page_index[ index ];

	//	1y[W`
	char c[3];	c[2] = 0;

	std::string str;
	str.reserve( HEIGHT_STR_MAX * 2 ); 
	bool skipped = false;
	
	int now_x_pos = 0;
	int now_y_pos = 0;
	const int x_max = HEIGHT_STR_MAX - 1;
	const int y_max = WIDTH_STR_MAX;

	for( ; (size_t)(p - &nobel_body[0]) != nobel_body_size ; ) {
		//	Sp
		if( IS_ZENKAKU(*p) ) {
					
			//	ǂ݉
			if( diff2( p , left_double_parentheses ) ) {
				//	r֘ÃR[h
				{
					//	Ȃ̂
					int cnt_kanji = count_kanji( p , &nobel_body[0] );	
					//	ǂ݉Ȃ̂
					Ruby r;
					//	ǂ݉̃XLbv
					skip_char2( p , left_double_parentheses  , r.ruby  );
					skip_char2( p , right_double_parentheses , r.ruby  );

					int ruby_num = strlen( r.ruby.c_str() );
					
					r.x     = (9-page.vec_body.size()) * 24 + 16; 
					r.y     = now_x_pos*16 -(8*(ruby_num/2));
					if(r.y < 0){
						r.x = (9-(page.vec_body.size()-1)) * 24 + 16; ;
						r.y = 192 -(8*(ruby_num/2));
					}
					r.y = r.y < 0 ? 0:r.y;

					r.px = page.vec_body.size();
					r.py = now_x_pos - cnt_kanji;
					if( r.py < 0 )
					{
						r.px--;
						r.py = now_x_pos - cnt_kanji;
					}

					page.vec_ruby.push_back( r );

					skipped = true;
				}
			}
			else if( diff2( p ,vertical_bar ) )
			{	//@ǂ݉wo[̃XLbv
				p += 2;
				skipped = true;
			}
			else
			{	//	ʏSp
				memcpy( &c , p , 2 );
				str += c;
				now_x_pos += 1;
				p += 2;		
			}
		}
		//	s
		else if( *p == CR || *p == LF ){
			if( *p == CR )
			{
				skipped = true;
			}
			else
			{
				now_y_pos += 1;	
				now_x_pos = 0;
			}
			p += 1;
		}
		//	p
		else {
			memcpy( &c , p , 1 ); c[1]=0;
			str += c; 
 			now_x_pos += 1;
			p++;
		}

		//	sJグ
		if( x_max <= now_x_pos ){
			u16 char_code = 0;
			if( IS_ZENKAKU(*p) )
			{
				char_code = (*p) << 8;
				char_code += *(p+1);
			}

			if( (x_max+1) <= now_x_pos || ( x_max == now_x_pos && is_kinsoku_char(char_code) == false) )
			{
				now_y_pos += 1;
				now_x_pos = 0;
			}
		}

		if( now_x_pos == 0 && now_y_pos >= 1 && skipped == false)
		{
			page.vec_body.push_back( str );  
			str.clear();  
		}
		skipped = false;
		if( now_y_pos == y_max ){
			
			break;
		}
	}

	return true;
}
