﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NDac.Keys
{
	/// <summary>
	/// 名称あいまい検索キーを表します。
	/// </summary>
	public class NameLikeSelectKey : Key
	{
		private string			_name;
		private MatchingType	_matching;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="name">名称</param>
		public NameLikeSelectKey( string name ) : this( name, MatchingType.Prefix )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="name">名称</param>
		/// <param name="matching">キーワード検索の一致タイプ</param>
		public NameLikeSelectKey( string name, MatchingType matching )
		{
			this._name		= name;

			this._matching	= matching;
		}

		/// <summary>
		/// 名称を表します。
		/// </summary>
		public string Name
		{
			get
			{
				return( this._matching.ToKeyword( this._name ) );
			}
		}
	}
}
