using System;
using System.Data;
using NDac.Datas;
using NDac.Keys;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;

namespace NDac.Modules
{
	/// <summary>
	/// IdNumberingテーブルのテーブルモジュールを表します。
	/// </summary>
	public partial class IdNumberingModule : TableModule< IdNumberingKey, IdNumberingEntity, IdNumberingDTO >
	{
		private const string TABLE_NAME = "IdNumbering";

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="table">データテーブル</param>
		public IdNumberingModule( DataTable table )
			: base( table )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="ds">データセット</param>
		public IdNumberingModule( DataSet ds )
			: base( ds, TABLE_NAME )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public IdNumberingModule( DataSetHolder holder )
			: base( holder, TABLE_NAME )
		{
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( TABLE_NAME );
			}
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="tableName">TableName</param>
		/// <returns>エンティティ/returns>
		public IdNumberingEntity this[ string tableName ]
		{
			get
			{
				return( this[ new IdNumberingKey( tableName ) ] );
			}
		}

		/// <summary>
		/// 新しい行のエンティティを作成します。
		/// </summary>
		/// <param name="tableName">TableName</param>
		/// <returns>新しい行のエンティティ</returns>
		public IdNumberingEntity NewEntity( string tableName )
		{
			return( this.NewEntity( new IdNumberingKey( tableName ) ) );
		}

		/// <summary>
		/// 新しい行のエンティティを作成します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>新しい行のエンティティ</returns>
		protected override IdNumberingEntity NewEntity( IdNumberingKey primaryKey )
		{
			DataRow row = base.NewRow();

			row[ "TableName" ] = primaryKey.TableName;

			this._table.Rows.Add( row );

			return( ( IdNumberingEntity )this.ToEntity( row ) );
		}

		/// <summary>
		/// データ変換オブジェクトをセットします。データ変換オブジェクトのキーに一致するデータが存在する場合はUpdate，存在しない場合はInsertします。データベースに反映する時はDataSetHolderのUpdate()を呼び出して下さい。
		/// </summary>
		/// <param name="dto">データ変換オブジェクト</param>
		public override void Set( IdNumberingDTO dto )
		{
			if( this[ dto.GetPrimaryKey() ] == null )
			{
				this.Insert( dto );
			}
			else
			{
				this[ dto.GetPrimaryKey() ].Copy( dto );
			}
		}

		/// <summary>
		/// 行データをエンティティに変換します。
		/// </summary>
		/// <param name="row">データ行</param>
		/// <returns>エンティティ</returns>
		protected internal override IdNumberingEntity ToEntity( DataRow row )
		{
			if( row != null )
			{
				return( new IdNumberingEntity( row ) );
			}
			else
			{
				return( null );
			}
		}

		/// <summary>
		/// SELECT実行時のフィルタ処理式に変換します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>フィルタ処理式</returns>
		protected override string ToFilterExpression( IdNumberingKey primaryKey )
		{
			return( string.Format( "( TableName = '{0}' )", primaryKey.TableName ) );
		}

		/// <summary>
		/// データセットにテーブルスキーマを充填します。
		/// </summary>
		/// <param name="ds">データセット</param>
		public static void FillSchema( DataSet ds )
		{
			TableModule< IdNumberingKey, IdNumberingEntity, IdNumberingDTO >.FillSchema( TABLE_NAME, ds );
		}

		/// <summary>
		/// データテーブルにテーブルスキーマを充填します。
		/// </summary>
		/// <param name="table">データテーブル</param>
		public static void FillSchema( DataTable table )
		{
			TableModule< IdNumberingKey, IdNumberingEntity, IdNumberingDTO >.FillSchema( TABLE_NAME, table );
		}
	}
}
