using System;
using System.ComponentModel;
using System.Data;

namespace NDac.Modules.Extensions
{
	/// <summary>
	/// データテーブルのサイトを表します。
	/// </summary>
	class DataTableSite : ISite
	{
		private DataTableComponent	_component;
		private DataTableContainer	_container;
		private string				_name;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="table">データテーブル</param>
		public DataTableSite( DataTable table )
		{
			this._container = new DataTableContainer();

			this._component = new DataTableComponent( table );
		}

		/// <summary>
		/// データテーブルのコンポーネントを表します。
		/// </summary>
		public DataTableComponent Component
		{
			get
			{
				return( this._component );
			}
		}

		#region ISite メンバ

		/// <summary>
		/// コンポーネントを表します。
		/// </summary>
		IComponent ISite.Component
		{
			get
			{
				return( this._component );
			}
		}

		/// <summary>
		/// コンテナを表します。
		/// </summary>
		public IContainer Container
		{
			get
			{
				return( this._container );
			}
		}

		/// <summary>
		/// コンポーネントが現在デザインモードであるかを表します。常にfalseが返ります。
		/// </summary>
		public bool DesignMode
		{
			get
			{
				return( false );
			}
		}

		/// <summary>
		/// サイト名を表します。
		/// </summary>
		public string Name
		{
			get
			{
				return( this._name );
			}
			set
			{
				this._name = value;
			}
		}

		#endregion

		#region IServiceProvider メンバ

		/// <summary>
		/// 指定した型のサービスオブジェクトを取得します。
		/// </summary>
		/// <param name="serviceType">サービスの型</param>
		/// <returns>常にnullが返ります。</returns>
		public object GetService( Type serviceType )
		{
			return( null );
		}

		#endregion
	}
}
