using System;
using System.Data;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.Attributes;

namespace NDac.Modules.Entities
{
	/// <summary>
	/// Bookテーブルのエンティティを表します。
	/// </summary>
	public partial class BookEntity : Entity< BookKey >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="row">データテーブル</param>
		public BookEntity( DataRow row )
			: base( row )
		{
		}

		/// <summary>
		/// Idを表します。
		/// </summary>
		[ PrimaryKey( "Id", typeof( long ) ) ]
		public long Id
		{
			get
			{
				return( ( this._row[ "Id" ] == DBNull.Value ) ? default( long ) : ( long )this._row[ "Id" ] );
			}
			set
			{
				this._row[ "Id" ] = value;
			}
		}

		/// <summary>
		/// Titleを表します。
		/// </summary>
		public string Title
		{
			get
			{
				return( ( this._row[ "Title" ] == DBNull.Value ) ? default( string ) : StringCutDowner.Variable( ( string )this._row[ "Title" ], 50 ) );
			}
			set
			{
				this._row[ "Title" ] = ( value == null ? ( object )DBNull.Value : StringCutDowner.Variable( value, 50 ) );
			}
		}

		/// <summary>
		/// Isbnを表します。
		/// </summary>
		public long Isbn
		{
			get
			{
				return( ( this._row[ "Isbn" ] == DBNull.Value ) ? default( long ) : ( long )this._row[ "Isbn" ] );
			}
			set
			{
				this._row[ "Isbn" ] = value;
			}
		}

		/// <summary>
		/// Priceを表します。
		/// </summary>
		public int Price
		{
			get
			{
				return( ( this._row[ "Price" ] == DBNull.Value ) ? default( int ) : ( int )this._row[ "Price" ] );
			}
			set
			{
				this._row[ "Price" ] = value;
			}
		}

		/// <summary>
		/// AuthorIdを表します。
		/// </summary>
		public int AuthorId
		{
			get
			{
				return( ( this._row[ "AuthorId" ] == DBNull.Value ) ? default( int ) : ( int )this._row[ "AuthorId" ] );
			}
			set
			{
				this._row[ "AuthorId" ] = value;
			}
		}

		/// <summary>
		/// PublisherIdを表します。
		/// </summary>
		public int PublisherId
		{
			get
			{
				return( ( this._row[ "PublisherId" ] == DBNull.Value ) ? default( int ) : ( int )this._row[ "PublisherId" ] );
			}
			set
			{
				this._row[ "PublisherId" ] = value;
			}
		}

		/// <summary>
		/// エンティティの内容をコピーします。この操作は値のみのコピーです。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		public void Copy( BookEntity source )
		{
			base.Copy( source );
		}

		/// <summary>
		/// プライマリキーを取得します。
		/// </summary>
		/// <returns>プライマリキー</returns>
		protected override BookKey ToPrimaryKey()
		{
			return( new BookKey( this.Id ) );
		}
	}
}
