using System;
using System.Data;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.Attributes;

namespace NDac.Modules.Entities
{
	/// <summary>
	/// Authorテーブルのエンティティを表します。
	/// </summary>
	public partial class AuthorEntity : Entity< AuthorKey >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="row">データテーブル</param>
		public AuthorEntity( DataRow row )
			: base( row )
		{
		}

		/// <summary>
		/// Idを表します。
		/// </summary>
		[ PrimaryKey( "Id", typeof( long ) ) ]
		public long Id
		{
			get
			{
				return( ( this._row[ "Id" ] == DBNull.Value ) ? default( long ) : ( long )this._row[ "Id" ] );
			}
			set
			{
				this._row[ "Id" ] = value;
			}
		}

		/// <summary>
		/// Nameを表します。
		/// </summary>
		public string Name
		{
			get
			{
				return( ( this._row[ "Name" ] == DBNull.Value ) ? default( string ) : StringCutDowner.Variable( ( string )this._row[ "Name" ], 100 ) );
			}
			set
			{
				this._row[ "Name" ] = ( value == null ? ( object )DBNull.Value : StringCutDowner.Variable( value, 100 ) );
			}
		}

		/// <summary>
		/// Sexを表します。
		/// </summary>
		public int Sex
		{
			get
			{
				return( ( this._row[ "Sex" ] == DBNull.Value ) ? default( int ) : ( int )this._row[ "Sex" ] );
			}
			set
			{
				this._row[ "Sex" ] = value;
			}
		}

		/// <summary>
		/// エンティティの内容をコピーします。この操作は値のみのコピーです。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		public void Copy( AuthorEntity source )
		{
			base.Copy( source );
		}

		/// <summary>
		/// プライマリキーを取得します。
		/// </summary>
		/// <returns>プライマリキー</returns>
		protected override AuthorKey ToPrimaryKey()
		{
			return( new AuthorKey( this.Id ) );
		}
	}
}
