using System;
using System.Data;
using NDac.Datas;
using NDac.Keys;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;

namespace NDac.Modules
{
	/// <summary>
	/// Authorテーブルのテーブルモジュールを表します。
	/// </summary>
	public partial class AuthorModule : TableModule< AuthorKey, AuthorEntity, AuthorDTO >
	{
		private const string TABLE_NAME = "Author";

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="table">データテーブル</param>
		public AuthorModule( DataTable table )
			: base( table )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="ds">データセット</param>
		public AuthorModule( DataSet ds )
			: base( ds, TABLE_NAME )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public AuthorModule( DataSetHolder holder )
			: base( holder, TABLE_NAME )
		{
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( TABLE_NAME );
			}
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>エンティティ/returns>
		public AuthorEntity this[ long id ]
		{
			get
			{
				return( this[ new AuthorKey( id ) ] );
			}
		}

		/// <summary>
		/// 新しい行のエンティティを作成します。
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>新しい行のエンティティ</returns>
		public AuthorEntity NewEntity( long id )
		{
			return( this.NewEntity( new AuthorKey( id ) ) );
		}

		/// <summary>
		/// 新しい行のエンティティを作成します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>新しい行のエンティティ</returns>
		protected override AuthorEntity NewEntity( AuthorKey primaryKey )
		{
			DataRow row = base.NewRow();

			row[ "Id" ] = primaryKey.Id;

			this._table.Rows.Add( row );

			return( ( AuthorEntity )this.ToEntity( row ) );
		}

		/// <summary>
		/// データ変換オブジェクトをセットします。データ変換オブジェクトのキーに一致するデータが存在する場合はUpdate，存在しない場合はInsertします。データベースに反映する時はDataSetHolderのUpdate()を呼び出して下さい。
		/// </summary>
		/// <param name="dto">データ変換オブジェクト</param>
		public override void Set( AuthorDTO dto )
		{
			if( this[ dto.GetPrimaryKey() ] == null )
			{
				this.Insert( dto );
			}
			else
			{
				this[ dto.GetPrimaryKey() ].Copy( dto );
			}
		}

		/// <summary>
		/// 行データをエンティティに変換します。
		/// </summary>
		/// <param name="row">データ行</param>
		/// <returns>エンティティ</returns>
		protected internal override AuthorEntity ToEntity( DataRow row )
		{
			if( row != null )
			{
				return( new AuthorEntity( row ) );
			}
			else
			{
				return( null );
			}
		}

		/// <summary>
		/// SELECT実行時のフィルタ処理式に変換します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>フィルタ処理式</returns>
		protected override string ToFilterExpression( AuthorKey primaryKey )
		{
			return( string.Format( "( Id = {0} )", primaryKey.Id ) );
		}

		/// <summary>
		/// データセットにテーブルスキーマを充填します。
		/// </summary>
		/// <param name="ds">データセット</param>
		public static void FillSchema( DataSet ds )
		{
			TableModule< AuthorKey, AuthorEntity, AuthorDTO >.FillSchema( TABLE_NAME, ds );
		}

		/// <summary>
		/// データテーブルにテーブルスキーマを充填します。
		/// </summary>
		/// <param name="table">データテーブル</param>
		public static void FillSchema( DataTable table )
		{
			TableModule< AuthorKey, AuthorEntity, AuthorDTO >.FillSchema( TABLE_NAME, table );
		}
	}
}
