using System;
using NDac.Datas;
using NDac.Gateways;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;

namespace NDac.RemoteFacades
{
	/// <summary>
	/// Publisherテーブルのリモートファサードを表します。
	/// </summary>
	public class PublisherFacade : RemoteFacade< PublisherKey, PublisherGateway, PublisherEntity, PublisherDTO, PublisherModule >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public PublisherFacade() : base( new DataSetHolder() )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		public PublisherFacade( string connectionString ) : base( new DataSetHolder( connectionString ) )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public PublisherFacade( DataSetHolder holder ) : base( holder )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="loadKey">充填するキー</param>
		public PublisherFacade( IKey loadKey ) : base( new DataSetHolder(), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		/// <param name="loadKey">充填するキー</param>
		public PublisherFacade( string connectionString, IKey loadKey ) : base( new DataSetHolder( connectionString ), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <param name="loadKey">充填するキー</param>
		public PublisherFacade( DataSetHolder holder, IKey loadKey ) : base( holder, loadKey )
		{
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>エンティティ</returns>
		public PublisherEntity this[ long id ]
		{
			get
			{
				return( this[ new PublisherKey( id ) ] );
			}
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( PublisherGateway.AccessTableName );
			}
		}

		/// <summary>
		/// 新しいテーブルデータゲートウェイを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルデータゲートウェイ</returns>
		protected override PublisherGateway NewGateway( DataSetHolder holder )
		{
			return( new PublisherGateway( holder ) );
		}

		/// <summary>
		/// 新しいテーブルモジュールを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルモジュール</returns>
		protected override PublisherModule NewModule( DataSetHolder holder )
		{
			return( new PublisherModule( holder ) );
		}
	}
}
