using System;
using NDac.Datas;
using NDac.Gateways;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;

namespace NDac.RemoteFacades
{
	/// <summary>
	/// Authorテーブルのリモートファサードを表します。
	/// </summary>
	public class AuthorFacade : RemoteFacade< AuthorKey, AuthorGateway, AuthorEntity, AuthorDTO, AuthorModule >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public AuthorFacade() : base( new DataSetHolder() )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		public AuthorFacade( string connectionString ) : base( new DataSetHolder( connectionString ) )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public AuthorFacade( DataSetHolder holder ) : base( holder )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="loadKey">充填するキー</param>
		public AuthorFacade( IKey loadKey ) : base( new DataSetHolder(), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		/// <param name="loadKey">充填するキー</param>
		public AuthorFacade( string connectionString, IKey loadKey ) : base( new DataSetHolder( connectionString ), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <param name="loadKey">充填するキー</param>
		public AuthorFacade( DataSetHolder holder, IKey loadKey ) : base( holder, loadKey )
		{
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>エンティティ</returns>
		public AuthorEntity this[ long id ]
		{
			get
			{
				return( this[ new AuthorKey( id ) ] );
			}
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( AuthorGateway.AccessTableName );
			}
		}

		/// <summary>
		/// 新しいテーブルデータゲートウェイを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルデータゲートウェイ</returns>
		protected override AuthorGateway NewGateway( DataSetHolder holder )
		{
			return( new AuthorGateway( holder ) );
		}

		/// <summary>
		/// 新しいテーブルモジュールを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルモジュール</returns>
		protected override AuthorModule NewModule( DataSetHolder holder )
		{
			return( new AuthorModule( holder ) );
		}
	}
}
