using System;
using System.Data;
using NDac.Datas;

namespace NDac.Modules
{
	/// <summary>
	/// 遅延初期化子を表します。
	/// </summary>
	class LazyInitializer
	{
		private string			_tableName;
		private DataSet			_ds;
		private DataSetHolder	_holder;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="ds">データセット</param>
		/// <param name="tableName">テーブル名</param>
		public LazyInitializer( DataSet ds, string tableName )
		{
			this._ds = ds;

			this._tableName = tableName;
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <param name="tableName">テーブル名</param>
		public LazyInitializer( DataSetHolder holder, string tableName )
		{
			this._holder = holder;

			this._tableName = tableName;
		}

		/// <summary>
		/// 初期化します。
		/// </summary>
		/// <returns>データテーブル</returns>
		public DataTable Initialize()
		{
			DataTable table = null;

			if( this._ds != null )
			{
				table = this._ds.Tables[ this._tableName ];
			}
			else if( this._holder != null )
			{
				table = this._holder[ this._tableName ];
			}

			if( table != null )
			{
				return( table );
			}
			else
			{
				throw( new LazyInitializeException( this._tableName + "よりデータ読み込みに失敗しました。" ) );
			}
		}
	}
}
