using System;

namespace NDac.Modules.Entities
{
	/// <summary>
	/// エンティティの値検証者を表します。
	/// </summary>
	static class EntityValueVerifier
	{
		/// <summary>
		/// ハッシュコードを取得します。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		/// <returns>ハッシュコード</returns>
		public static int GetHashCode( IEntity entity )
		{
			int hashCode = 0;

			int i = 0;

			if( ( entity.Row != null ) && ( !entity.IsDeleted() ) )
			{
				foreach( object value in entity.Row.ItemArray )
				{
					i++;

					hashCode ^= ( value.GetHashCode() + i.GetHashCode() );
				}
			}

			return( hashCode );
		}

		/// <summary>
		/// エンティティ１とエンティティ２の値が等しいかを判定します。
		/// </summary>
		/// <param name="entity1">エンティティ１</param>
		/// <param name="entity2">エンティティ２</param>
		/// <returns>エンティティ１とエンティティ２の値が等しい場合trueを返します。</returns>
		public static bool IsEqualValues( object entity1, object entity2 )
		{
			if( HasNullValue( entity1, entity2 ) )
			{
				return( IsNullValueAll( entity1, entity2 ) );
			}
			else
			{
				if( entity1.GetType() != entity2.GetType() )
				{
					return( false );
				}
				else if( ( entity1 is IEntity ) && ( entity2 is IEntity ) )
				{
					//TODO:RowStateを考慮する必要あり。
					return( IsEqualRowValues( ( IEntity )entity1, ( IEntity )entity2 ) );
				}
				else
				{
					return( false );
				}
			}
		}

		/// <summary>
		/// エンティティ１,エンティティ２の何れかがnull値を持っているかを判定します。
		/// </summary>
		/// <param name="entity1">エンティティ１</param>
		/// <param name="entity2">エンティティ２</param>
		/// <returns>エンティティ１,エンティティ２の何れかがnull値を持っている場合trueを返します。</returns>
		public static bool HasNullValue( object entity1, object entity2 )
		{
			return( ( entity1 == null ) || ( entity2 == null ) );
		}

		/// <summary>
		/// エンティティ１,エンティティ２共にnull値であるかを判定します。
		/// </summary>
		/// <param name="entity1">エンティティ１</param>
		/// <param name="entity2">エンティティ２</param>
		/// <returns>エンティティ１,エンティティ２共にnull値である場合trueを返します。</returns>
		public static bool IsNullValueAll( object entity1, object entity2 )
		{
			return( ( entity1 == null ) && ( entity2 == null ) );
		}

		/// <summary>
		/// オブジェクト１とオブジェクト２のプロパティ値が等しいかを判定します。
		/// </summary>
		/// <param name="obj1">オブジェクト１</param>
		/// <param name="obj2">オブジェクト２</param>
		/// <returns>オブジェクト１とオブジェクト２のプロパティ値が等しい場合trueを返します。</returns>
		private static bool IsEqualRowValues( IEntity entity1, IEntity entity2 )
		{
			for( int i = 0; i < entity1.Row.ItemArray.Length; i++ )
			{
				object value1 = entity1.Row[ i ];

				object value2 = entity2.Row[ i ];

				if( !value1.Equals( value2 ) )
				{
					return( false );
				}
			}

			return( true );
		}
	}
}
