using System;
using NDac.Keys;
using NDac.Modules.Entities;
using NDac.RemoteFacades;

namespace NDac.IdentityMappings
{
	/// <summary>
	/// Publisherテーブルのファインダを表します。
	/// </summary>
	public partial class PublisherFinder
	{
		private static PublisherFinder _instance;
		private IdentityMap< PublisherKey, PublisherEntity > _identityMap = new IdentityMap< PublisherKey, PublisherEntity >();

		/// <summary>
		/// コンストラクタ
		/// </summary>
		private PublisherFinder()
		{
			this.Constructed();
		}

		/// <summary>
		/// インスタンスを表します。
		/// </summary>
		public static PublisherFinder Instance
		{
			get
			{
				if( _instance == null )
				{
					_instance = new PublisherFinder();
				}

				return( _instance );
			}
		}

		/// <summary>
		/// キー情報に一致するPublisherテーブルのエンティティを取得します。
		/// <para>まず一意マッピングを検索し、一意マッピングに存在する値を返します。</para>
		/// <para>一意マッピングに存在しない場合はFurnaceModelテーブルを検索し、Publisherテーブルに存在する値を返します。</para>
		/// <para>一意マッピング，Publisherテーブルのいずれにも存在しない場合はnullを返します。</para>
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>Publisherテーブルのエンティティ</returns>
		public PublisherEntity Find( long id )
		{
			return( this.Find( new PublisherKey( id ) ) );
		}

		/// <summary>
		/// キー情報に一致するPublisherテーブルのエンティティを取得します。
		/// <para>まず一意マッピングを検索し、一意マッピングに存在する値を返します。</para>
		/// <para>一意マッピングに存在しない場合はPublisherテーブルを検索し、Publisherテーブルに存在する値を返します。</para>
		/// <para>一意マッピング，Publisherテーブルのいずれにも存在しない場合はnullを返します。</para>
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>Publisherテーブルのエンティティ</returns>
		public PublisherEntity Find( PublisherKey primaryKey )
		{
			if( !this._identityMap.ContainsKey( primaryKey ) )
			{
				PublisherFacade facade = new PublisherFacade();

				facade.LoadBy( primaryKey );

				if( 0 < facade.Count )
				{
					this._identityMap.Add( primaryKey, facade[ primaryKey ] );
				}
				else
				{
					this._identityMap.Add( primaryKey, null );
				}
			}

			this.Finded( primaryKey, this._identityMap[ primaryKey ] );

			return( this._identityMap[ primaryKey ] );
		}

		/// <summary>
		/// テーブルより全データを充填し、一意マッピングに登録します。
		/// </summary>
		public void LoadAll()
		{
			PublisherFacade facade = new PublisherFacade();

			facade.LoadAll();

			if( this._identityMap.Count != facade.Count )
			{
				foreach( PublisherEntity entity in facade )
				{
					if( !this._identityMap.ContainsKey( entity.GetPrimaryKey() ) )
					{
						this._identityMap.Add( entity.GetPrimaryKey(), entity );
					}
				}
			}
		}

		/// <summary>
		/// 一意マッピングに存在する全ての値をクリアします。
		/// </summary>
		public void Clear()
		{
			this._identityMap.Clear();
		}

		/// <summary>
		/// コンストラクタが呼び出された後にコールされます。
		/// </summary>
		partial void Constructed();

		/// <summary>
		/// Find終了処理を実行します。
		/// </summary>
		/// <param name="key">キー</param>
		/// <param name="entity">Find処理結果のエンティティ</param>
		partial void Finded( PublisherKey key, PublisherEntity entity );
	}
}
