using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using NDac.Datas;
using NDac.Keys;

namespace NDac.Gateways
{
	/// <summary>
	/// テーブルデータゲートウェイのインターフェイスを表します。
	/// </summary>
	public interface ITableDataGateway
	{
		/// <summary>
		/// データセットホルダーを表します。
		/// </summary>
		DataSetHolder Holder{ get; }

		/// <summary>
		/// データテーブルを表します。
		/// </summary>
		DataTable Table{ get; }

		/// <summary>
		/// テーブル名を表します。
		/// </summary>
		string TableName{ get; }

		/// <summary>
		/// キー情報に一致したレコードが存在するかを判定します。
		/// </summary>
		/// <param name="key"></param>
		/// <returns>キー情報に一致したレコードが存在する場合trueを返します。</returns>
		bool HasValue( IKey key );

		/// <summary>
		/// WHERE条件でレコードが存在するか判定します。
		/// </summary>
		/// <param name="whereClause">WHERE節</param>
		/// <returns>WHERE条件に合うレコードが存在する場合trueを返します。</returns>
		bool HasWhere( string whereClause );

		/// <summary>
		/// テーブルより全データを充填します。
		/// </summary>
		void LoadAll();

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="key">キー</param>
		void LoadBy( IKey key );

		/// <summary>
		/// テーブルよりスキーマ情報を充填します。
		/// </summary>
		void LoadSchema();

		/// <summary>
		/// WHERE条件でデータを充填します。
		/// </summary>
		/// <param name="whereClause">WHERE節</param>
		void LoadWhere( string whereClause );

		/// <summary>
		/// キー情報に一致したデータを追加充填します。
		/// </summary>
		/// <param name="key">キー</param>
		void MoreLoadBy( IKey key );
	}

	/// <summary>
	/// テーブルデータゲートウェイのインターフェイスを表します。
	/// </summary>
	/// <typeparam name="TKey">キーの型</typeparam>
	public interface ITableDataGateway< TKey > : ITableDataGateway
		where TKey : class, IKey
	{
		/// <summary>
		/// キー情報に一致したレコードが存在するかを判定します。
		/// </summary>
		/// <param name="key"></param>
		/// <returns>キー情報に一致したレコードが存在する場合trueを返します。</returns>
		bool HasValue( TKey key );

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="key">キー</param>
		void LoadBy( TKey key );

		/// <summary>
		/// キー情報に一致したデータを追加充填します。
		/// </summary>
		/// <param name="key">キー</param>
		void MoreLoadBy( TKey key );
	}
}
