using System;
using System.ComponentModel;

namespace NDac.Datas.Extensions
{
	/// <summary>
	/// データセットホルダーのコンポーネントを表します。
	/// </summary>
	class DataSetHolderComponent : IComponent
	{
		private ISite			_site;
		private DataSetHolder	_holder;
		private bool			_isDisposed;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public DataSetHolderComponent( DataSetHolder holder )
		{
			this._holder = holder;

			this._isDisposed = false;
		}

		/// <summary>
		/// デストラクタ
		/// </summary>
		~DataSetHolderComponent()
		{
			this.Dispose();
		}

		/// <summary>
		/// データセットホルダーを表します。
		/// </summary>
		public DataSetHolder Holder
		{
			get
			{
				return( this._holder );
			}
		}

		#region IComponent メンバ

		/// <summary>
		/// リソースが解放された場合に発生するイベントを表します。
		/// </summary>
		public event EventHandler Disposed;

		/// <summary>
		/// サイトを表します。
		/// </summary>
		public ISite Site
		{
			get
			{
				return( this._site );
			}
			set
			{
				this._site = value;
			}
		}

		#endregion

		#region IDisposable メンバ

		/// <summary>
		/// リソースの解放を行います。
		/// </summary>
		public void Dispose()
		{
			if( !this._isDisposed )
			{
				this._site = null;

				if( this.Disposed != null )
				{
					this.Disposed( this, new EventArgs() );
				}

				this._isDisposed = true;
			}
		}

		#endregion
	}
}
