﻿using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;

namespace NDac.Sample
{
	/// <summary>
	/// テーブルのデータ削除者を表します。
	/// </summary>
	class TableTruncater : List< string >
	{
		private string			_connectionString;
		private List< string >	_ignore;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		public TableTruncater( string connectionString )
		{
			this._connectionString = connectionString;

			this._ignore = new List< string >();
		}

		/// <summary>
		/// 無視するテーブルのリストを表します。
		/// </summary>
		public List< string > Ignore
		{
			get
			{
				return( this._ignore );
			}
		}

		/// <summary>
		/// 全テーブルからデータを削除します。
		/// </summary>
		public void ExecuteAll()
		{
			DataTable		table		= new DataTable();

			List< string >	tableNames	= new List< string >();

			string			sql			= "SELECT name FROM sysobjects WHERE xtype = 'U'";

			using( SqlConnection connection = new SqlConnection( this._connectionString ) )
			{
				connection.Open();

				this.CreateDataAdapter( connection, sql ).Fill( table );
			}

			foreach( DataRow row in table.Rows )
			{
				tableNames.Add( ( string )row[ "name" ] );
			}

			this.Execute( tableNames );
		}

		/// <summary>
		/// データアダプターを作成します。
		/// </summary>
		/// <param name="connection">接続</param>
		/// <param name="selectQuery">SELECT文</param>
		/// <returns>データアダプター</returns>
		private SqlDataAdapter CreateDataAdapter( SqlConnection connection, string selectQuery )
		{
			return( new SqlDataAdapter( new SqlCommand( selectQuery, connection ) ) );
		}

		/// <summary>
		/// 指定されたテーブルからデータを削除します。
		/// </summary>
		public void Execute()
		{
			this.Execute( ( List< string > )this );
		}

		/// <summary>
		/// 指定されたテーブルからデータを削除します。
		/// </summary>
		/// <param name="tableNames">テーブル名リスト</param>
		public void Execute( List< string > tableNames )
		{
			using( SqlConnection connection = new SqlConnection( this._connectionString ) )
			{
				connection.Open();

				using( SqlTransaction transaction = connection.BeginTransaction() )
				{
					foreach( string tableName in tableNames )
					{
						if( !this._ignore.Contains( tableName ) )
						{
							SqlCommand command = connection.CreateCommand();

							command.Transaction = transaction;
							command.CommandType = CommandType.Text;
							command.CommandText = string.Format( "TRUNCATE TABLE {0}", tableName );
							command.ExecuteNonQuery();
						}
					}

					transaction.Commit();
				}
			}
		}
	}
}
