using System;
using System.Data;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.Attributes;

namespace NDac.Modules.Entities
{
	/// <summary>
	/// Publisherテーブルのエンティティを表します。
	/// </summary>
	public partial class PublisherEntity : Entity< PublisherKey >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="row">データテーブル</param>
		public PublisherEntity( DataRow row )
			: base( row )
		{
		}

		/// <summary>
		/// Idを表します。
		/// </summary>
		[ PrimaryKey( "Id", typeof( long ) ) ]
		public long Id
		{
			get
			{
				return( ( this._row[ "Id" ] == DBNull.Value ) ? default( long ) : ( long )this._row[ "Id" ] );
			}
			set
			{
				this._row[ "Id" ] = value;
			}
		}

		/// <summary>
		/// Nameを表します。
		/// </summary>
		public string Name
		{
			get
			{
				return( ( this._row[ "Name" ] == DBNull.Value ) ? default( string ) : StringCutDowner.Variable( ( string )this._row[ "Name" ], 50 ) );
			}
			set
			{
				this._row[ "Name" ] = ( value == null ? ( object )DBNull.Value : StringCutDowner.Variable( value, 50 ) );
			}
		}

		/// <summary>
		/// エンティティの内容をコピーします。この操作は値のみのコピーです。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		public void Copy( PublisherEntity source )
		{
			base.Copy( source );
		}

		/// <summary>
		/// プライマリキーに取得します。
		/// </summary>
		/// <returns>プライマリキー</returns>
		protected override PublisherKey ToPrimaryKey()
		{
			return( new PublisherKey( this.Id ) );
		}
	}
}
